; @(#)compile.t, Dirk Haun, 11.05.1996
; Unter-Takefile: C-Quelltext compilieren
;
env ERRORS=$OBJ\errors.out
if !env(CCEXT) || env(CCEXT=)
  env CCEXT=c
endif
echo Compiling "%%.$CCEXT"
repeat
  if env(PROJECT)                       ;  luft ein Projekt?
    cc $OPTC $* $MINTINC %.$CCEXT >$ERRORS ; ja, Compiler so aufrufen
  else
    cc #2 %.$CCEXT >$ERRORS             ;    nein, Compileroptionen bernehmen
  endif
  ; Die folgenden Zeilen brechen das bersetzen ab, wenn in der Fehlerdatei
  ; das Wort "Warning" auftaucht. Wenn man das nicht will oder keinen
  ; grep zur Hand hat, kann man die Zeilen auch auskommentieren (ein
  ; Semikolon vor die Zeilen schreiben) und durch die darunter folgenden
  ; Zeilen ersetzen (dort dann das Semikolon entfernen).
  if $?==0                              ;   kein Fehler?
    grep Warning $ERRORS >NIL:          ;     Text `Warning' in errors.out?
    if $?                               ;     nicht gefunden?
      rm -q $ERRORS                     ;       nein, lschen
    endif
  endif
  ; Bei Warnings nicht abbrechen
  ; if $?==0                              ;   kein Fehler?
  ;   rm -q $ERRORS                       ;       Fehlerdatei lschen
  ; endif
  if $ERRORS                            ;   existiert errors.out?
    errfile $ERRORS %.$CCEXT            ;     ja, Editor aufrufen
    if env(SEPROTO)                     ;     SE-Protokoll?
      return -42                        ;       ja, dann hier abbrechen
    elsif $?==0                         ;     sonst: nicht nochmal compilieren?
      return -1                         ;       Abbruch
    endif
  else                                  ;   erfolgreich bersetzt
    mv %.o $OBJ\%%.o                    ;   Objektdatei ins OBJ-Verzeichnis
  endif
until !$ERRORS                          ;  bis kein errors.out mehr existiert
env ERRORS
