page ,127
Comment ~

BLOX.ASM is a set of speed-optimized routines for use with my WINDOWS package
version 4.1, written in TURBO Pascal v3.02.

Declare this in Pascal:

procedure getBox (xLeft, yTop, xWidth, yLen: integer;
                  boxPointer, pageBufferPointer: screenBufferPointer);
                  EXTERNAL 'BLOX4A.BIN';

procedure putBox (xLeft, yTop, xWidth, yLen: integer;
                  boxPointer, pageBufferPointer: screenBufferPointer);
                  EXTERNAL getBox[3];

Procedures (C) 1989 By Daniel Singer


Use of important registers:
  DS -- Segment address of source
  SI -- Ofset address of source
  ES -- Segment address of destination
  DI -- Ofset address of destination
  BP -- Copy of TURBO's stack pointer upon entry (to access variables)

~
workStack    equ 20
bytesPerLine equ 160

preserveTurbo MACRO
                push bp      ;saves turbo state
                mov bp, sp
                sub sp, workStack    ;give some headroom
                push ds
                push si
                push es
                push di
                push ax              ;just to be sure, push 'em all
                push bx
                push cx
                push dx
              ENDM

restoreTurbo MACRO
               pop dx
               pop cx
               pop bx
               pop ax
               pop di
               pop es
               pop si
               pop ds
               mov sp, bp
               pop bp
               ret 16         ; 2 * 4 bytes/pointer + 4 * 2 bytes/integer
             ENDM

getVar       MACRO bpOfset,destination
               mov ax,[bp+bpOfset]     ; gets var from turbo param list
               mov destination, ax
             ENDM

blockMove MACRO
            cld
            rep movsb
          ENDM

calcPageBufferOfset MACRO register ;adds correct value to reg
                      getVar 16 bx   ; get yTop
                      dec bx         ; starts at 0, not 1
                      mov ax, bx     ; get ready to multiply lines by bytesPer
                      mov bx, 10
                      shl ax, 1      ; x2
                      shl ax, 1      ; x4
                      shl ax, 1      ; x8
                      shl ax, 1      ; x16
                      mul bx         ; x160   ax * bx --> DXAX
                      add register, ax     ; push offset to the right line
                      getVar 18 bx   ; get xLeft
                      dec bx         ; starts at 0, not 1
                      shl bx, 1      ; x2
                      add register, bx     ; final ofset
                    ENDM

Code               Segment
                     assume cs:code
                     jmp getBox      ; [0] entry
  putbox:            preserveTurbo   ; [3] entry
                     getVar  4 di    ; page buffer ofset    PB DEST
                     getVar  6 es    ; page buffer segment
                     getVar  8 si    ; boxPointer ofset
                     getVar 10 ds    ; boxPointer segment
                     calcPageBufferOfset di
                     getVar 12 bx    ; y length
                     getVar 14 dx    ; x width
                     shl dx, 1       ; x2 bytes per x
              pRow:  mov cx, dx      ; init column counter
                     push di         ; save page buffer ofset
                     blockMove
                     pop di          ; di = old offset
                     add di, bytesPerLine ; new row
                     dec bx          ; tally a line
                     jnz pRow        ; more rows
  donePutBox:        restoreTurbo    ; includes RET

  getBox:            preserveTurbo   ; [0] Entry
                     getVar  4 si    ; page buffer ofset     PB SOURCE
                     getVar  6 ds    ; page buffer segment
                     getVar  8 di    ; boxPointer ofset
                     getVar 10 es    ; boxPointer segment
                     calcPageBufferOfset si
                     getVar 12 bx    ; y length
                     getVar 14 dx    ; x width
                     shl dx, 1       ; x2 bytes per x
              gRow:  mov cx, dx      ; init column counter
                     push si         ; save page buffer ofset
                     blockMove
                     pop si          ; si = old offset
                     add si, bytesPerLine ; new row
                     dec bx          ; tally a line
                     jnz gRow        ; more rows
  doneGetBox:        restoreTurbo    ; includes RET
Code               Ends
End