;----------------------------------------------------------------------------
;File name:	FASTPOLL.S			Revision date:	2004.02.23
;Revised by:	Ulf Ronald Andersson		Creation date: 	2001.02.26
;Created by:	Ulf Ronald Andersson
;----------------------------------------------------------------------------
;Purpose:	API and IP kernel package
;		Module for fast high-speed port polling
;----------------------------------------------------------------------------
	.include	"uran\struct.sh"
	.include	"sting\transprt.sh"
	.include	"sting\port.sh"
;----------------------------------------------------------------------------
	.export	poll_ports	;void	poll_ports(void);
	.export	poll_single_tx	;void	poll_single_tx(PORT *pollport);
	.export	pe_poll_send	;int32	cdecl	pe_poll_send(void *dummy);
;----------------------------------------------------------------------------
	.import	conf
	.import	my_port
	.import	fetch_dgram
	.import	process_dgram
;----------------------------------------------------------------------------
conf_ports	=	426	;offset from (&conf) to (&conf.ports)
conf_interupt	=	438	;offset from (&conf) to (&conf.interupt)
conf_stat_all	=	446	;offset from (&conf) to (&conf.stat_all)
;----------------------------------------------------------------------------
struct	func_list	;structure for timer interrupt function list
	func_p	FNL_function
	struc_p	FNL_next
d_end	func_list
;----------------------------------------------------------------------------
;void	poll_ports(void);
;----------------------------------------------------------------------------
poll_ports:
	moveq	#3,d0
;-------
	movem.l	a2-a4,-(sp)		;push entry regs
	lea	conf.l,a1		;a1 -> global config struct
	move.l	conf_ports(a1),a4	;a4 = conf.ports -> port list
;-------
	move.l	a4,a2			;a2 -> first entry in port list
	move.l	a2,d0			;test a2 -> pollport
	ble.s	.rx_done_1		;skip at end of list
.rx_loop_1:
	move.l	prt_des_name(a2),a3	;a3 -> pollport name
	tas	(a3)			;test and block poll semaphore
	bmi.s	.rx_done_2		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_receive(a0),a0	;a0 -> receive function of driver
	jsr	(a0)			;call receive function of driver
	addq	#4,sp			;pop argument off stack
;
	move.l	prt_des_receive(a2),d0	;d0 -> reception queue unless NULL
	beq.s	.rx_stop_2		;if queue empty, go stop rx_poll
.rx_loop_2:
	move.l	a2,a0			;a0 -> port struct  (as argument)
	bsr	fetch_dgram		;call fetch_dgram(pollport)
	move.l	a0,d0			;d0 -> datagram unless NULL
	beq.s	.rx_stop_2		;if no datagram, go stop rx_poll
;
	lea	conf.l,a1		;a1 -> global config struct
	addq.l	#1,conf_stat_all(a1)	;conf.stat_all++;
	move.l	a2,IPDG_recvd(a0)	;datagram->recvd = pollport
	bsr	process_dgram		;call process_dgram (datagram)
	bra.s	.rx_loop_2		;loop back for more rx datagrams
;-------
.rx_stop_2:
	bclr	#7,(a3)			;release pollport poll semaphore
.rx_done_2:
	move.l	prt_des_next(a2),a2	;a2 -> next port to poll, unless NULL
	move.l	a2,d0			;test a2 -> pollport
	bgt.s	.rx_loop_1		;loop back until all ports polled
.rx_done_1:
;-------
; At this point all data received from external ports or local APPs has been
; routed to some destination send queue. Packets addressed to local machine
; will have been placed in the send queue of the internal port, as that is
; in fact used for receiving datagrams...  But data for local APPs has not
; yet been processed by protocol modules.
;-------
	lea	my_port.l,a2		;a2 -> internal port
	move.l	prt_des_name(a2),a3	;a3 -> pollport name
	tas	(a3)			;test and block poll semaphore
	bmi.s	.tx_done_1		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_send(a0),a0	;a0 -> send function of driver
	jsr	(a0)			;call send function of driver
	addq	#4,sp			;pop argument off stack
.tx_stop_1:
	bclr	#7,(a3)			;release poll semaphore
.tx_done_1:
;-------
; At this point all data for local APPs has been processed by protocol handlers,
; but their cyclic timer functions have not yet been called. This is done below.
;-------
	lea	conf.l,a2
	move.l	conf_interupt(a2),a2	;a2 -> timer interrupt function list
	move.l	a2,d0
	ble.s	.timer_done
.timer_loop:
	move.l	FNL_function(a2),a0
	jsr	(a0)			;call module timer function
	move.l	FNL_next(a2),a2
	move.l	a2,d0
	bgt.s	.timer_loop
.timer_done:
;-------
; At this point all protocol handling of incoming data has been completed,
; but any resulting responses are still waiting in the internal receive queue.
;-------
	lea	my_port.l,a2		;a2 -> internal port
	move.l	prt_des_name(a2),a3	;a3 -> pollport name
	tas	(a3)			;test and block poll semaphore
	bmi.s	.rx_done_3		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_receive(a0),a0	;a0 -> receive function of driver
	jsr	(a0)			;call receive function of driver
	addq	#4,sp			;pop argument off stack
;
	move.l	prt_des_receive(a2),d0	;d0 -> reception queue unless NULL
	beq.s	.rx_stop_3		;if queue empty, go stop rx_poll
.rx_loop_3:
	move.l	a2,a0			;a0 -> port struct  (as argument)
	bsr	fetch_dgram		;call fetch_dgram(pollport)
	move.l	a0,d0			;d0 -> datagram unless NULL
	beq.s	.rx_stop_3		;if no datagram, go stop rx_poll
;
	lea	conf.l,a1		;a1 -> global config struct
	addq.l	#1,conf_stat_all(a1)	;conf.stat_all++;
	move.l	a2,IPDG_recvd(a0)	;datagram->recvd = pollport
	bsr	process_dgram		;call process_dgram (datagram)
	bra.s	.rx_loop_3		;loop back for more rx datagrams
;-------
.rx_stop_3:
	bclr	#7,(a3)			;release pollport poll semaphore
.rx_done_3:
;-------
; At this point all automatic response packets have been routed to send queues.
; The code below sends all data for remote machines through the port drivers.
;-------
	move.l	a4,a2			;a2 -> first entry in port list
	move.l	a2,d0			;test a2 -> pollport
	ble.s	.tx_done_2		;skip at end of list
.tx_loop_2:
	cmpa.l	#my_port,a2		;is this the internal port
	beq.s	.tx_done_3		;avoid repeating internal sending
	move.l	prt_des_name(a2),a3	;a3 -> pollport name
	tas	(a3)			;test and block poll semaphore
	bmi.s	.tx_done_3		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_send(a0),a0	;a0 -> send function of driver
	jsr	(a0)			;call send function of driver
	addq	#4,sp			;pop argument off stack
.tx_stop_3:
	bclr	#7,(a3)			;release poll semaphore
.tx_done_3:
	move.l	prt_des_next(a2),a2	;a2 -> next port to poll, unless NULL
	move.l	a2,d0			;test a2 -> pollport
	bgt.s	.tx_loop_2		;loop back until all ports polled
.tx_done_2:
;-------
	movem.l	(sp)+,a2-a4		;pull entry regs
	rts				;return to caller
;----------------------------------------------------------------------------
; End of func:	poll_ports
;----------------------------------------------------------------------------
;void	poll_singleport(PORT *pollport);
;----------------------------------------------------------------------------
poll_singleport:
	movem.l	a2/a3,-(sp)		;push entry regs
	move.l	a0,a2			;a2 -> pollport struct
	move.l	prt_des_name(a2),a3	;a3 -> pollport name
;-------
	tas	(a3)			;test and block poll semaphore
	bmi.s	.rx_poll_done		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_receive(a0),a0	;a0 -> receive function of driver
	jsr	(a0)			;call receive function of driver
	addq	#4,sp			;pop argument off stack
;
	move.l	prt_des_receive(a2),d0	;d0 -> reception queue unless NULL
	beq.s	.rx_poll_stop		;if queue empty, go stop rx_poll
;
.rx_poll_loop:
	move.l	a2,a0			;a0 -> port struct  (as argument)
	bsr	fetch_dgram		;call fetch_dgram(pollport)
	move.l	a0,d0			;d0 -> datagram unless NULL
	beq.s	.rx_poll_stop		;if no datagram, go stop rx_poll
;
	lea	conf.l,a1		;a1 -> global config struct
	addq.l	#1,conf_stat_all(a1)	;conf.stat_all++;
	move.l	a2,IPDG_recvd(a0)	;datagram->recvd = pollport
	bsr	process_dgram		;call process_dgram (datagram)
	bra.s	.rx_poll_loop		;loop back for more rx datagrams
;-------
.rx_poll_stop:
	bclr	#7,(a3)			;release poll semaphore
.rx_poll_done:
;-------
	tas	(a3)			;test and block poll semaphore
	bmi.s	.tx_poll_done		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_send(a0),a0	;a0 -> send function of driver
	jsr	(a0)			;call send function of driver
	addq	#4,sp			;pop argument off stack
.tx_poll_stop:
	bclr	#7,(a3)			;release tx_poll semaphore
.tx_poll_done:
;-------
	movem.l	(sp)+,a2/a3		;pull entry regs
	rts				;return to caller
;----------------------------------------------------------------------------
; End of func:	poll_singleport
;----------------------------------------------------------------------------
;int32	cdecl	pe_poll_send(void *dummy);
;void	poll_internal_rx();
;void	poll_single_rx(PORT *pollport);
;----------------------------------------------------------------------------
pe_poll_send:				;xfer IP_send data to IP_system
	move	8(sp),d0		;d0 = pre_call sr
	move	sr,d1			;d1 = current sr
	and	#$F8FF,d1		;d1 = current sr with 0 int_mask
	and	#$0700,d0		;d0 = pre_call int_mask
	or	d0,d1			;d1 = current sr with pre_call int_mask
	move	d1,sr			;restore pre_call int_mask to sr
poll_internal_rx:			;xfer data from local APPs to IP system
	lea	my_port.l,a0		;a0 -> internal port
poll_single_rx:				;xfer data from one port to IP system
	movem.l	a2/a3,-(sp)		;push entry regs
	move.l	a0,a2			;a2 -> pollport struct
	move.l	prt_des_name(a2),a3	;a3 -> pollport name
;-------
	tas	(a3)			;test and block poll semaphore
	bmi.s	.rx_poll_done		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_receive(a0),a0	;a0 -> receive function of driver
	jsr	(a0)			;call receive function of driver
	addq	#4,sp			;pop argument off stack
;
	move.l	prt_des_receive(a2),d0	;d0 -> reception queue unless NULL
	beq.s	.rx_poll_stop		;if queue empty, go stop rx_poll
;
.rx_poll_loop:
	move.l	a2,a0			;a0 -> port struct  (as argument)
	bsr	fetch_dgram		;call fetch_dgram(pollport)
	move.l	a0,d0			;d0 -> datagram unless NULL
	beq.s	.rx_poll_stop		;if no datagram, go stop rx_poll
;
	lea	conf.l,a1		;a1 -> global config struct
	addq.l	#1,conf_stat_all(a1)	;conf.stat_all++;
	move.l	a2,IPDG_recvd(a0)	;datagram->recvd = pollport
	bsr	process_dgram		;call process_dgram (datagram)
	bra.s	.rx_poll_loop		;loop back for more rx datagrams
;-------
.rx_poll_stop:
	bclr	#7,(a3)			;release poll semaphore
.rx_poll_done:
;-------
	movem.l	(sp)+,a2/a3		;pull entry regs
	rts				;return to caller
;----------------------------------------------------------------------------
; End of func:	poll_single_rx
;----------------------------------------------------------------------------
;void	poll_internal_tx(void);
;void	poll_single_tx(PORT *pollport);
;----------------------------------------------------------------------------
poll_internal_tx:			;For sending to local applications
	lea	my_port.l,a0		;a0 -> internal port
poll_single_tx:				;For external tx, or locally to APPs
	movem.l	a2/a3,-(sp)		;push entry regs
	move.l	a0,a2			;a2 -> pollport struct
	move.l	prt_des_name(a2),a3	;a3 -> pollport name
;-------
	tas	(a3)			;test and block poll semaphore
	bmi.s	.tx_poll_done		;if already blocked, skip this poll
;
	move.l	a2,-(sp)		;push -> pollport struct  (as argument)
	move.l	prt_des_driver(a2),a0	;a0 -> driver struct
	move.l	drv_des_send(a0),a0	;a0 -> send function of driver
	jsr	(a0)			;call send function of driver
	addq	#4,sp			;pop argument off stack
.tx_poll_stop:
	bclr	#7,(a3)			;release poll semaphore
.tx_poll_done:
;-------
	movem.l	(sp)+,a2/a3		;pull entry regs
	rts				;return to caller
;----------------------------------------------------------------------------
; End of func:	poll_singleport_tx
;----------------------------------------------------------------------------
; End of file:	FASTPOLL.S
;----------------------------------------------------------------------------
