;----------------------------------------------------------------------------
;File name:	HELLO.S				Revision date:	1999.05.16
;Creator:	Ronald Andersson		Creation date:	1999.05.16
;(c)1999 by:	Ronald Andersson		All rights reserved  :-)
;----------------------------------------------------------------------------
	section	TEXT
;----------------------------------------------------------------------------
rz:					;relative zero point for the assembly
BASEPAGE	=	rz-$100
;----------------------------------------------------------------------------
initial_start:
	move.l	a0,d0				;d0 -> ACC BASEPAGE or is NULL
	sne	ACC_flag			;ACC_flag flags ACC/non_ACC
	bne.s	have_bp				;keep ptr in d0 for ACC
	move.l	4(sp),d0			;d0 -> BASEPAGE of non_ACC
have_bp:
	move.l	d0,a5				;a5 -> BASEPAGE
	lea	local_stack_top,sp		;setup local stack
	tst	ACC_flag			;test for ACC startup
	bne.s	I_refuse_to_be_ACC		;refuse ACC usage
;
	move.l	$18(a5),d0			;d0 -> BSS base
	add.l	$1C(a5),d0			;d0 -> BSS end
	sub.l	a5,d0				;d0 = total size, incl basepage
;
	move.l	d0,-(sp)			;push prog size
	pea	(a5)				;push basepage ptr
	move	#0,-(sp)			;push dummy word
	move	#$4A,-(sp)			;push gemdos Mshrink opcode
	trap	#1				;call gemdos
	add	#10,sp				;clean stack
;
	pea	Hello_I_am_HELLO_s		;push string pointer
	bsr.s	Cconws_sub			;display the string
	addq	#4,sp				;clean stack
;
	move	#$00,-(sp)			;push gemdos Pterm0 opcode
	trap	#1
;-------------------------------------
I_refuse_to_be_ACC:
	pea	I_refuse_to_be_ACC_s		;push string pointer
	bsr.s	Cconws_sub			;display the string
	addq	#4,sp				;clean stack
ACC_loop:
	move	#$C9,d0				;d0 = XGEM _appl_yield opcode
	trap	#2				;call XGEM (unblocks tasks)
	bra.s	ACC_loop			;loop forever
;-------------------------------------
Cconws_sub:
	move.l	4(sp),-(sp)			;repush string pointer
	move	#$09,-(sp)			;push gemdos Cconws opcode
	trap	#1				;call gemdos
	addq	#6,sp				;clean stack
	rts					;return to caller
;----------------------------------------------------------------------------
	section	DATA
;----------------------------------------------------------------------------
Hello_I_am_HELLO_s:
	dc.b	13,10
	dc.b	'Hello !  I am named HELLO.',13,10
	dc.b	0
;-------------------------------------
I_refuse_to_be_ACC_s:
	dc.b	13,10
	dc.b	'Sorry, this is not an ACCessory.',13,10
	dc.b	'All I can do now is to loop, as it',13,10
	dc.b	'is illegal for ACCs to terminate.',13,10
	dc.b	'I will try not to block the other',13,10
	dc.b	'tasks, but I advice you to use me',13,10
	dc.b	'as a normal program next time.',13,10
	dc.b	0
	even
;----------------------------------------------------------------------------
	section	BSS
;----------------------------------------------------------------------------
ACC_flag:	ds.w	1		;flags ACC/non_ACC usage
local_stack:
		ds.b	8192		;plenty of stack space
local_stack_top:
bss_end:
;----------------------------------------------------------------------------
	END
;----------------------------------------------------------------------------
;End of file:	HELLO.S
;----------------------------------------------------------------------------
