;----------------------------------------------------------------------------
;	This section contains the code used to initialize M_dta handlers
;	by connecting all M_dta entries to a doubly linked list with a
;	root pointer for each end of the list.  In addition to this, the
;	word variable M_dta_count should be cleared.
;
;	The constant DTA_limit appearing below defines the number of M_dta
;	entries, and for BetaDOS this constant is 100.
;----------------------------------------------------------------------------
	moveq	#DTA_limit-1,d2
	lea	M_dta_t(pc),a0
	move.l	a0,M_dta_first		;init M_dta_first -> array base
	clr.l	d1			;d1 = NULL as initial -> prev
init_M_dta_t:
	move.l	a0,d0			;d0 = this
	lea	sizeof_M_dta(a0),a1	;a1 -> next
	move.l	d1,(a0)+		;link this to prev
	move.l	a1,(a0)+		;link this to next
	clr.l	(a0)+			;NULL -> DTA
	clr.l	(a0)+			;NULL -> DOS
	clr.b	(a0)			;NUL path string
	move.l	d0,d1			;prev = this
	move.l	a1,a0			;this = next
	dbra	d2,init_M_dta_t
	move.l	d1,a0			;a0 -> last entry
	clr.l	M_dta_next(a0)		;NULL -> next of last entry
	move.l	a0,M_dta_last		;init M_dta_last -> last entry
;----------------------------------------------------------------------------
