;----------------------------------------------------------------------------
;	This section contains the subroutines for Fsnext and Fsfirst,
;       as defined for and used by the BetaDOS gemdos dispatcher.
;
;	At entry, their arguments (incl gemdos opcode) are stored at
;	4(sp), with the long at 0(sp) being the return address to the
;	calling dispatcher.  Returning E_1001 to that dispatcher will
;	result in it jumping to older gemdos levels instead of dealing
;	with the function internally.
;
;	Some vital subroutines dealing with extended M_dta structures
;	are called here, and those subroutines are defined in the section
;	file M_DTALIB.S, with the structure itself being defined in M_DTA.S
;
;	sub_gemdos is a special macro that simulates a new gemdos call in
;	a way that only reaches the older gemdos layers.  The generic recipe
;	for doing this is as follows:
;
;	1:	Push arguments to the gemdos function, including opcode,
;		onto stack.
;	2:	Test system variable '_longframe', and if it is not zero
;		push a zero word onto stack.
;	3:	Push the address where you want to return after the call
;		onto stack.
;	4:	Push the CPU status register onto stack.
;	5:	Fetch the address of older gemdos layer from your XBRA struct,
;		put it in an address register, and jump indirectly to it.
;	6:	At the location pointed to by the address in step '3:' above,
;		pop arguments of the called function off stack and continue.
;
;NB:	Steps 2-4 are a generic way of simulating exceptions from within an
;	already active exception handler.  I have often found this useful.
;----------------------------------------------------------------------------
;Start of:	MD_func_Fsnext
;----------------------------------------------------------------------------
MD_func_Fsnext:
	sub_gemdos	Fgetdta		;d0 = active dta
	move.l	d0,a0			;a0 -> active_dta
	bsr	seek_dta_a0_in_M_dta	;was this dta defined previously ?
	ble	E_1001_sub		;if not, tell dispatcher to use old gemdos
	bsr	put_M_dta_a0_last	;ensure long M_dta life after each ref
	move.l	M_dta_DTA(a0),a5	;a5 -> dta
	lea	M_dta_path(a0),a4	;a4 -> expanded path for this dta
	move.l	M_dta_DOS(a0),a0	;a0 -> DOS
	movea.l	DOS_LDB_p(a0),a3	;a3 -> LDB
	movea.l	DOS_func_tp(a0),a6	;a6 -> DOS functions
	move.l	4*(Fsnext&$ff)(a6),d1	;d1 -> device function
	bmi	E_INVFN_sub		;MetaDos uses E_UNCMD for this
	movea.l	d1,a2			;a2 -> device function
	move.l	(sp)+,reent_retadr	;pull reent_retadr -> retadr
	jsr	(a2)			;call device function
	move.l	reent_retadr(pc),-(sp)	;push reent_retadr as retadr
	tst.l	d0
	beq.s	.exit_fsnext
.func_failed:
	move.l	d0,-(sp)		;push error code
	sub_gemdos	Fgetdta		;d0 = active dta
	move.l	d0,a0			;a0 -> active_dta
	bsr	seek_dta_a0_in_M_dta	;was this dta defined previously ?
	ble.s	.done_release
	bsr	release_M_dta_a0	;release found M_dta entry
.done_release:
	move.l	(sp)+,d0		;pull error code to d0
.exit_fsnext:
	rts
;----------------------------------------------------------------------------
;End of:	MD_func_Fsnext
;----------------------------------------------------------------------------
;Start of:	MD_func_Fsfirst
;----------------------------------------------------------------------------
MD_func_Fsfirst:
	movea.l	6(sp),a0
	bsr	find_path_DOS		;a0 -> DOS
	bmi	release_non_M_dta	;if not a meta_drive, release M_dta
	move.l	a0,current_DOS
	movea.l	6(sp),a1
	bsr	expand_path
	bmi.s	release_PTHNF_M_dta
;
	sub_gemdos	Fgetdta		;d0 = active dta
	move.l		d0,current_DTA	;current_DTA = active dta
	move.l	d0,a0			;a0 -> active_dta
	bsr	seek_dta_a0_in_M_dta	;was this dta defined previously ?
	bgt.s	.update_M_dta		;if it was, just update it now
.dta_not_found:
	bsr	reserve_new_M_dta	;else get a new entry
	bra.s	.update_content		;go update the contents of the M_dta
;
.update_M_dta:
	bsr	put_M_dta_a0_last	;ensure long M_dta life after each ref
.update_content:
	move.l	current_DTA(pc),M_dta_DTA(a0)
	move.l	current_DOS(pc),M_dta_DOS(a0)
	lea	expanded_path(pc),a1
	lea	M_dta_path(a0),a0
	move	#PATH_limit-2,d0
.copy_path_loop:
	move.b	(a1)+,(a0)+
	dbeq	d0,.copy_path_loop
	clr.b	(a0)
;
	sub_gemdos	Fgetdta			;d0 = active dta
	movea.l		current_DTA(pc),a5	;a5 -> dta
	lea		expanded_path(pc),a4	;a4 -> expanded pathname
	movea.l		current_DOS(pc),a0
	movea.l		DOS_LDB_p(a0),a3	;a3 -> logical device block
;
	movea.l	DOS_func_tp(a0),a6			;a6 -> DOS functions
	move.l	4*(Fsfirst&$ff)(a6),d1	;d1 -> device function
	bmi.s	E_INVFN_sub			;MetaDos uses E_UNCMD for this
	movea.l	d1,a2				;a2 -> device function
;
	move.l	(sp)+,reent_retadr	;pull reent_retadr -> retadr
	jsr	(a2)			;call device function
	move.l	reent_retadr(pc),-(sp)	;push reent_retadr as retadr
	tst.l	d0
	bmi.s	release_M_dta_return_d0
.func_OK:
	clr.l	d0			;flag successful result
	rts
;
release_PTHNF_M_dta:
	moveq	#E_PTHNF,d0
	bra.s	release_M_dta_return_d0
;
release_non_M_dta:			;Here we release M_dta and use old gemdos
	move.l	#E_1001,d0		;tell dispatcher to use old gemdos
release_M_dta_return_d0:		;Here we release M_dta and return d0
	move.l	d0,-(sp)
	sub_gemdos	Fgetdta		;d0 = active dta
	move.l	d0,current_DTA		;current_DTA = active dta
	move.l	d0,a0			;a0 -> active_dta
	bsr	seek_dta_a0_in_M_dta	;was this dta defined previously ?
	ble.s	.exit			;if not, exit
	bsr	release_M_dta_a0	;release found M_dta entry
.exit:
	move.l	(sp)+,d0
	rts
;----------------------------------------------------------------------------
;End of:	MD_func_Fsfirst
;----------------------------------------------------------------------------
