;----------------------------------------------------------------------------
;	This section contains subroutines that allow handling of extended
;	DTA structs, as defined in M_DTA.S.  These subs are used by various
;	BetaDOS functions, but mainly by MD_func_Fsfirst and MD_func_Fsnext,
;	which are both defined in MDFUNCFS.S.
;
;	The intended usage is to implement reallocation of least recently
;	referred M_dta struct when the internal M_dta pool is used up.
;	Since no formal call to release DTA blocks exists, this is needed.
;	But BetaDOS also contains some routines that do allow release of
;	M_dta blocks when unrelated or wrongful use of the DTA blocks occur.
;
;	The pool consists of an array of structs, which are organized as
;	a doubly linked structure list.  BetaDOS presently uses 100 M_dta
;	structs, which suffices for all normal needs.
;
;	Three support variables are used for the M_dta handling.
;
;M_dta_count:	this is merely a 16bit word counter of M_dta structs in use
;M_dta_first:	pointer to the first M_dta in the list to be allocated next,
;		either because it is free, or because it is the one least
;		recently referred to (normally by Fsfirst or Fsnext).
;M_dta_last:	pointer to the most recently referred M_dta struct.  This is
;		where each M_dta struct is relinked when referred to.
;----------------------------------------------------------------------------
release_M_dta_a0:
	subq	#1,M_dta_count
put_M_dta_a0_first:
	movem.l	M_dta_prev(a0),d0/d1	;d0 = this.prev, d1 = this.next
	tst.l	d0			;is this already first ?
	beq.s	.exit			;just exit if nothing to do
	move.l	d0,a1			;a1 -> this.prev
	move.l	d1,M_dta_next(a1)	;prev.next = this.next
	beq.s	.patch_last		;skip patching next when last
	move.l	d1,a1			;a1 -> this.next
	move.l	d0,M_dta_prev(a1)	;next.prev = this.prev
	bra.s	.patch_first
;
.patch_last:
	move.l	d0,M_dta_last		;last = this.prev
.patch_first:
	move.l	M_dta_first(pc),a1	;a1 -> old_first
	move.l	a0,M_dta_prev(a1)	;old_first.prev = this
	move.l	a1,M_dta_next(a0)	;this.next = old_first
	clr.l	M_dta_prev(a0)		;this.prev = NULL
	move.l	a0,M_dta_first		;first = this
.exit:
	rts
;----------------------------------------------------------------------------
reserve_new_M_dta:
	move.l	M_dta_first(pc),a0	;a0 -> free or least used entry
	cmp	#DTA_limit,M_dta_count	;are any entries still free ?
	bhs.s	put_M_dta_a0_last	;if not, just redefine the least used.
	addq	#1,M_dta_count		;increment count when taking free ones
put_M_dta_a0_last:
	movem.l	M_dta_prev(a0),d0/d1	;d0 = this.prev, d1 = this.next
	tst.l	d1			;is this already last ?
	beq.s	.exit			;just exit if nothing to do
	move.l	d1,a1			;a1 -> this.next
	move.l	d0,M_dta_prev(a1)	;next.prev = this.prev
	beq.s	.patch_first		;skip patching prev when first
	move.l	d0,a1			;a1 -> this.prev
	move.l	d1,M_dta_next(a1)	;prev.next = this.next
	bra.s	.patch_last
;
.patch_first:
	move.l	d1,M_dta_first		;first = this.next
.patch_last:
	move.l	M_dta_last(pc),a1	;a1 -> old_last
	move.l	a0,M_dta_next(a1)	;old_last.next = this
	move.l	a1,M_dta_prev(a0)	;this.prev = old_last
	clr.l	M_dta_next(a0)		;this.next = NULL
	move.l	a0,M_dta_last		;last = this
.exit:
	rts
;----------------------------------------------------------------------------
seek_dta_a0_in_M_dta:
	move	M_dta_count(pc),d1	;any active entries ?
	beq.s	.not_found		;if not, then we can't find any
	subq	#1,d1			;d1 = adapted for dbcc
	move.l	M_dta_last(pc),a1	;this = last
.seek_loop:				;loop start
	move.l	a1,d0			;d0 = this
	cmpa.l	M_dta_DTA(a1),a0	;has this the same dta as in a0 ?
	movea.l	M_dta_prev(a1),a1	;this = this.prev
	dbeq	d1,.seek_loop		;loop back until done
	bne.s	.not_found		;go handle failure if none found
.found:
	move.l	d0,a0			;a0 -> found entry
	tst.l	d0			;flag result in sr
	rts				;return to caller
;
.not_found:
	clr.l	d0			;d0 = NULL with sr flagging
	move.l	d0,a0			;a0 = NULL pointer
	rts				;return to caller
;----------------------------------------------------------------------------
