;----------------------------------------------------------------------------
;	This section contains a function that locates the system variable
;	used by gemdos to indicate the basepage of the current task. This
;	implementation of the function should be compatible to most TOS,
;	although I have not had opportunity to test some old ones. It is
;	definitely compatible with TOS 1.04 and all newer variants.
;
;	In some init routine, you need to insert something like:
;
;	bsr	find_os_currbp_p
;	move.l	a0,loc_curr_bp_p_p
;
;	or possibly something like:
;
;	xbios	Supexec,find_os_currbp_p
;	move.l	a0,loc_curr_bp_p_p
;
;	The subroutine must execute in Supervisor mode
;----------------------------------------------------------------------------
_sysbase	= $4F2
;
os_version	= $02
os_selfbeg_p	= $08
os_config	= $1C
os_currbp_p_p	= $28
;----------------------------------------------------------------------------
find_os_currbp_p:
	movea.l	(_sysbase).w,a0
	movea.l	os_selfbeg_p(a0),a0
	cmpi.w	#$102,os_version(a0)	;TOS 1.02 ?
	bhs.s	.modern_TOS
	move.w	os_config(a0),d0
	lsr.w	#1,d0
	subq.w	#4,d0
	bne.s	.old_TOS_2
.old_TOS_1:
	move.l	#$873c,d0
	rts
;
.old_TOS_2:
	move.l	#$602c,d0
	rts
;
.modern_TOS:
	move.l	os_currbp_p_p(a0),d0
	rts
;----------------------------------------------------------------------------
