;----------------------------------------------------------------------------
;	This section contains the gemdos subroutines Dgetcwd and Dgetpath
;	Both return the current path for argument drive, but with different
;	string limits.
;
;	They refer to some variables and functions from other sections
;----------------------------------------------------------------------------
MD_func_Dgetcwd:
	move	12(sp),d0		;d0 = argument max path length
	bra.s	get_lim_path
;
MD_func_Dgetpath:
	move	#128,d0			;d0 = 128  standard max path length
get_lim_path:
	move	d0,d6			;d6 = max string length
	move	10(sp),d0		;d0 = drive_number+1
	subq	#1,d0			;d0 = drive_number
	bge.s	.use_drive		;for specific drive code, go use it
	bsr	MD_func_Dgetdrv		;else get current drive code
.use_drive:
	move.l	meta_drvbits(pc),d1	;d1 = bitmask of own drive(s)
	btst	d0,d1			;is the wanted drive ours ?
	beq	E_1001_sub		;use old gemdos for non-meta drives
;---------------------------------------------------
;------- The part below is BetaDOS specific --------
;---------------------------------------------------
	add	#'A',d0			;convert drive code to drive letter
	bsr	find_char_d0_DOS	;find DOS driver
	bmi	E_1001_sub		;try old gemdos on failing DOS driver
	subq	#1,d6			;prep char buffer length for dbra
	ble.s	E_RANGE_sub		;return E_RANGE on bad length
	movea.l	6(sp),a1		;a1 -> buffer for path
	lea	DOS_path(a0),a0		;a0 -> path in DOS
;---------------------------------------------------
;------- The part above is BetaDOS specific --------
;---------------------------------------------------
; At this point a0 should be pointing to the string buffer where you have
; previously stored the path which is current for this drive of yours.
;-------------------------------------------------------
	tst.b	(a0)			;is the string empty ?
	beq.s	.copy_loop		;go copy path if empty  :-)
	cmp.b	#':',1(a0)		;check for drive spec (error)
	bne.s	.copy_loop		;go copy absolute pure path
	addq	#2,a0			;skip drive spec when present
.copy_loop:
	move.b	(a0)+,(a1)+		;copy bytes of path
	dbeq	d6,.copy_loop		;loop until end or limit reached
	moveq	#E_OK,d0		;return OK
	rts				;exit to caller
;----------------------------------------------------------------------------
