;----------------------------------------------------------------------------
;	This section contains the gemdos subroutine Dsetpath
;----------------------------------------------------------------------------
MD_func_Dsetpath:
	movea.l	6(sp),a0		;a0 -> arg path string
;---------------------------------------------------
;------- The line below is BetaDOS specific --------
	bsr	find_path_DOS		;a0 -> DOS
;---------------------------------------------------
; What it does is to test if the argument path starts with a valid drivespec
; and if so if that drivespec is to a BetaDOS drive.  If not it returns with
; a negative flag.  If there is no drivespec, then MD_func_Dgetdrv is called
; and that drive code is then tested, with negative return if not a BetaDOS
; drive.  If a valid BetaDOS drive is found, by either method, then it will
; return positive, with a0 -> to a DOS struct for its driver.  That is fully
; specific for BetaDOS.  You shouldn't need all of that behaviour, but you
; must test the basics of course.
;---------------------------------------------------
	bmi	E_1001_sub		;tell dispatcher to use old gemdos
;---------------------------------------------------
;------- The line below is BetaDOS specific --------
	move.l	a0,current_DOS
;---------------------------------------------------
; It simply memorizes the pointer to the DOS driver.  You don't need it
;---------------------------------------------------
	movea.l	6(sp),a0		;a0 -> arg path string
.loop_1:
	move.b	(a0)+,d0		;string end ?
	beq.s	.un_wild
	cmpi.b	#'*',d0			;'*' wildcard ?
	beq	E_PTHNF_sub
	cmpi.b	#'?',d0			;'?' wildcard ?
	bne	.loop_1
	bra	E_PTHNF_sub
;
; The loop above checks for wildcard, as those are forbidden for Dsetpath
;
.un_wild:
;---------------------------------------------------
;------- The part below is BetaDOS specific --------
;---------------------------------------------------
	move.l	current_DOS(pc),a0
	movea.l	6(sp),a1		;a1 -> arg path string
	bsr	expand_path
	bmi	E_PTHNF_sub
;
	movea.l	DOS_func_tp(a0),a6
	move.l	4*(Dsetpath&$ff)(a6),d0	;d0 -> DOS function
	ble.s	.done_DOS_call		;skip call if unimplemented in DOS
	movea.l	d0,a2			;a2 -> DOS function
	lea	expanded_path(pc),a4
	movea.l	DOS_LDB_p(a0),a3
	move.l	(sp)+,reent_retadr
	jsr	(a2)			;call DOS Dsetpath
	move.l	reent_retadr(pc),-(sp)
	tst.l	d0
	bmi.s	.exit			;exit on error from DOS
.done_DOS_call:
;---------------------------------------------------
;------- The part above is BetaDOS specific --------
;---------------------------------------------------
; What it does is to expand the path given in the function argument
; according to various rules (eg: absent drive spec = current drive)
; The resulting path is thereby copied to the area named 'expanded_path'
; For you that can be a simple string buffer.  The code then calls the
; DOS driver for this drive, so that is the place where you insert any
; stuff specific for your driver.
;---------------------------------------------------
; The code below is where the path is finally stored in an area where
; it can later be found, to satisfy Dgetpath calls and future needs to
; expand relative paths on this drive.
;---------------------------------------------------
	lea	DOS_path(a0),a0		;a0 -> your drive path string
	lea	expanded_path+2(pc),a1	;a1 -> expanded argument string
.copy_loop:
	move.b	(a1)+,(a0)+		;copy bytes of string
	bne.s	.copy_loop		;loop for entire string
	clr.l	d0			;return E_OK
.exit:
	rts
;----------------------------------------------------------------------------
