;----------------------------------------------------------------------------
;	This section contains subroutines for Dsetdrv and Dgetdrv
;
;	They depend on the following variables:
;
;meta_drvbits:		32bit mask for drive(s) of own implementation
;gemdos_drvbits:	32bit mask for drive(s) of older gemdos
;loc_currbp_p_p:	ptr to ptr to current basepage  (from TOS header)
;bp_drive_index:	basepage offset value to current drive byte variable
;
;	A macro 'sub_gemdos' is also used to call older gemdos.
;
;	All things mentioned above are defined in other sections.
;----------------------------------------------------------------------------
MD_func_Dsetdrv:
	move		6(sp),d0		;d0 = argument drive code
	move.l		meta_drvbits(pc),d1	;d1 = bitmask of own drive(s)
	btst		d0,d1			;is this our drive ?
	bne.s		.set_meta_drive		;if so, go handle it locally
.non_meta_drive:			;Here drive belongs to older gemdos
;---------------------------------------------------
; Here we must call the older gemdos, in such a way that we can continue
; after it has finished its Dsetdrv work.  In BetaDOS I use a simple macro:
;	sub_gemdos	Dsetdrv,d0		;pass call to older gemdos
; but that is dependent on my DevPac libs, which you probably won't use.
; So a more explicit method follows below:
;---------------------------------------------------
	move		d0,-(sp)		;push drive code
	tst		(_longframe).w		;modern CPU ?
	beq.s		.cpu_adapted		;if not, skip frame type word
	clr		-(sp)			;push frame type for modern CPUs
.cpu_adapted:
	pea		.post_old_gemdos(pc)	;push frame retadr
	move		sr,-(sp)		;push frame sr
	movea.l		BNeT_XBRA+8(pc),a0	;a0 -> old gemdos dispatcher
	jmp		(a0)			;goto old gemdos dispatcher
;-------
.post_old_gemdos:
	addq		#2,sp			;pop drive code off stack
;---------------------------------------------------
; The label BNeT_XBRA refers to the base address of the XBRA struct of BNeT,
; beginning with the long value 'XBRA'.
;---------------------------------------------------
	move.l		d0,gemdos_drvbits	;note drvbits of old gemdos
	bra.s		.finish_Dsetdrv		;go finish the work
;-------
.set_meta_drive:
	move.l		gemdos_drvbits(pc),d0	;d0 = drvbits of old gemdos
.finish_Dsetdrv:
	or.l		meta_drvbits(pc),d0	;combine with own drvbits
	movea.l		loc_currbp_p_p(pc),a0	;a0 ->-> basepage of task
	movea.l		(a0),a0			;a0 -> basepage of task
	move		bp_drive_index,d1	;d1 = offset to variable
	move.b		7(sp),0(a0,d1.w)	;store drive code byte
	rts					;exit to caller
;----------------------------------------------------------------------------
MD_func_Dgetdrv:
	movea.l		loc_currbp_p_p(pc),a0	;a0 ->-> basepage of task
	movea.l		(a0),a0			;a0 -> basepage of task
	move		bp_drive_index(pc),d1	;d1 = offset to variable
	clr.l		d0			;preclear high d0 bits
	move.b		0(a0,d1),d0		;d0 = drive code byte
	bne.s		.exit			;if not 0, go exit
	pea		0(a0,d1)		;push -> variable
;---------------------------------------------------
; Here we must again call older gemdos, which I would do with
;	sub_gemdos	Dgetdrv			;pass call to older gemdos
; The explicit method follows below:
;---------------------------------------------------
	tst		(_longframe).w		;modern CPU ?
	beq.s		.cpu_adapted		;if not, skip frame type word
	clr		-(sp)			;push frame type for modern CPUs
.cpu_adapted:
	pea		.post_old_gemdos(pc)	;push frame retadr
	move		sr,-(sp)		;push frame sr
	movea.l		BNeT_XBRA+8(pc),a0	;a0 -> old gemdos dispatcher
	jmp		(a0)			;goto old gemdos dispatcher
;-------
.post_old_gemdos:
;---------------------------------------------------
	move.l		(sp)+,a0		;a0 = pulled -> variable
	move.b		d0,(a0)			;store drive code byte
.exit:
	rts					;exit to caller
;----------------------------------------------------------------------------
