;----------------------------------------------------------------------------
;	This section contains two subroutines:
;
;test_basepage_usage_safely:
;	This one should be called from an early part of your init code.
;	It will determine where in basepage a critical byte variable is.
;	This variable keeps track of the current drive of the task that
;	owns the basepage.  It is implemented similarily in all gemdos, but
;	a test is needed as offset differs between gemdos implementations.
;	The variable is needed for implementing Dsetdrv/Dgetdrv properly.
;
;	In these sources the variable that holds the basepage offset of that
;	byte variable is a 16bit word named 'bp_drive_index'.
;
;	The routine ruins lots of register, so presave them if needed.
;	If the routine returns zero something drastically new and wrong
;	has occurred.  (Has never happened.) You can then decide whether to
;	go ahead and use the default, or simply abort installation.
;
;test_basepage_usage_simply:
;	This subroutine is only called internally, by the one above.
;----------------------------------------------------------------------------
test_basepage_usage_safely:
	gemdos	Dgetdrv		;d0 = current drive
	move	d0,d5		;prep to test current drive
	bsr.s	test_basepage_usage_simply
	move.l	d3,d4		;d4 = bitmask for pos's matching current drive
	moveq	#15,d5		;prep to test for U:
	bsr.s	test_basepage_usage_simply
	and.l	d3,d4		;d4 = bitmask for pos's matching both drives
	moveq	#0,d5		;prep to test for A:
	bsr.s	test_basepage_usage_simply
	and.l	d3,d4		;d4 = bitmask for pos's matching three drives
	moveq	#2,d5		;prep to test for C:
	bsr.s	test_basepage_usage_simply
	and.l	d3,d4		;d4 = bitmask for pos's matching four drives
	beq.s	.error		;go .error if none match  (never happens)
;-------
	moveq	#9,d0		;test flag for offset $39  (a common value)
	btst	d0,d4		;was this bit valid for all four tests ?
	bne.s	.set_index	;if so, go use it
	moveq	#7,d0		;test flag for offset $37  (a common value)
	btst	d0,d4		;was this bit valid for all four tests ?
	bne.s	.set_index	;if so, go use it
;-------			;else we must find a non-standard offset
	clr.l	d1
	clr.l	d2
	moveq	#32-1,d0	;start searching mask from top
.loop:
	btst	d0,d4		;was this bit valid for all four tests ?
	beq.s	.next		;if not, go try the next lower one
	move	d0,d1		;if valid, save its index in d1
	addq	#1,d2		;increment success counter
.next:
	dbra	d0,.loop	;loop back for all bits in mask
	move	d1,d0		;d0 = last found valid index (the lowest)
.set_index:
	add	#$30,d0		;add offset to get real basepage index
	move	d0,bp_drive_index	;save finished index
	rts				;exit to caller
;-------
.error:					;This part should never be reached,
	move	#$7F,bp_drive_index	;so this default has never been used.
	clr.l	d0			;flag weird case by returning zero
	rts				;exit to caller
;----------------------------------------------------------------------------
test_basepage_usage_simply:
	gemdos	Dgetdrv			;d0 = current drive code
	move.w	d0,-(sp)		;push current drive code
	gemdos	Dsetdrv,d5		;Dsetdrv drive code to be tested
	clr.l	d3			;preclear result bitmask
	moveq	#32-1,d0		;test 32 basepage positions top-down
.loop:
	cmp.b	$30(a5,d0.w),d5		;test position in range $30..$4F
	bne.s	.next			;if not matching, go try next (lower)
	bset	d0,d3			;if matching, set bit in mask
.next:
	dbra	d0,.loop		;loop back for 32 positions
	gemdos	Dsetdrv,()		;Dsetdrv drive current on entry
	move.l	d0,gemdos_drvbits	;Initialize gemdos_drvbits
	rts				;exit to caller
;----------------------------------------------------------------------------
