#include <aes.h>
#include <ext.h>
#include <math.h>
#include <vdi.h>
#include <tos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define SMALLER 0x4000
#define	_AESnumapps   	(_GemParBlk.global[1])
#define WM_ICONIFY		34
#define WM_UNICONIFY	35
#define WM_ALLICONIFY	36
#define WF_ICONIFY		26
#define WF_UNICONIFY	27	

#define min(x,y) 	((x>y)?(y):(x))
#define max(x,y) 	((x>y)?(x):(y))
#define abs(x)		((x>0)?(x):-(x))
#define in(a,x,w)	( (a)>=(x) && (a)<(x)+(w)) 
#define Cos(r,a)	(x+w/2-1+((r)*cos(1.57-(a))))
#define Sin(r,a)	(y+h/2-1-((r)*sin(1.57-(a))))
#define CONTROL_U 0x15
#define CONTROL_Q 0x11
#define CONTROL_R 0x12

EVENT evnt={ MU_MESAG|MU_TIMER|MU_BUTTON|MU_KEYBD, 2,1,1,
			0,0,0,0,0,
			0,0,0,0,0,
			1000,0,	/* timer */
			0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0} ;

int vhandle;
int ap_id;
int nbcolor;

int bg=LWHITE;	/* background color */
int hcolor=BLUE,
    mcolor=LBLUE,
    scolor=LRED,
    p1color=LGREEN,
    p2color=LMAGENTA,
    tcolor=WHITE;

int	xw,yw,
	ww = 80,
	hw = 80,
	wattrib=0,
	open_if_acc=1;
char sizer[] = "";

int xd, yd, wd, hd;
	
int update=1;
int icon = 0;
int wclose = 0;


struct time heure, p_heure;

void set_color( int color)
{
	switch( nbcolor) {
	case 2:
		vsf_color( vhandle, (color==WHITE)?WHITE:BLACK);
		vsl_color( vhandle, (color==WHITE)?WHITE:BLACK);
		vst_color( vhandle, BLACK);
		return;
	case 4:
		switch( color) {
		case WHITE:
			vsf_color( vhandle, WHITE);
			vsl_color( vhandle, WHITE);
			vst_color( vhandle, BLACK);
			break;
		case RED:
		case LRED:
		case LMAGENTA:
		case MAGENTA:
			vsf_color( vhandle, RED);
			vsl_color( vhandle, RED);
			vst_color( vhandle, RED);
			break;
		case GREEN:
		case LGREEN:
		case LYELLOW:
		case YELLOW:
			vsf_color( vhandle, GREEN);
			vsl_color( vhandle, GREEN);
			vst_color( vhandle, GREEN);
			break;
		default:
			vsf_color( vhandle, BLACK);
			vsl_color( vhandle, BLACK);
			vst_color( vhandle, BLACK);
			break;
		}
		break;	
	default:
		vsf_color( vhandle, color);
		vsl_color( vhandle, color);
		vst_color( vhandle, color);
		return;
	}
}

/*
 *	Dessiner les aiguilles
 */

void draw_sec( int wh)
{
	int x, y, w, h; 
	int pxy[4];
	
	wind_get( wh, WF_WORKXYWH, &x, &y, &w, &h);

	vsl_width( vhandle, 1);
	vsl_color( vhandle, (nbcolor<16)?WHITE:bg);
	pxy[0]=x+w/2-1;
	pxy[1]=y+h/2-1;
	pxy[2]=Cos( 2.*(float)w/5.-4, (float)(heure.ti_sec-2)*6.28/60.);
	pxy[3]=Sin( 2.*(float)h/5.-4, (float)(heure.ti_sec-2)*6.28/60.);
	v_pline( vhandle, 2, pxy);

	set_color( scolor);
	pxy[0]=x+w/2-1;
	pxy[1]=y+h/2-1;
	pxy[2]=Cos( 2.*(float)w/5.-4, (float)heure.ti_sec*6.28/60.);
	pxy[3]=Sin( 2.*(float)h/5.-4, (float)heure.ti_sec*6.28/60.);
	v_pline( vhandle, 2, pxy);
}


void draw_heure( int wh)
{
	int x, y, w, h; 
	int pxy[4];
	
	wind_get( wh, WF_WORKXYWH, &x, &y, &w, &h);

	vsl_width( vhandle, 3);
	
	vsl_color( vhandle, (nbcolor<16)?WHITE:bg);

	pxy[0]=x+w/2-1;
	pxy[1]=y+h/2-1;
	pxy[2]=Cos( 2.*(float)w/5-4, (float)(heure.ti_min-1)*6.28/60.);
	pxy[3]=Sin( 2.*(float)h/5-4, (float)(heure.ti_min-1)*6.28/60.);
	v_pline( vhandle, 2, pxy);
	
	set_color( mcolor);

	pxy[0]=x+w/2-1;
	pxy[1]=y+h/2-1;
	pxy[2]=Cos( 2.*(float)w/5-4, (float)(heure.ti_min)*6.28/60.);
	pxy[3]=Sin( 2.*(float)h/5-4, (float)(heure.ti_min)*6.28/60.);
	v_pline( vhandle, 2, pxy);

	vsl_width( vhandle, 3);
	set_color( hcolor);
	pxy[0]=x+w/2-1;
	pxy[1]=y+h/2-1;
	pxy[2]=Cos( 1.8*(float)w/8, (float)heure.ti_hour*6.28/12.);
	pxy[3]=Sin( 1.8*(float)h/8, (float)heure.ti_hour*6.28/12.);
	v_pline( vhandle, 2, pxy);
}

/*
 *	Dessiner la montre
 */

void redraw( int wh)
{
	int x, y, w, h;
	int pxy[4], i;
	
	wind_get( wh, WF_WORKXYWH, &x, &y, &w, &h);

	if( update)
	{
		vswr_mode( vhandle, MD_REPLACE);
		vsf_color( vhandle, (nbcolor<16)?WHITE:bg);
		pxy[0] = x; pxy[1] = y;
		pxy[2] = x+w-1; pxy[3] = y+h-1;
		v_bar( vhandle, pxy);
	
			/* Les points */


		for( i=0; i<12; i++)
		{
			if( i % 3)
				set_color( p2color);
			else
				set_color( p1color);
			pxy[0] = Cos( 2.*(float)w/5., (float)i*6.28/12.);
			pxy[1] = Sin( 2.*(float)h/5., (float)i*6.28/12.);
			v_circle( vhandle, pxy[0], pxy[1], (i%3)?1:2);
		}
		vswr_mode( vhandle, MD_TRANS);
		if( !icon){
			set_color( tcolor);
			v_gtext( vhandle, x+w-10, y+h-2, sizer);
		}
	}
	vswr_mode( vhandle, MD_REPLACE);
	draw_sec( wh);
	draw_heure( wh);
	
	vsf_color( vhandle, BLACK);
	v_circle( vhandle, x+w/2-1, y+h/2-1, 1);

}

void do_update( int);

void timer( int wh)
{
	gettime( &heure);
	
	if( p_heure.ti_sec != heure.ti_sec ||
		p_heure.ti_min != heure.ti_min ||
		p_heure.ti_hour != heure.ti_hour )
	{
		evnt.ev_mmgpbuf[0] = WM_REDRAW;
		evnt.ev_mmgpbuf[1] = ap_id;
		evnt.ev_mmgpbuf[3] = wh;
		wind_get( wh, WF_WORKXYWH, &evnt.ev_mmgpbuf[4], 
								   &evnt.ev_mmgpbuf[5], 
								   &evnt.ev_mmgpbuf[6], 
								   &evnt.ev_mmgpbuf[7]);
		if( abs(p_heure.ti_sec-heure.ti_sec)>2 &&
			abs(p_heure.ti_sec-heure.ti_sec)<29)
			update = 1;
		else
			update = 0;
		do_update( wh);
	}
	p_heure = heure;
}


	/* Calcule l'intersection de 2 rectangles */
	/* Retourne 1 si intersection non vide 0 sinon */
	/* r2 contient l'intersection */
	
int rc_intersect ( GRECT *r1, GRECT *r2)
{
int tx, ty, tw, th;

  tw = min(r2->g_x + r2->g_w, r1->g_x + r1->g_w);
  th = min(r2->g_y + r2->g_h, r1->g_y + r1->g_h);
  tx = max(r2->g_x, r1->g_x);
  ty = max(r2->g_y, r1->g_y);
  r2->g_x = tx;
  r2->g_y = ty;
  r2->g_w = tw - tx;
  r2->g_h = th - ty;
  return ((tw > tx) && (th > ty));
}


void do_update( int wh)
{
	GRECT r1, r2;
	int pxy[4];
	int mx,my,md;
	
	r2.g_x = evnt.ev_mmgpbuf[4];
	r2.g_y = evnt.ev_mmgpbuf[5];
	r2.g_w = evnt.ev_mmgpbuf[6];
	r2.g_h = evnt.ev_mmgpbuf[7];
	graf_mkstate(&mx,&my,&md,&md);
	md = (in(mx,r2.g_x,r2.g_w) && in(my,r2.g_y,r2.g_h));
	wind_update(BEG_UPDATE);
	if( md)
		graf_mouse( M_OFF, 0L);
	
	wind_get( wh, WF_FIRSTXYWH, &r1.g_x, &r1.g_y, &r1.g_w, &r1.g_h);
	
	while (r1.g_w && r1.g_h) 
	{
		if ( rc_intersect( &r2, &r1))
		{
			pxy[0]=r1.g_x; pxy[1]=r1.g_y;
			pxy[2]=r1.g_x+r1.g_w-1; pxy[3]=r1.g_y+r1.g_h-1;
			vs_clip( vhandle, 1, pxy);
			redraw( wh);
		}
		wind_get( wh, WF_NEXTXYWH, &r1.g_x, &r1.g_y, &r1.g_w, &r1.g_h);
	}
	vs_clip( vhandle, 0, pxy);
	if( md)
		graf_mouse( M_ON, 0L);
	wind_update(END_UPDATE);
}

int gem_attrib( int attr)
{
	int res=0;
	
	if( attr&0x1) res |= NAME;
	if( attr&0x2) res |= CLOSER;
	if( attr&0x4) res |= FULLER;
	if( attr&0x8) res |= MOVER;
	if( attr&0x10) res |= SIZER;
	if( attr&0x20) res |= SMALLER;
	return res;
}

void ReadConf( void)
{
	FILE *fp = fopen("xclock.inf","r");
	char line[80];
	
	if( fp == NULL) return;
	while( !feof(fp))
	{
		fgets( line, 80, fp);
		if( *line == '#')
			continue;
		if( strstr( line, "bgcolor"))
			bg=atoi(strchr( line, '=') + 1);
		if( strstr( line, "hcolor"))
			hcolor=atoi(strchr( line, '=') + 1);
		if( strstr( line, "mcolor"))
			mcolor=atoi(strchr( line, '=') + 1);
		if( strstr( line, "scolor"))
			scolor=atoi(strchr( line, '=') + 1);
		if( strstr( line, "hcolor"))
			hcolor=atoi(strchr( line, '=') + 1);
		if( strstr( line, "p1color"))
			p1color=atoi(strchr( line, '=') + 1);
		if( strstr( line, "p2color"))
			hcolor=atoi(strchr( line, '=') + 1);
		if( strstr( line, "tcolor"))
			tcolor=atoi(strchr( line, '=') + 1);
		if( strstr( line, "winx"))
			xw=atoi(strchr( line, '=') + 1);
		if( strstr( line, "winy"))
			yw=atoi(strchr( line, '=') + 1);
		if( strstr( line, "winw"))
			ww=atoi(strchr( line, '=') + 1);
		if( strstr( line, "winh"))
			hw=atoi(strchr( line, '=') + 1);
		if( strstr( line, "wattrib"))
			wattrib=atoi(strchr( line, '=') + 1);
		if( strstr( line, "openifacc"))
			open_if_acc=atoi(strchr( line, '=') + 1);
		if( strstr( line, "timer"))
			evnt.ev_mtlocount=atoi(strchr( line, '=') + 1);
		if( strstr( line, "sizer"))
			*sizer= *(strchr( line, '=') + 1);
	}
	fclose( fp);
}

void SaveConf( void)
{
	FILE *fp = fopen("xclock.inf","w");
	
	fprintf(fp,"# Xclock by D.Brziat\n# configuration\n");
	fprintf(fp,"bgcolor=%d\n",bg);
	fprintf(fp,"hcolor=%d\n",hcolor);
	fprintf(fp,"mcolor=%d\n",mcolor);
	fprintf(fp,"scolor=%d\n",scolor);
	fprintf(fp,"tcolor=%d\n",tcolor);
	fprintf(fp,"p1color=%d\n",p1color);
	fprintf(fp,"P2color=%d\n",p2color);
	fprintf(fp,"winx=%d\n",xw);
	fprintf(fp,"winy=%d\n",yw);
	fprintf(fp,"winw=%d\n",ww);
	fprintf(fp,"winh=%d\n",hw);
	fprintf(fp,"wattrib=%d\n",wattrib);
	fprintf(fp,"openifacc=%d\n",open_if_acc);
	fprintf(fp,"timer=%d\n",evnt.ev_mtlocount);
	fprintf(fp,"sizer=%c\n",*sizer);
	fclose(fp);
}


int main(void)
{
	int exit = 0, res, whandle;
	int x, y, w, h;
	int work_in[10], work_out[57];
	
	ap_id = appl_init();
	graf_mouse( ARROW, 0L);

	if( _AESnumapps == -1 || _app == 0)
		menu_register( ap_id, "  Xclock");

	work_in[0] = Getrez() + 2;
	for( res = 1; res < 10; work_in[ res ++] = 1);
	work_in[10] = 2;
	v_opnvwk( work_in, &vhandle, work_out);
	nbcolor = work_out[ 13];
	vsf_interior( vhandle, FIS_SOLID);
	wind_get( 0, WF_WORKXYWH, &xd, &yd, &wd, &hd);
	xw=xd;
	yw=yd;
	
	ReadConf();
	
	whandle = wind_create( gem_attrib(wattrib), xd, yd, wd, hd);
	if( _app || open_if_acc)
		wind_open( whandle, min(max(xw,xd),xd+wd-ww), 
							min(max(yw,yd),yd+hd-hw),
							min(ww,wd), min(hw,hd));
	else
		wclose = 3;	/* fenetre jamais ouverte */

	wind_set( whandle, WF_NAME, "Xclock",0,0); 
	wind_set( whandle, WF_BEVENT, 0x0001,0,0,0);
	gettime( &heure);
	p_heure = heure;
	while( !exit)
	{
		res = EvntMulti( &evnt);
		if( res & MU_MESAG)
		{
			switch( evnt.ev_mmgpbuf[0]){
			case AC_OPEN:
				if( wclose == 3)
				{
					x=xw;
					y=yw;
					w=ww;
					h=hw;
				}
				else	
					wind_get( whandle, WF_PREVXYWH, &x, &y, &w, &h);
				wind_open( whandle, x, y, w, h);
				wclose = 0;
				break;
			case AC_CLOSE:
				wclose = 1;
				wind_close( whandle);
				break;
			case WM_REDRAW:
				update = 1;
				do_update( whandle);
				break;
			case WM_CLOSED:
			case AP_TERM:
				exit = 1;
				break;
			case WM_MOVED:
			case WM_SIZED:
				wind_set( whandle, WF_CURRXYWH, evnt.ev_mmgpbuf[4],
										   evnt.ev_mmgpbuf[5],
									   	   evnt.ev_mmgpbuf[6],
									   	   evnt.ev_mmgpbuf[7]);
				if( evnt.ev_mmgpbuf[0] == WM_SIZED)
				{
					update = 1;
					do_update( whandle);
				}	
				break;
			case WM_FULLED:
				wind_set( whandle, WF_CURRXYWH, xd,yd,wd,hd);
				break;
			case WM_TOPPED:
				wind_set( whandle, WF_TOP, evnt.ev_mmgpbuf[3],0,0,0);
				break;
			case WM_ICONIFY:
			case WM_ALLICONIFY:
				icon = 1;
				wind_set( whandle, WF_ICONIFY, evnt.ev_mmgpbuf[4],
										  evnt.ev_mmgpbuf[5],
									   	  evnt.ev_mmgpbuf[6],
									   	  evnt.ev_mmgpbuf[7]);
				break;
			case WM_UNICONIFY:
				icon = 0;
				wind_set( whandle, WF_UNICONIFY, evnt.ev_mmgpbuf[4],
										    evnt.ev_mmgpbuf[5],
									   	    evnt.ev_mmgpbuf[6],
									   	    evnt.ev_mmgpbuf[7]);
				break;
			}
		}
		if( res & MU_BUTTON && !icon)
		{		
			if( wind_find(  evnt.ev_mmox, evnt.ev_mmoy) == whandle)
			{
				int nw, nh;
				
				wind_get( whandle, WF_WORKXYWH, &x, &y, &w, &h);
				if( in( evnt.ev_mmox, x+w-13, 13) &&
					in( evnt.ev_mmoy, y+h-13, 13))
				{
					wind_get( whandle, WF_CURRXYWH, &x, &y, &w, &h);
					graf_mouse(POINT_HAND,0L);
					graf_rubberbox( x, y, 50, 50, &nw, &nh);
					graf_mouse(ARROW,0L);
					wind_set( whandle, WF_CURRXYWH, x, y, nw, nh);
					evnt.ev_mmgpbuf[0] = WM_REDRAW;
					evnt.ev_mmgpbuf[4] = x;
					evnt.ev_mmgpbuf[5] = y;
					evnt.ev_mmgpbuf[6] = nw;
					evnt.ev_mmgpbuf[7] = nh;
				}
				else
				{
					wind_get( whandle, WF_CURRXYWH, &x, &y, &w, &h);
					graf_mkstate(&nw,&nw,&nh,&nw);
					if( nh)
					{
						graf_mouse(FLAT_HAND,0L);
						graf_dragbox(w,h,x,y,
									 xd,yd,wd,hd,
									 &nw,&nh);
						graf_mouse(ARROW,0L);
						evnt.ev_mmgpbuf[0] = WM_MOVED;
						evnt.ev_mmgpbuf[4] = nw;
						evnt.ev_mmgpbuf[5] = nh;
						evnt.ev_mmgpbuf[6] = w;
						evnt.ev_mmgpbuf[7] = h;
					}
					else
					{
						do{
							graf_mkstate(&x,&x,&y,&x);
						}while(y);
						evnt.ev_mmgpbuf[0] = WM_TOPPED;
					}
				}
				evnt.ev_mmgpbuf[1] = ap_id;
				evnt.ev_mmgpbuf[2] = 0;
				evnt.ev_mmgpbuf[3] = whandle;
				appl_write( ap_id, 16, evnt.ev_mmgpbuf);
			}
		}
		if( res & MU_KEYBD ) {
			switch( (char)evnt.ev_mkreturn) {
			case CONTROL_U:
			case CONTROL_Q:
				if( _app) exit = 1;
				break;
			case CONTROL_R:
				wind_get( whandle, WF_CURRXYWH, &evnt.ev_mmgpbuf[4],
										        &evnt.ev_mmgpbuf[5],
									   	        &evnt.ev_mmgpbuf[6],
									   	        &evnt.ev_mmgpbuf[7]);
				evnt.ev_mmgpbuf[0] = WM_REDRAW;
				evnt.ev_mmgpbuf[1] = ap_id;
				evnt.ev_mmgpbuf[2] = 0;
				evnt.ev_mmgpbuf[3] = whandle;
				appl_write( ap_id, 16, evnt.ev_mmgpbuf);
				break;
			}
		}
		if( res & MU_TIMER && wclose == 0)
			timer( whandle);
	}
	if( wclose != 3)
		wind_get( whandle, wclose?WF_PREVXYWH:WF_CURRXYWH, &xw, &yw, &ww, &hw);

	SaveConf();
	wind_close( whandle);
	wind_delete( whandle);
	appl_exit();
	return 0;
}