/*
 *		Dominique Brziat - projet  WinDom 
 *
 *	Librairie: WinEdit
 *	Modules:   winedit.h
 *	Description:	Gestion des textes en mmoire.
 *					Tout accs aux structures de texte doit
 *					se faire par l'intermdaire de ces fontions.
 *	Dernire modif: septembre 97
 *
 */

#ifndef __EDITOR
#define __EDITOR

#include <windom.h>

/* ======== A modifier avant compilation ========== */
/*     il faut recompiler editor.c avec ces valeurs */
#ifndef MAX_CAR
#define MAX_CAR		255		/* Largeur maximale d'une ligne */
#endif
#ifndef MAX_ALLOC
#define MAX_ALLOC	100L	/* Nbre de reallocation mmoire */
#endif
/* ================================================ */

	/*  Quelques code ascii  */
	
#define BACKSPACE    8
#define TAB          9
#define RETURN       13
#define ESC          27
#define ESPACE       32
#define CAR_POINT    46
#define P_INTERRO    63
#define ANTI_SLASH   92
#define SOULIGNE     95
#define INSERT       126
#define DELETE       127

	/*  Quelques scancode	*/

#define HAUT	72
#define BAS		80
#define DROITE	77
#define GAUCHE	75
#define HELP	0x62

	/* Code d'erreur */

#define ERR_MEM		-1		/* Pas assez de mmoire */
#define ERR_FIC		 0	 	/* Erreur fichier */
#define NO_ERR		 1 		/* Pas d'erreur */

typedef  char STRING[MAX_CAR];
typedef  char FONTNAME[50];

typedef struct _EDIT
		{
			STRING *addr;   /* pointe sur le texte */
			size_t line;		/* ligne courante */
			size_t colum;		/* colonne courante */
			size_t maxline;	/* Nombre total de lignes */
			/* Taille Vdi des caractres et cellules */
			int wcar, hcar;
			int wcell, hcell;
			/* Curseur allum ou teint */
			int cursor;
			/* Longueur de la tabulation */
			int tab;
			/* Gestion de bloc */
			size_t l1, c1, l2, c2;
			int bloc;
			/* Couleur et style */
				/* du fond */
			int fcolor;
			int fstyle;
			int finterior;
				/* du curseur */
			int ccolor;
			/* Gestion des fontes  */
			int flagfont;           /* Nombre de fonte charges, zero sinon */
			int IdFont;				/* Fonte par dfaut */
			int size;				/* corp de fonte 0 = val par dfaut */
			int tcolor;				/* couleur du texte */
			FONTNAME *TableFont;	/* Table d'index des fontes */
			/* Divers */
			int flags;				/* flags divers */
		} EDIT;


#define DISPLAYESCAPECODE	0X0001

/**********************************************/
/* Code Escape 	ESC + caractere [+ paramtre] */
/**********************************************/


#define TE_NORMAL   	0x00	/* '@' 01000000 */
#define TE_GRAS			0x01	/* 'A' 01000001 */
#define TE_LEGER		0x02	/* 'B' 01000010 */
#define TE_ITALIQUE		0x04	/* 'D' 01000100 */
#define TE_SOULIGNE		0x08	/* 'H' 01001000 */
#define TE_EXPOSANT 	0x10	/* 'P' 01010000 */
#define TE_INDICE		0x20	/* '`' 01100000 */

#define WE_NORMAL		'@'
#define WE_ESCAPE		''
#define WE_COLOR		'#'
#define WE_FONT			'%'
#define WE_SIZE			'('
#define WE_SETNAMEFONT	'&'
#define WE_ENDOFSTRING  '.'
#define WE_BGCOLOR		'$'
#define WE_TABSIZE		'!'

#define Bold			"A"
#define Underlined		"H"
#define Italic			"D"
#define Normal			"@"
#define Escape			""
#define Color(c)		"#",c+'0'
#define FontName(i,p)	"&",i+'0',p,"."		/* %s%c%s%s */
#define Font(f)			"%",f+'0'
#define	Size(s)			"(",s+'0'
#define BgColor(c)		"$",c+'0'

/* -- Variables "systmes" a ne pas modifier! -- */

extern int __max_car;
extern long __max_alloc;

/* -- Prototypage -----*/
	/* Les fonctions doivent permettre de rendre transparent 
		le type de structure de donnees (pour amlioration
		ultrieure). */

/* fonctions diteur */

int put_char( char, EDIT *);
void del_char( EDIT *);
void put_string( char *, EDIT *);
char *get_line( EDIT *, size_t);
char get_char( EDIT *);
int save_text(EDIT *, char *);
int load_text(EDIT *, char *);
void cnv_spc( int, char *, char *);
EDIT *init_text( void);
void reinit_text( EDIT *);
void del_text( EDIT *);

/* fonctions pour windom */

WINDOW *WindText( int flag, EDIT *ptext);
WINDOW *WindEdit( int flag, EDIT *ptext);

WINDOW *wprintf_init( int watt, char *title);
void wprintf_exit( WINDOW *win);
void wprintf( WINDOW *win, const char *format, ...);
#endif