/*
 *		Dominique Brziat - projet  WinDom 
 *
 *	Librairie: WinEdit
 *	Modules:   edit.c
 *	Description:	Gestion des textes en mmoire.
 *					Tout accs aux structures de texte doit
 *					se faire par l'intermdaire de ces fontions.
 *	Dernire modif: aout 96
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windom.h>
#include "winedit.h"

int __max_car=MAX_CAR;
long __max_alloc=MAX_ALLOC;

/************************************************************************/

int put_char(c,ptext)
register char c;
register EDIT *ptext;
{
register size_t i;
register char d;
unsigned long taille;

	if( c == '\n') /* nouvelle ligne  et descendre la ligne */
	{
		if(++ptext->maxline % __max_alloc == 0)
		{
			taille = (ptext->maxline/__max_alloc + 1) * __max_alloc;
			realloc( ptext->addr, taille*sizeof(STRING));
			if ( ptext->addr == NULL)
			{
				--ptext->maxline;
				return( ERR_MEM);
			}
		}
		for( i=ptext->maxline-1; i>ptext->line+1; i--)
			strcpy( ptext->addr[i], ptext->addr[i-1]);

		strcpy( ptext->addr[ptext->line+1], 
							ptext->addr[ptext->line]+ptext->colum);
		ptext->addr[ptext->line++][ptext->colum] = '\0';
		ptext->colum = 0;
		return(1);
	}
	else
	{
		for( i=ptext->colum; i<__max_car; i++)
		{
			d = ptext->addr[ptext->line][i];
			ptext->addr[ptext->line][i] = c;
			c = d;
			if (d == '\0')
			{
				ptext->addr[ptext->line][i+1]='\0';
				break;
			}
		}
		ptext->colum++;
		return(1);
	}
}

void del_char(ptext)
register EDIT *ptext;
{
register size_t i;

	if(ptext->colum==0) /* remonter la ligne */
	{
		if(ptext->line==0)
			return;
		ptext->colum = strlen(ptext->addr[ptext->line-1]);
		strcpy( ptext->addr[ptext->line-1]+ptext->colum, ptext->addr[ptext->line]);
		for( i=ptext->line; i<ptext->maxline-1; i++)
			strcpy( ptext->addr[i], ptext->addr[i+1]);
		realloc( ptext->addr, --ptext->maxline*sizeof(STRING));
		ptext->line--;
	}
	else
	{
		for(i=ptext->colum-1;ptext->addr[ptext->line][i]!='\0';i++)
			ptext->addr[ptext->line][i] = ptext->addr[ptext->line][i+1];
		ptext->addr[ptext->line][i] = '\0';
		ptext->colum--;
	}	
}	

void put_string( char *string, EDIT *ptext)
{
int put_char( char, EDIT *);

	while( *string != '\0')
		put_char( *string++, ptext);
}

char *get_line( EDIT *ptext, size_t line)
{
	if ( line < ptext->maxline )
		return( ptext->addr[ line ]);
	else
		return( NULL);
}

char get_char( ptext)
EDIT *ptext;
{
	return( ptext -> addr[ ptext -> line][ ptext -> colum]);
}

void del_line( EDIT *ptext, size_t line)
{
	char get_char( EDIT *);
	void del_char( EDIT *);
	char *get_line( EDIT *, size_t);
	size_t co;
	
	ptext -> line = line+1;
	co = strlen( get_line( ptext, line));
	ptext -> colum = 0;
	while( co--)
		del_char( ptext);
	del_char( ptext);
}


int save_text(ptext,nom)		/* Sauve max lignes dans un fichier */
EDIT *ptext;
char *nom;
{
FILE *fp;
int i;

	if((fp = fopen(nom,"w")) == NULL)
		return( ERR_FIC);
	for( i=0; i<ptext->maxline; i++)
		fprintf( fp, "%s\n", ptext->addr[i]); /* controler les erreurs */
	fclose( fp);
	return(1);		/* Pas d'erreur */
}

int load_text( ptext, nom)
EDIT *ptext;
char *nom;
{
FILE *fp;
STRING buff;
unsigned long taille=__max_alloc;
	
	if((fp = fopen(nom,"r")) == NULL)
		return( ERR_FIC);
	ptext->maxline = 0L;
	while( fgets( buff, __max_car, fp) != NULL)
	{
		if(buff[strlen(buff)-1] == '\n')
			buff[strlen(buff)-1] = '\0';
		if( ++ptext->maxline % __max_alloc == 0)
		{
			taille += __max_alloc;
			ptext->addr = realloc( ptext->addr, taille*sizeof(STRING));
			if(ptext->addr == NULL)
			{
				fclose(fp);
				--ptext->maxline;
				return( ERR_MEM);
			}
		}
		strcpy(ptext->addr[ptext->maxline-1],buff);
	}
	fclose(fp);
	ptext->line = ptext->colum = 0;
	if( !ptext -> maxline)
		ptext -> maxline = 1L;
	return(1);
}

void cnv_spc(tab, dest, src)
int tab;
char *dest, *src;
{
register int i;

	i=0;
	while( *src != '\0')
	{
		if( *src == '\t')
		{
			while( ++ i % tab != 0)
				*dest++ = ' ';
			*dest++ = ' ';
		}
		else
		{
			*dest++ = *src;
			i++;
		}
		src ++;
	}
	*dest = '\0';
}

EDIT *init_text( void)
{
EDIT *ptext;

	ptext = (EDIT *)malloc(sizeof(EDIT));
	if( ptext == NULL)
		return( ptext);
	ptext -> addr = (STRING *) malloc( __max_alloc*sizeof(STRING));
	if ( ptext->addr == NULL)
	{
		free( ptext);
		return( NULL);
	}
	ptext -> line = ptext -> colum = 0L;
	ptext -> maxline = 1L;
	ptext -> addr[ 0][ 0] = '\0';
	return( ptext);
}

void reinit_text( EDIT *ptext)
{
	ptext -> addr = (STRING *)realloc( ptext -> addr, 
									   __max_alloc*sizeof(STRING));
	ptext -> line = ptext -> colum = 0L;
	ptext -> maxline = 1L;
	ptext -> addr[ 0][ 0] = '\0';
}

void del_text( ptext)
EDIT *ptext;
{
	free( ptext->addr);
	free( ptext);
}

EDIT *dup_text( EDIT *ptext) {
	EDIT *new;
	size_t dum;
	
	new = init_text();
	if( new == NULL) return NULL;
	for( dum=0; dum<ptext->maxline; dum++, ptext->maxline)
		put_string( get_line(ptext,dum), new);
	return new;
}

/*
 *	Skip escape code
 */

size_t skip_esc( char *p)
{
	size_t pos = 1;
	
	p++;
	switch( *p){
	case WE_ESCAPE:
		break;
	case WE_NORMAL:
		pos ++;
		break;
	case WE_COLOR:
	case WE_BGCOLOR:
	case WE_FONT:
	case WE_SIZE:
	case WE_TABSIZE:
		pos +=2;
		break;
	case WE_SETNAMEFONT:
		while (*p++ != WE_ESCAPE)
			pos ++;
		pos++;
		break;
	default:
		if( *p & WE_NORMAL)	/* standart attribut */
			pos ++;
	}
	return pos;
}
