/*
	Dominique Brziat, 1994-1997.
	Routines d'dition de texte en fentre.
	Librairie cliente de WinDom
*/

#include <stdio.h>
#include <string.h>
#include <windom.h>
#include "winedit.h"

WINDOW *WindText( int flag, EDIT *ptext);
void set_clip( int, GRECT *);
void clip_off( int);


/* La fonction de dessin pour texte ditable
   -> pas de sequence escape
*/

void std_edit_drw( WINDOW *win)
{
	int x, y, w, h;
	int xy[4];
	register size_t i;
	char buff[256];
	EDIT *ptext;
	
	WindGet( win, WF_WORKXYWH, &x, &y, &w, &h);
	ptext = (EDIT *)win->data;
	vswr_mode( win -> graf . handle, MD_REPLACE);
	vsf_interior( win -> graf . handle, ptext -> finterior);
	vsf_color( win -> graf . handle, ptext -> fcolor);
	vsf_style( win -> graf . handle, ptext -> fstyle);
	vst_color( win -> graf . handle, ptext -> tcolor);
	xy[0]=x;xy[1]=y;xy[2]=x+w-1;xy[3]=y+h-1;
	v_bar( win->graf.handle, xy);
	vswr_mode( win -> graf . handle, MD_TRANS);
	w = ptext -> hcell - ptext -> hcar;

	for( i=win->ypos; i<ptext->maxline ; i++)
	{
		y += ptext->hcell;
		if( y < clip.g_y)
			continue;
		cnv_spc( ptext -> tab, buff, get_line( ptext, i));
		if( strlen( buff) > win->xpos)
			v_gtext(win->graf.handle, x, y - w, buff + win->xpos);
		if (y > min(xy[3], clip.g_y + clip.g_h-1))
			break;
	}
}

/* Le curseur */

void std_txt_timed( WINDOW *win)
{
	int xy[4];
	int x,y,w,h;
	EDIT *ptext;

	ptext = (EDIT *)win->data;
	if( ptext -> bloc)
		return;   /* Pas de curseur en mode bloc */

	WindGet( win, WF_WORKXYWH, &x, &y, &w, &h);

/*	x += ptext -> xPosText;
	w -= ptext -> xPosText; */
	
	if(ptext->colum < win->xpos || ptext->line < win->ypos ||
			ptext->colum - win->xpos > w/ ptext -> wcell || 
			ptext->line - win->ypos > h/ ptext -> hcell)
		return;

/*	vswr_mode( win -> graf . handle, MD_REPLACE);	
	vsf_interior( win -> graf . handle, 1);
	
	if( ptext->cursor)
		vsf_color( win -> graf . handle, ptext -> fcolor);
	else
		vsf_color( win -> graf . handle, ptext -> ccolor); */
	
	vsf_color( win -> graf . handle, ptext -> ccolor);
	vsf_interior( win -> graf . handle, 1);
	vswr_mode( win -> graf . handle, MD_XOR);
	
	xy[0] = x + ptext -> wcell * (int)( ptext -> colum - win -> xpos);
	xy[1] = y + ptext -> hcell * (int)( ptext -> line - win -> ypos);
	xy[2] = xy[0]+1;
	xy[3] = xy[1] + ptext -> hcell - 1;
	
	rect_set( &clip, x, y, w, h);
	set_clip( win -> graf . handle, &clip);

	graf_mkstate( &x, &y, &w, &h);
	if( is_in( x, y, xy[0]-20, xy[1]-20, 40, 40))
		graf_mouse( M_OFF, 0L);
	vr_recfl( win -> graf . handle, xy);
	clip_off( win -> graf . handle);
	if( is_in( x, y, xy[0]-20, xy[1]-20, 40, 40))
		graf_mouse( M_ON, 0L);
	
	ptext -> cursor = 1 - ptext -> cursor;
}

/* La gestion du clavier */

/* caratre spciaux */

char alw_cmd_asci[] = {27, BACKSPACE,TAB,RETURN,DELETE};
char alw_cmd_scan[] = {HAUT,BAS,DROITE,GAUCHE};

/*
int allwd_car( char, char *);

int allwd_car( car, allowed)
char car;
register char *allowed;
{
	while( *allowed ++ != '\0')
		if( *allowed == car)
			return 1;
	return 0;
}
*/

int test_car( car) /* Caractres autoris */
char car;
{
	if ( car >= 32 && car <= 126)
		return 1;
	if ( car == '' || car == '' || car == '' || car == '' || car == '')
		return 1;
	return 0;
}

void draw_char( WINDOW *win, char c, int x, int y)
{
	EDIT *ptext = win->data;
	int xy[4];
	char txt[2];
	
	vswr_mode( win->graf.handle, 1);
	xy[0]=x;xy[1]=y;
	xy[2]=x+ptext->wcell-1;
	xy[3]=y+ptext->hcell-1;
	vsf_interior( win->graf.handle, 1);
	vsf_color( win->graf.handle, ptext->fcolor);
	v_bar( win->graf.handle, xy);
	
	if( c != 0)
	{
		txt[0]=c;
		txt[1]='\0';
		vswr_mode( win->graf.handle, 2);
		v_gtext( win->graf.handle, xy[ 0], xy[ 1] + ptext->hcar, txt);
	}
}

void std_txt_rwkey( WINDOW *win)
{
	int test_car( char);
	char win_car;
	EDIT *ptext;
	int x, y, w, h;
	static size_t maxcol = 0L;	/* Position 'locale' maximale du curseur */
	int xy[8];
	long screen = 0L;

	win_car = evnt.keybd;
	ptext = (EDIT *) win -> data;
	WindGet( win, WF_WORKXYWH, &x, &y , &w, &h);
/*	x += ptext -> xPosText;
	w -= ptext -> xPosText; */

	if( ptext -> cursor)
		( * win -> timed)( win);

	if( ptext -> line < win -> ypos || ptext -> line > win -> ypos + h/ptext -> hcell)
	{
		if( test_car( win_car) || strchr( alw_cmd_scan, evnt.keybd>>8)
			|| strchr( alw_cmd_asci, win_car))
		{
			evnt.buff[ 0] = WM_VSLID;
			evnt.buff[ 1] = app.id;
			evnt.buff[ 2] = 0;
			evnt.buff[ 3] = win -> handle;
			evnt.buff[ 4] = (int)((1000L*ptext->line)/ptext->maxline);
			appl_write( app.id, 16, evnt.buff);
		}
	}
	graf_mkstate( &xy[0], &xy[0], &xy[0], &xy[1]);

	switch( evnt.keybd >> 8){
	case HAUT:
		if( xy[1] & (K_LSHIFT | K_RSHIFT))
		{
			ptext -> line = (size_t) max( 0L, (long)(ptext -> line - h/ptext->hcell));
			snd_arrw( win, WA_UPPAGE);
		}
		else if( ptext -> line)
		{
		size_t len;
			ptext -> line --;
			len = strlen( get_line( ptext, ptext -> line));
			ptext -> colum = min( maxcol, len);
 			if( ptext -> line  < win -> ypos )
 				snd_arrw( win, WA_UPLINE);
			else if( !ptext->cursor)
				( *win -> timed)( win);
		}
		break;
	case BAS:
		if( xy[1] & (K_LSHIFT | K_RSHIFT))
		{
			ptext -> line = min( ptext -> maxline - 1, ptext -> line + h/ptext->hcell);
			snd_arrw( win, WA_DNPAGE);
		}
		else if( ptext -> line < ptext -> maxline - 1)
		{
			size_t len;
		
			ptext -> line ++;
			len = strlen( get_line( ptext, ptext -> line));
			ptext -> colum = min( maxcol, len);
			if ( ptext -> line - win -> ypos > h / win -> h_u - 1)
				snd_arrw( win, WA_DNLINE);
			else if( !ptext->cursor)
				( *win -> timed)( win);
		}
		break;
	case DROITE:
		if( get_char( ptext) != '\0')
			ptext -> colum ++;
		else if( ptext -> line < ptext -> maxline - 1)
		{
			ptext -> colum = maxcol = 0;
			ptext -> line ++;
			if( ptext -> line - win -> ypos > h / win -> h_u - 1)
			{
				snd_arrw( win, WA_DNLINE); 
				break;
			}
		}
		maxcol = ptext -> colum;
		if( !ptext->cursor)
			( *win -> timed)( win);
		break;
	case GAUCHE:
		if( ptext -> colum)
			ptext -> colum --;
		else if( ptext -> line)
		{
			ptext -> colum = maxcol = strlen( get_line( ptext, --ptext -> line));
			if( ptext -> line  < win -> ypos )
			{
				snd_arrw( win, WA_UPLINE);
				break;
			}
		}
		maxcol = ptext -> colum;
		if( !ptext->cursor)
			( *win -> timed)( win);
		break;
	default:
		switch( win_car){
		case RETURN:
			put_char( '\n', ptext);
			win -> xpos = 0; /* voir cas de la tabulation */
			win -> ypos_max = (int) ptext -> maxline;
			if ( ptext -> line - win -> ypos > h / win -> h_u - 1)
				win -> ypos ++;
			WindSlider( win, VSLIDER);
			snd_rdw( win);
			maxcol = 0L;
			break;
		case DELETE:
			if( get_char( ptext) == '\0')
			{
				ptext->colum = 0;
				ptext->line ++;
				del_char( ptext);
				snd_rdw( win);
				break;
			}
			ptext -> colum ++;
		case BACKSPACE:
			if( win_car == BACKSPACE && !ptext -> colum)
			{
				del_char( ptext);
				snd_rdw( win);
				break;
			}
		    xy[ 0] = x + ptext -> wcell * (int)( ptext -> colum - win -> xpos);
			xy[ 1] = y + ptext -> hcell * (int)( ptext -> line - win -> ypos) ;
			xy[ 2] = x + w - 1;
			xy[ 3] = xy[ 1] + ptext -> hcell - 1;
			xy[ 4] = xy[ 0] - ptext -> wcell;
			xy[ 5] = xy[ 1];
			xy[ 6] = xy[ 2];
			xy[ 7] = xy[ 3];
			del_char( ptext);
			WindSlider( win, VSLIDER);
			rect_set( &clip, x, y, w, h);
			graf_mouse( M_OFF, 0L);
			set_clip( win -> graf . handle, &clip);
			vro_cpyfm( win -> handle, S_ONLY, xy, (MFDB*)&screen, (MFDB*)&screen);
			xy[ 0] = x + w - ptext -> wcell;
			vsf_color( win -> graf . handle, WHITE);
			vswr_mode( win -> graf . handle, MD_REPLACE);
			v_bar( win -> graf . handle, xy);
			clip_off( win -> graf . handle);
			graf_mouse( M_ON, 0L);
			break;
		case TAB: /* Doit passer dans le default */
			put_char( TAB, ptext);
			snd_rdw( win);
			break;
		default:
			if ( test_car( win_car))
			{
				char car[2];

				graf_mouse( M_OFF, 0L);
				rect_set( &clip, x, y, w, h);				
				set_clip( win -> graf . handle, &clip);
				
				xy[ 0] = x + ptext -> wcell * (int)( ptext -> colum - win -> xpos);
				xy[ 1] = y + ptext -> hcell * (int)( ptext -> line - win -> ypos);
				xy[ 2] = x + w - 1;
				xy[ 3] = xy[ 1] + ptext -> hcell - 1;
				xy[ 4] = xy[ 0] + ptext -> wcell;
				xy[ 5] = xy[ 1];
				xy[ 6] = xy[ 2];
				xy[ 7] = xy[ 3];
				vro_cpyfm( win -> graf . handle, S_ONLY, xy, (MFDB*)&screen, (MFDB*)&screen);

				draw_char( win, win_car, xy[ 0], xy[ 1]);
				
				clip_off( win->graf.handle);
				graf_mouse( M_ON, 0L);
								
				put_char( win_car, ptext);
				if( ptext -> colum - win -> xpos > w / ptext -> wcell - 1)
					snd_arrw( win, WA_RTPAGE);
				
/*				graf_mouse( M_OFF, 0L);
				xy[ 0] = x + ptext -> wcell * ( ( int) ptext -> colum - 1 - win -> xpos);
				xy[ 1] = y + ptext -> hcell * ( ( int) ptext -> line - win -> ypos);
				xy[ 2] = x + w - 1;
				xy[ 3] = xy[ 1] + ptext -> hcell - 1;
				xy[ 4] = xy[ 0] + ptext -> wcell;
				xy[ 5] = xy[ 1];
				xy[ 6] = xy[ 2];
				xy[ 7] = xy[ 3];
				rect_set( &clip, x, y, w, h);				
				set_clip( win -> graf . handle, &clip);
				vro_cpyfm( win -> graf . handle, S_ONLY, xy, (MFDB*)&screen, (MFDB*)&screen);
				car[ 0] = win_car;
				car[ 1] = '\0';
				vswr_mode( win -> graf . handle, MD_REPLACE);
				v_gtext( win -> graf . handle, xy[ 0], xy[ 1] + ptext -> hcar, car);
				clip_off( win -> graf . handle);
				graf_mouse( M_ON, 0L); */
			}
		}
	}
	maxcol = max( maxcol, ptext -> colum);
}


/* Gestion des bloc de texte:
	La fonction drw_slct_txt( WINDOWPTR,int,int,int,int);
	Elle (d)selectionne un bloc de texte dans une fenetre.
*/

void drw_slct_txt( WINDOWPTR, size_t, size_t, size_t, size_t);

void drw_slct_txt( WINDOW *win, size_t lfst, size_t cfst, 
								  size_t lend, size_t cend)
{
	int x, y, w, h;
	EDIT *ptext;
	int xy[ 4];
	size_t dum;

	dum = min( lfst, lend);
	lend = max( lfst, lend);
	lfst = dum;
	dum = min( cfst, cend);
	cend = max( cfst, cend);
	cfst = dum;
	
	WindGet( win, WF_WORKXYWH, &x, &y, &w, &h);
	ptext = (EDIT *)win -> data;

	xy[ 1] = y + (int)lfst * ptext -> hcell;
	xy[ 0] = x + (int)cfst * ptext -> wcell;
	xy[ 3] = y + (int)lend * ptext -> hcell - 1;
	xy[ 2] = x + (int)cend * ptext -> wcell - 1;
	
	vswr_mode( win -> graf . handle, MD_XOR);
	vsf_interior( win -> graf . handle, 1);
	vsf_color( win -> graf . handle, RED);	
	vr_recfl( win -> graf . handle, xy);
}


char debug[255];

void txt_clicked( WINDOW *win)
{
int x, y, w, h, dum;
EDIT *ptext;
size_t l3,c3;

	WindGet( win, WF_WORKXYWH, &x, &y, &w, &h);

	ptext = (EDIT *) win -> data;

	if( !ptext->bloc)
	{
		ptext->c1 = (evnt.mx - x) / ptext -> wcell + win -> xpos;
		ptext->l1 = ptext->l2 = (evnt.my - y) / ptext -> hcell + win -> ypos;
		if( ptext->l1 >= ptext->maxline)
			ptext -> l2 = ptext->l1 = ptext->maxline;
		ptext->c2 = ptext->c1 = min( ptext->c1, strlen( get_line( ptext, ptext->l1)));
	}

	do{
		graf_mkstate( &evnt.mx, &evnt.my, &evnt.mbut, &dum);
		c3 = (evnt.mx - x) / ptext -> wcell + win -> xpos;
		l3 = (evnt.my - y) / ptext -> hcell + win -> ypos;

		if( ptext->l2 != l3 || ptext->c2 != c3)
		{
			/* Eteindre le curseur */
			if( ptext -> cursor)
				( * win -> timed)( win);
			
			graf_mouse( M_OFF, 0L);
			drw_slct_txt( win, ptext -> l2, ptext -> c2, l3, c3);
			graf_mouse( M_ON, 0L);
			ptext -> c2 = c3;
			ptext -> l2 = l3;
			ptext -> bloc = 1;
			sprintf( debug, "%d,%d,%d,%d", ptext->l1, ptext->c1, l3, c3);
			wind_set( win->handle, WF_INFO, debug);
		}
		if( ptext->l1 == l3 && ptext->c1 == c3)
		{
			ptext->bloc = 0;
			/* il faut enlever le bloc */
		}
		
	} while( evnt.mbut);
	
	if( !ptext -> bloc && (ptext -> l1 < ptext -> maxline))
	{		
		ptext -> line = ptext -> l1;
		ptext -> colum = ptext -> c1;
	}
}

WINDOW *WindEdit( int flag, EDIT *ptext)
{
	WINDOW *win;

	win = WindText( flag, ptext);
	win -> redraw 	= std_edit_drw;
	win -> timed 	= std_txt_timed;
	win -> keyhited = std_txt_rwkey;
	win -> clicked 	= txt_clicked;
	return win;
}