/************************************************************/
/*   ROUTINES DE GESTION DE DONNEES POUR UN EDITEUR			*/
/*		Dominique Bereziat Corp. Decembre 1992	- 1994		*/
/*   Version 2: Ajonction de routine fenetre pour windows   */
/*      dernire modif : le 14.12.94						*/
/*      modif du 18/08/95: ajout de squences Escape        */
/*						   attribut texte + couleur texte   */
/*						   font GDOS/SPEEDO 			    */
/*						   taille du texte (qq pb)		    */
/*						   flag couleur et style du fond	*/
/*															*/
/*		modif du 10/10/97: rcriture de la routine de      */
/*						  dessin developp dans Viewer		*/
/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windom.h>
#include "winedit.h"


/* La fonction standart de destruction de fenetre */

void std_txt_kill( WINDOW *win)
{
void del_text( EDIT *);

	if( ((EDIT *)win->data)-> flagfont)
		vst_unload_fonts( win -> graf.handle, 0);
	if( ((EDIT *)win->data)-> TableFont)
		free( ((EDIT *)win->data)-> TableFont);
	del_text( (EDIT *)win->data);
	WindClose( win);
	WindDelete( win);
}

/*
 * convertit les tabulations en espace
 */

char *tab2spc( int tab, register char *dest, register char *src)
{
	register size_t i, count = 0, count2;
	char *beg = dest;
	
	while( *src != '\0' && 
		   *src != '\n' &&
		   *src != '\r' )
	{
		if( *src == '\t')
		{
			count2=0;
			i=(size_t)(dest-beg);
			while( i<count+tab)
			{
				*dest++ = ' ';
				i++;
			}
			src ++;
			count += tab;
		} else {
			*dest++ = *src++; 
			count2 ++; 
			if( count2 % tab == 0)
				count += tab;
		}
	}
	*dest = '\0';
	return beg;
}

void std_txt_drw( WINDOW *win)
{
	int x, y, w, h, effect=0, IdFont;
	int xy[4], pxy[8], quit, pos, winx, gdos, vgdos, dum;
	register size_t i;
	char buff[256], *p, *q, NameFont[33];
	EDIT *ptext;
	
	ptext = (EDIT *)win->data;

	WindGet( win, WF_WORKXYWH, &x, &y, &w, &h);
	vswr_mode( win -> graf . handle, MD_REPLACE);

	vsf_interior( win -> graf . handle, ptext -> finterior);
	vsf_color( win -> graf . handle, ptext -> fcolor);
	vsf_style( win -> graf . handle, ptext -> fstyle);
	vsf_perimeter( win -> graf . handle, 0);

	xy[0]=x;xy[1]=y;xy[2]=x+w-1;xy[3]=y+h-1;
	v_bar( win->graf.handle, xy);

	vswr_mode( win -> graf . handle, MD_TRANS);
	w = ptext -> hcell - ptext -> hcar;
	gdos = vq_gdos();
	vgdos = (vq_vgdos() == '_FSM');
	
	for( i=win->ypos; i<ptext->maxline ; i++)
	{
		y += ptext->hcell;
		if( y < clip.g_y)
			continue;
		/* convertion des tabulation en espace */
		tab2spc( ptext->tab, buff, get_line( ptext, i));
		q = buff;
		quit = pos = 0;
		winx = win->xpos;
		
		if( ptext -> flags & DISPLAYESCAPECODE)
		{
			if( strlen( buff) > win->xpos) {
				if( vgdos)
					v_ftext(win->graf.handle, x, y - w, buff + win->xpos);
				else
					v_gtext(win->graf.handle, x, y - w, buff + win->xpos);
			}
		}
		else
		while(1)
		{
			/* q pointe sur une chaine sans squence */
			
			p = strchr( q, WE_ESCAPE);

			if ( p == NULL)
			{
				quit = 1;
				p = q + strlen( q);
			}
			if( *(p+1) == WE_ESCAPE)
				p++;
			*p = '\0';

			if( strlen( q) > winx)
			{
				if( vgdos)
					v_ftext( win->graf.handle, x+pos, y-w, q + winx);
				else
					v_gtext( win->graf.handle, x+pos, y-w, q + winx);
				vqt_extent( win->graf.handle, q+winx, pxy);
				pos += (pxy[2] - pxy[0]);
			}
			winx = max(0,winx-(int)strlen( q));
			
			if( quit)
				break;
			
			if(*(p-1) != WE_ESCAPE)
			{
				switch( *++p) {
				case WE_COLOR:
					p++;
					if( app.color >= 16)
						vst_color( win->graf.handle, (*p - '0'==-1)?ptext->tcolor:*p - '0');
					break;
				case WE_BGCOLOR:
					p++;
					if( app.color >= 16 && ptext -> fcolor != *p - '0')
					{
						ptext -> fcolor = *p - '0';
						snd_rdw( win);
						return;
					}
					break;
				case WE_TABSIZE:
					p++;
					if( ptext -> tab != *p - '0')
					{
						ptext -> tab = *p - '0';
						snd_rdw( win);
						return;
					}
					break;
				case WE_FONT:
					p++;
					if( !gdos) break;
					if( ! ptext -> flagfont)
						ptext -> flagfont = vst_load_fonts( win -> graf.handle, 0)+app.work_out[10];
					if( *p == '0')	/* fonte par dfaut */
					{
						vst_font( win -> graf.handle, ptext->IdFont);
						break;
					}
					if( *p == '1')	/* fonte systme */
					{
						vst_font( win -> graf.handle, 1);
						break;
					}
					if( ptext -> TableFont && ptext -> TableFont[ *p - '0'][0] != '\0')
					{
						int count;
					
						for( count=0; count<ptext->flagfont; count ++)
						{
							IdFont = vqt_name( win->graf.handle, count, NameFont);
							if( !strcmp( NameFont, ptext -> TableFont[*p-'0']))
								break;
						}
					} else
						IdFont = vqt_name( win -> graf.handle, *p-'0', NameFont);
					vst_font( win -> graf.handle, IdFont);
					break;
				case WE_SIZE:
					p++;
					vst_height( win -> graf.handle, *p=='0'?ptext->hcar:*p-'0',
								&dum, &dum, &dum, &dum);
					break;
				case WE_SETNAMEFONT:
				{
					char *s;
		
					/* Initialisation de la table des fontes - si gdos() - */
					
					if( gdos)
					{
						p++;
						IdFont = *p -'0';
						if( !ptext -> TableFont)
						{
							if( ! ptext -> flagfont)
								ptext -> flagfont = vst_load_fonts( win -> graf.handle, 0)+app.work_out[10];
							ptext -> TableFont = (FONTNAME*) calloc( ptext -> flagfont ,
													sizeof( FONTNAME));
						}
					}
					p++;
					s=p;
					p = strchr( s, WE_ESCAPE); /* recherche de la fin de la string */
					if( p == NULL)	/* erreur */
					{
						p=s;
						p++;
						break;
					}
					*p='\0';
					if( gdos)
						strcpy( ptext->TableFont[IdFont], s);
					p++; /* skip '.' */
				}
				break;
				case WE_NORMAL:
					vst_alignment( win->graf.handle, 0, 0, &dum, &dum);
					effect = TE_NORMAL;
					vst_effects( win->graf.handle, effect);
					break;
				default:
					if( (*p & WE_NORMAL) == 0)
						break;
					*p &= 0xbf;
					if( *p & TE_EXPOSANT)
					{
						vst_alignment( win->graf.handle, 0, 2, &dum, &dum);
						break;
					}
					if( *p & TE_INDICE)
					{
						vst_alignment( win->graf.handle, 0, 4, &dum, &dum);
						break;
					}
					if( *p & TE_GRAS)
						effect |= TE_GRAS;
					if( *p & TE_LEGER)
						effect |= TE_LEGER;
					if( *p & TE_ITALIQUE)
						effect |= TE_ITALIQUE;
					if( *p & TE_SOULIGNE)
						effect |= TE_SOULIGNE;
					/* on verra + tard les cas exp et ind */
					vst_effects( win->graf.handle, effect);
				}
			}
			p ++;
			q = p;
		}
		if (y > min(xy[3], clip.g_y + clip.g_h-1))
			break;
	}
}

/* standart text read only keyhited
*/

void std_txt_rokey( WINDOW *win)
{
	int test_car( char);
	int xy[8];

	graf_mkstate( &xy[0], &xy[0], &xy[0], &xy[1]);

	switch( evnt.keybd >> 8){
	case HAUT:
		if( xy[1] & (K_LSHIFT | K_RSHIFT))
			snd_arrw( win, WA_UPPAGE);
		else 
			snd_arrw( win, WA_UPLINE);
		break;
	case BAS:
		if( xy[1] & (K_LSHIFT | K_RSHIFT))
			snd_arrw( win, WA_DNPAGE);
		else 
			snd_arrw( win, WA_DNLINE);
		break;
	case DROITE:
		snd_arrw( win, WA_RTPAGE); 
		break;
	case GAUCHE:
		snd_arrw( win, WA_LFPAGE);
		break;
	}
}


/* Cette fonction cre une fenetre texte avec les initialisations
	correctes */

/* Options: choix couleur fond et trame -> dans la structure texte! */


WINDOW *WindText( int flag, EDIT *ptext)
{
	WINDOW *win;
	int dum;
	int attrib[10];
	FONTNAME name;
	
	win = WindCreate( flag, app.x, app.y, app.w, app.h);
	if (win == NULL)
		return NULL; /* Fin si erreur cration fenetre */
	
	/* Les routines */
	win -> redraw = std_txt_drw;
	win -> destroy = std_txt_kill;
	win -> data = ptext;
	win -> keyhited = std_txt_rokey;
	
	/* Initialisation Attributs Vdi */
	
	if( ConfInquire( "TextSize", "%d", &ptext->size) != 1)
		ptext->size = 0;
	else
		vst_height( win->graf.handle, ptext->size, &dum, &dum, &dum, &dum);

	if( ConfInquire( "TextFont", "%S", name) != 1)
		ptext->IdFont = 1;
	else {
		dum = FontName2Id(name);
		ptext->IdFont = ( dum != -1)?dum:1;
	}
	
	
	if( vq_gdos()) {
		ptext -> flagfont = vst_load_fonts( win -> graf.handle, 0)+app.work_out[10];
		vst_font( win->graf.handle, ptext->IdFont);
	}
	
	vqt_attributes( win->graf.handle, attrib);

	ptext->wcar  = attrib[ 6];
	ptext->hcar  = attrib[ 7];
	ptext->wcell = attrib[ 8];
	ptext->hcell = attrib[ 9];
	
	ptext -> cursor = 0;
	ptext -> bloc   = 0;
	if( ConfInquire( "TextTabulator", "%d", &ptext->tab) != 1)
		ptext -> tab    = 4;
	if( ConfInquire( "TextBgColor", "%d", &ptext->fcolor) != 1)
		ptext -> fcolor = WHITE;
	if( ConfInquire( "TextBgStyle", "%d", &ptext->fstyle) != 1)
		ptext -> fstyle    = 8;
	ptext -> finterior = 2;
	if( ConfInquire( "TextCursColor", "%d", &ptext->ccolor) != 1)
		ptext -> ccolor = BLACK;
	if( ConfInquire( "TextColor", "%d", &ptext->tcolor) != 1)
		ptext -> tcolor = BLACK;
	vst_color( win->graf.handle, ptext -> tcolor);
	ptext -> flagfont  = 0;
	ptext -> TableFont = NULL;
	ptext -> flags = 0;
	
	/* Gestion des sliders */
	
	win->h_u = ptext->hcell;
	win->w_u = ptext->wcell;
	win->ypos_max = (int)ptext->maxline;
	win->xpos_max = __max_car;

	return(win);
}

/**********************************************************/

WINDOW *wprintf_init( int watt, char *title) {
	WINDOW *win;
	EDIT *ptext;
	
	ptext = init_text();
	if( ptext == NULL) return NULL;
	win = WindText( watt, ptext);
	WindSet( win, WF_NAME, title);
	return win;
}

void wprintf_exit( WINDOW *win) {
	std_txt_kill( win);
}

void wprintf_cls( WINDOW *win) {
	WindClose(win);
}

void wprintf( WINDOW *win, const char *format, ...)
{
	va_list args;
	char fo_buff[255], *p;
	EDIT *ptext;
	int x, y, w, h;

	va_start( args, format);
	vsprintf( fo_buff, format, args);
	p = fo_buff;
	va_end( args);

	/* La fenetre StdOut doit etre dtruite a la main */
	
	win->destroy = wprintf_cls;

	ptext = (EDIT *)win->data;
	if( !(win -> status & WS_OPEN))
	{
		WindGet( win, WF_PREVXYWH, &x, &y, &w, &h);
		WindOpen( win, x,y,w,h);
	}
	if( win != wglb.front)
	{
		WindSet( win, WF_TOP, 0, 0, 0, 0);
		wglb.front = win;	
	}
	if( win -> status & WS_ICONIFY)
		WindSet( win, WF_UNICONIFY, win->icon.x, win->icon.y,
					 win->icon.w, win->icon.h);

	WindGet( win, WF_WORKXYWH, &x, &y, &w, &h); 
	if( win -> ypos + h/ptext->hcell < ((int)ptext -> line))
		win -> ypos = (int)ptext -> line - h/ptext->hcell;

	while( *p != '\0')
	{
		if( *p == '\n')
			snd_arrw( win, WA_DNLINE);
		put_char( *p++, (EDIT *)win->data);
	}
	win -> ypos_max = (int)ptext -> maxline;
	snd_rdw( win);
	WindSlider( win, VSLIDER|HSLIDER);
}
