/*
 *	Excellent! 
 *	The module header file
 *	by Dominique Brziat, all right reserved
 */

#include <portab.h>

/*
 *	The windowing interface (from the GEM package 'WinDom')
 */

typedef WORD W_COLOR[3];

typedef struct _grafport
	{
		WORD	handle;		/*  Handle station de travail virtuelle */
		W_COLOR *palette;   /*  Palette de couleur de la station 	*/
	} W_GRAFPORT;

#ifdef __GNUC__
struct _window;
#endif


typedef struct {
		OBJECT *root;							/* Le menu */
		VOID (*proc)( struct _window *);		/* La fonction qui gre le menu */
	} W_MENU;

typedef struct {
	OBJECT *root,*real;
	VOID (*proc)( struct _window *);
	WORD  *save;
	WORD edit, curseur, nb_ob;
} W_FORM;
	
typedef struct {
		char *name;
		WORD x , y, w, h;	/* Coordonnes originale de la fentre
							 * non-icnifie. */
		VOID (*draw)(struct _window *);
	} W_ICON;

/*
 *	Fentre frame (point par data)
 */

typedef struct {
	struct _window *list,
				   *front,
				   *widget;
	WORD border;
	WORD color;
	WORD flags;
	} FRAME;

typedef struct {
	WORD line, col; /* diffre selon le status de la fenetre */
	WORD x,y,w,h;
	WORD flags;
	WORD vsldpos,vsldsize;
	WORD hsldpos,hsldsize;
	} FRAMEINFO;


typedef struct _window
	{
		WORD handle;
		WORD attrib;
		WORD status;
		W_GRAFPORT 	graf;
		W_MENU		menu;
		W_FORM		tool;
		W_ICON		icon;
		BOOLEAN fullsize;
		GRECT createsize;
		FRAMEINFO	frame;		/* info sur la frame */
		char *name, *info;
		WORD w_max, h_max;
		WORD w_min, h_min;
		LONG xpos, ypos;
		LONG xpos_max, ypos_max;
		WORD w_u, h_u;
		struct _window *next;

		WORD type;
		VOID *data;
		VOID *data2;
		
		/* evenements fentres */
		VOID (*redraw)(struct _window *);
		VOID (*topped)(struct _window *);
		VOID (*untopped)(struct _window *);
		VOID (*moved)(struct _window *);
		VOID (*sized)(struct _window *);
		VOID (*closed)(struct _window *);
		VOID (*iconified)(struct _window *);
		VOID (*uniconified)(struct _window *);
		VOID (*alliconified)(struct _window *);
		VOID (*hslided)(struct _window *);
		VOID (*vslided)(struct _window *);
		VOID (*fulled)(struct _window *);
		VOID (*uppaged)(struct _window *);
		VOID (*dnpaged)(struct _window *);
		VOID (*uplined)(struct _window *);
		VOID (*dnlined)(struct _window *);
		VOID (*lfpaged)(struct _window *);
		VOID (*rtpaged)(struct _window *);
		VOID (*lflined)(struct _window *);
		VOID (*rtlined)(struct _window *);

		/* les autres evenements GEM */
		VOID (*clicked)(struct _window *);
		VOID (*keyhited)(struct _window *);
		VOID (*timed)(struct _window *);
		
		/* les evenements non-GEM */
		VOID (*destroy)(struct _window *);
		VOID (*extramsg)(struct _window *);

	} WINDOW;

/*
 *	Interface with Excellent!
 */


typedef  char FONTNAME[33];

typedef struct {
		char 	*buff;			/* adresse du texte */
		LONG	bsize;			/* taille du texte  */
		LONG  	maxline;		/* nombre de ligne  */
		WORD	lsize;			/* largeur max d'une ligne */
		char	**line;			/* index des lignes */
		WORD	type;			/* type de buffer - voir ci dessous */
		char    name[255];		/* Nom du buffer */
		char	info[255];		/* Ligne d'information */
		char	mode[50];		/* decrit le mode dans la barre d'info */
		WORD	edit;			/* En mode dition : position curseur ou -1 */
		WORD	offset;			/* dbut dans la ligne d'dition */
		WORD	cmd;			/* index commande ou -1 */
		ULONG 	flags;			/* proprits du buffer */
		WORD	last;			/* Dernire commande utilis */
		VOID	*completion;	/* Liste de mots pour la compltion */
		WORD	wcar, hcar;		/* Taille caractre */
		WORD	wcell, hcell;	/* Taille cellule de caractre */
		WORD 	lb1, cb1, lb2, cb2;	/* bloc management */
		LONG	timer;			/* dcompte timer */
		/* Apparence cran */
		WORD 	tab;			/* Taille tabulation */
		WORD 	bgcolor;		/* mmoire couleur fond cran */
		WORD	flagfont;		/* gestion fonte */
		WORD	IdFont;			/* Id font texte */
		WORD	SizeFont;		/* Taille texte */
		WORD 	*TableFont;		/* Table des fontes (code escape)*/
	} BUFFER;

/* ============================= *
 *	Values of the field 'flags'  *
 * ============================= */

/* mode d'dition */
#define EDIT_PARA	0x0001		/* Mode d'dition de paramtre */
#define EDIT_BIND	0x0002		/* Mode saisie de raccourci clavier */
#define EDIT_CMD	0x0004		/* Mode d'dition de commande */
/* buffer */
#define READONLY	0x0008		/* Le buffer est read only */
#define BUF_CHANGE	0x0010		/* Le buffer a t modifi */
#define INMEMORY	0x0020		/* Le buffer n'existe qu'en mmoire */
/* affichage */
#define	MODE_ESC	0x0040		/* Mode d'affichage des codes escape */
#define MODE_HEXA	0x0080		/* Mode d'affichage hexadcimale */

/* 
 * sous mode de EDIT_PARA
 */

#define REALTIME	0x0100		/* dition en temps rel */
/* templates */
#define TMP_NUME	0x0200		/* numrique */
#define TMP_STRG	0x0400		/* alphanumrique */
#define TMP_FILE	0x0800		/* fichier */
/* compltion */
#define CMP_PATH	0x1000		/* nom de fichier */
#define	CMP_CMD		0x2000		/* commande */
#define CMP_USER	0x4000		/* futur, la compltion associe  une liste quelconque */


/*
 *	Type de buffer
 */

#define T_DOS		0
#define T_NULL		1
#define T_BIN		2
#define T_UNIX		3
#define T_MAC		4

typedef struct _mod_data {
		VOID *(*_realloc)(VOID *,size_t);
		WORD (*_conf)( char *, char *, ...);
		VOID (*_init_edit)( BUFFER *, char *, char *, WORD);
		VOID (*_exit_edit)( BUFFER *);
		BUFFER *(*_load)( char *);
		BUFFER *(*_creat)( char *, char *, WORD, WORD, LONG);
		WORD	(*_gem_exec)( char *, char *, VOID *, WORD , WORD );
		VOID *env;
		AESPB *aespb;
	} MOD_DATA;


/* Values returned by function */

#define M_REDRAW 0x1
#define M_SLIDER 0x2
#define M_WINDOW 0x4
#define M_INFO	 0x8

/* Rich Text */

#define ESCAPE	''
#define NORM	'@'
#define BOLD	'A'
#define LIGHT	'B'
#define ITALIC	'D'
#define LINED	'H'
#define SUPS	'P'
#define SUBS	'`'
#define FGCOLOR	'#'

/* Usefull macros */

#define max(a,b)		(((a)>(b))?(a):(b))
#define min(a,b)		(((a)<(b))?(a):(b))
#define UNUSED( a)		((VOID )(a))
#define GET_BUFFER(win)	((BUFFER *)win->data)

#define CONF		(*data->_conf)
#define REALLOC		(*data->_realloc)
#define MALLOC(l)	(*data->_realloc)(NULL,l)
#define FREE(ptr)	(*data->_realloc)(ptr,0UL)
#define	INIT_EDIT	(*data->_init_edit)
#define EXIT_EDIT	(*data->_exit_edit)
#define LOAD		(*data->_load)
#define CREAT		(*data->_creat)
#define EXEC		(*data->_gem_exec)

#define MODULE(a)	WORD CDECL (a)( WINDOW *win, BUFFER **out, MOD_DATA *data)
