/* Test de la librairie win_vdi */

#include <winvdi.h>
#include <math.h>
#include <stdlib.h>

void w_get_bkgr(int of_x, int of_y, int of_w, int of_h, MFDB *img);
void w_put_bkgr(int of_x, int of_y, int of_w, int of_h, MFDB *img);

#define VDI_LIMIT	128
int tab[VDI_LIMIT*4];

void draw_courbe( WINDOW *win)
{
	int i;
	float f;
	
	w_clrwk( win);
	w_gtext( win, 20, 20, " Calcul des sinus ...");

	snd_rdw( win);
	EvntWindom(MU_MESAG);
	
	for( i = 0; i < VDI_LIMIT*4; i++)
	{
		tab[i*2] = i+20;
		f = i;
		tab[i*2+1] = 150-(int)(50.*sin( (double)(f/33.)));
	}

	/* On est limit par des tableaux 128 (vdi) */
	w_clrwk( win);
	w_gtext( win, 20, 20, " Et voii une belle sinusoide");
	w_pline( win, VDI_LIMIT/2, tab); 
	w_pline( win, VDI_LIMIT/2, tab+VDI_LIMIT);
	w_pline( win, VDI_LIMIT/2, tab+VDI_LIMIT*2); 
	w_pline( win, VDI_LIMIT/2, tab+VDI_LIMIT*3);
	snd_rdw( win);
}

int main( void)
{
	WINDOW *win;
	MFDB mfdb;
	int w,h,key;
	int xy[8];
	long screen = 0L;
	
	ApplInit();

	win = WindVdi( WAT_NOINFO, 500, 400);
	
	WindOpen( win, -1, -1, 500, 400);
	WindSlider( win, HSLIDER|VSLIDER);
	
	w_gtext( win, 50, 15, "Bonjour  tous et bienvenue dans la dmo");
	w_gtext( win, 50, 35, "   de la librairie windows win_vdi.");
	w_gtext( win, 50, 60, "Cette librairie vous permet de simuler");
	w_gtext( win, 50, 80, "trs facilement des appels vdi dans une");
	w_gtext( win, 50, 100, "fenetre sous l'environnement WinDom.");
	w_gtext( win, 50, 120, "Vous pouvez agir sur la fenetre, l'AES ");
	w_gtext( win, 50, 140, "n'est pas bloqu.");
	w_gtext( win, 50, 285, "appuyez sur une touche pour continuer...");
	if( WindKey( win) == -1) goto END;

	draw_courbe( win);
	if( WindKey( win) == -1) goto END;
			
	w_clrwk( win);
	w_gtext( win, 50, 15, "par exemple pour afficher ce texte, il m'a suffit");
	w_gtext( win, 50, 35, "de l'appel de deux fonctions! Et cinq en tout!");
	
	w_gtext( win, 20, 60, "#include <windows\windows.h>");
	w_gtext( win, 20, 80, "#include <windows\win_vdi.h>");
	w_gtext( win, 20, 110, "void main(){");
	w_gtext( win, 20, 130, "	init_windows( "", -1);");
	w_gtext( win, 20, 150, "    win = new_vdi_win( ...);");
	
	w_gtext( win, 50, 285, "appuyez sur une touche pour continuer...");
	if( WindKey( win) == -1) goto END;
			
	w_clrwk( win);	
	w_gtext( win, 50, 15, "Et voici un disque:");
	wsf_color( win, 1);
	w_circle( win, 100, 100, 50);
	w_gtext( win, 50, 285, "appuyez sur une touche pour continuer...");
	xy[ 0] = 0; xy[ 1] = 0; xy[ 2] = 100; xy[ 3] = 100;
	if( WindKey( win) == -1) goto END;
		
	vsl_color( win->graf.handle, RED);
	vsl_type( win->graf.handle, 1);
	w_pline( win, 2, xy);
	if( WindKey( win) == -1) goto END;

	w_clrwk( win);

	w_gtext( win, 30,15,"Test des GDP:");
	wsf_color(win, 2);
	xy[0]=50;
	xy[1]=30;
	xy[2]=100;
	xy[3]=80;
	w_bar( win, xy);
	
	wsf_color(win,4);
	w_ellipse(win, 75, 125, 40, 60);

	if( WindKey( win) == -1) goto END;

	w_clrwk( win);
	w_gtext( win, 30,15,"Test vro_cpyfm:");
	w = h = 100;
	xy[0] = 0;
	xy[1] = 0;
	xy[2] = w-1;
	xy[3] = h-1;
	xy[4] = 40;
	xy[5] = 40;
	xy[6] = 40+w-1;
	xy[7] = 40+h-1;
	w_get_bkgr( 0, 0, w, h, &mfdb);
	wro_cpyfm( win, S_ONLY, xy, (MFDB *)&mfdb, (MFDB *)&screen);

	WindKey( win);
	
	while( wglb.first)
	{
		snd_msg( wglb.first, WM_CLOSED, 0, 0, 0, 0);
		EvntWindom(MU_MESAG);
	}
	
END:
	free( mfdb.fd_addr);
	ApplExit();
	return(0);
}