/* Librairie pour windom
	permet la simulation des appels vdi graphiques
	dans une fenetre.
*/

#ifndef __WIN_VDI
#define __WIN_VDI

#include <windom.h>

#define WT_VDI 	 	8
#define WAT_NOINFCLS 0x4FED

typedef struct _vdi_evnt{
		int opcode1;
		int opcode2;
		int nbptsin;
		int nbintin;
		int begptsin;
		int endptsin;
		int *ptsin;
		int *intin;
		struct _vdi_evnt *next;
	} VDI_EVNT;

/* Lignes & attributs */
void w_pline( WINDOW *win, int count, int *xy);

/* GDP */
void w_bar( WINDOW *win, int pxy[4]);
void w_arc( WINDOW *win, int x, int y, int r, int a1, int a2);
void w_pieslice( WINDOW *win, int x, int y, int r, int a1, int a2);
void w_circle( WINDOW *win, int x, int y, int r);
void w_ellipse( WINDOW *win, int x, int y, int rx, int ry);
void w_ellarc( WINDOW *win, int x, int y, int rx, int ry, int a1, int a2);
void w_ellpie( WINDOW *win, int x, int y, int rx, int ry, int a1, int a2);
void w_rbox( WINDOW *win, int pxy[4]);
void w_rfbox( WINDOW *win, int pxy[4]);
void w_justified( WINDOW *win, int x, int y, char *text, int length,
					int wspace, int cspace);

/* autre */
void w_contourfill( WINDOW *win, int x, int y, int color);
void w_fillarea( WINDOW *win, int count, int *pxy);
void wr_recfl( WINDOW *win, int *pxy);
void wro_cpyfm( WINDOW *win, int mode, int *pxy, MFDB *src, MFDB *dest);

/* Texte et attributs */
void w_gtext( WINDOW *win, int x, int y, char *text);
void w_ftext( WINDOW *win, int x, int y, char *text);
void wst_color( WINDOW *win, int color);
void wst_effects( WINDOW *win, int effects);
void wst_font( WINDOW *win, int index);

/* Attribut Fill */
void wsf_color( WINDOW *win, int color);
void wsf_style( WINDOW *win, int style);
void wsf_interior( WINDOW *win, int interior);
void wsf_perimeter( WINDOW *win, int flag);

/* Attribut Line */
void wsl_color( WINDOW *win, int color);
void wsl_ends( WINDOW *win, int start, int end);
void wsl_type( WINDOW *win, int type);
void wsl_udsty( WINDOW *win, int pattern);
void wsl_width( WINDOW *win, int width);

/* Attribut markers */
void w_pmarker( WINDOW *win, int count, int *pxy);
void wsm_color( WINDOW *win, int color);
void wsm_height( WINDOW *win, int size);
void wsm_type( WINDOW *win, int type);

/* general */
void w_clrwk( WINDOW *win);
void wswr_mode( WINDOW *win, int mode);
void ws_color( WINDOW *win, int color, int *rgb);


/* Fonction WinDom */
WINDOW *WindVdi( int attrib, int wwork, int hwork);
int WindKey( WINDOW * win);

#endif