/* Librairie pour windows
	permet la simulation des appels vdi graphiques
	dans une fenetre. Version 2.
*/

#include <stdlib.h>
#include <string.h>
#include <windom.h>

#define W_VDI 	 	8

#define V_CLRWK	 		3
#define V_PLINE			6
#define V_PMARKER		7
#define V_GTEXT			8
#define V_FILLAREA		9

#define GDP				11
#define V_BAR			1
#define V_ARC			2
#define V_PIESLICE		3
#define	V_CIRCLE		4
#define V_ELLIPSE		5
#define V_ELLARC		6
#define	V_ELLPIE		7
#define V_RBOX			8
#define V_RFBOX			9
#define V_JUSTIFIED		10

#define VS_COLOR		14
#define VSL_TYPE		15
#define VSL_WIDTH		16
#define VSL_COLOR		17
#define VSM_TYPE		18
#define VSM_HEIGHT		19
#define VSM_COLOR		20
#define VST_FONT		21
#define VST_COLOR		22
#define VSF_INTERIOR	23
#define VSF_STYLE   	24
#define VSF_COLOR		25
#define VSWR_MODE		32
#define V_CONTOURFILL	103
#define VSF_PERIMETER	104
#define VST_EFFECTS		106
#define VSL_ENDS		108
#define VRO_CPYFM		109
#define VSL_UDSTY		113
#define VR_RECFL		114
#define V_FTEXT			241

typedef struct _vdi_evnt{
		int opcode1;
		int opcode2;
		int nbptsin;
		int nbintin;
		int begptsin;	/* pour vro_cpyfm */
		int endptsin;
		int *ptsin;
		int *intin;
		struct _vdi_evnt *next;
	} VDI_EVNT;


VDI_EVNT *add_vdi_evnt( int *contrl, int *ptsin, int *intin, VDI_EVNT *root);

VDI_EVNT *add_vdi_evnt( int *contrl, int *ptsin, int *intin, VDI_EVNT *root)
{
register int i;

	while( root -> next)
		root = root -> next;
	root -> next = (VDI_EVNT *)malloc( sizeof( VDI_EVNT));
	root = root -> next;
	root -> opcode1 = contrl[0];
	root -> opcode2 = contrl[5];
	root -> nbptsin = contrl[1];
	root -> nbintin = contrl[3];
	root -> begptsin = 0;
	root -> endptsin = contrl[1];
	if( contrl[1])
	{
		root -> ptsin = (int *)malloc( sizeof(int)*contrl[1]*2);
		for(i=0;i<contrl[1]*2;i++)
			root -> ptsin[i] = ptsin[i];
	}
	if( contrl[3])
	{
		root -> intin = (int *)malloc( sizeof(int)*contrl[3]);
		for(i=0;i<contrl[3];i++)
			root -> intin[i] = intin[i];
	}
	root -> next = NULL;
	return root;
}

/********************************************************************/
/* Les fonctions vdi rinplant pour windows */

void w_clrwk( WINDOW *win)
{
/* On simule v_clrwk: on vide les venements VDI_EVNT.
	En fait: il faudra faire un fontion qui fface une
	fenetre (ce que fait w_clrwk) et une vraie fonction
	w_clrwk qui la meme chose que celle-ci plus un
	appel a v_clrwk */

	register VDI_EVNT *new_evnt, *scan;

	new_evnt = ((VDI_EVNT *)win -> data)->next;
	while( new_evnt)
	{
		scan = new_evnt;
		new_evnt = new_evnt -> next;
		if( scan -> nbintin)
			free( scan -> intin);
		if( scan -> nbptsin)
			free( scan -> ptsin);
		free( scan);		
	}
	((VDI_EVNT *)win -> data)->next = NULL;
}

/*
 *	vro_cpyfm() essait implementation
 *		utilisation: mmoire -> fenetre uniquement
 */

void wro_cpyfm( WINDOW *win, int mode, int *pxy, MFDB *src, MFDB *dest)
{
	int contrl[11];
	VDI_EVNT *evnt;
	
	contrl[0] = VRO_CPYFM;
	contrl[1] = 4;
	contrl[3] = 1;
	contrl[7] = (int)((long)src>>16);
	contrl[8] = (int)src;
	contrl[9] = (int)((long)dest>>16);
	contrl[10] = (int)dest;
	
	evnt = add_vdi_evnt( contrl, pxy, &mode, (VDI_EVNT *) win -> data);
	evnt -> begptsin = 2;
}


void ws_color( WINDOW *win, int color, int *rgb)
{
	int contrl[6];
	int intin[4];
	
	contrl[0] = VS_COLOR;
	contrl[1] = 0;
	contrl[3] = 4;
	intin[0] = color;
	intin[1] = rgb[0];
	intin[2] = rgb[1];
	intin[3] = rgb[2];
	add_vdi_evnt( contrl, NULL, intin, (VDI_EVNT *) win -> data);
}

void wswr_mode( WINDOW *win, int mode)
{
	int contrl[6];
	
	contrl[0] = VSWR_MODE;
	contrl[1] = 0;
	contrl[3] = 1;
	add_vdi_evnt( contrl, NULL, &mode, (VDI_EVNT *) win -> data);
}

void w_contourfill( WINDOW *win, int x, int y, int color)
{
	int contrl[6];
	int ptsin[2];
	
	contrl[0] = V_CONTOURFILL;
	contrl[1] = 1;
	contrl[3] = 1;
	ptsin[0] = x;
	ptsin[1] = y;
	add_vdi_evnt( contrl, ptsin, &color, (VDI_EVNT *) win -> data);
}

void w_fillarea( WINDOW *win, int count, int *pxy)
{
	int contrl[6];
	
	contrl[0] = V_PLINE;
	contrl[1] = count;
	contrl[3] = 0;
	add_vdi_evnt( contrl, pxy, NULL, (VDI_EVNT *) win -> data);
}

void wr_recfl( WINDOW *win, int *pxy)
{
	int contrl[6];
	
	contrl[0] = VR_RECFL;
	contrl[1] = 2;
	contrl[3] = 0;
	add_vdi_evnt( contrl, pxy, NULL, (VDI_EVNT *) win -> data);
}

void w_pline( WINDOW *win, int count, int *pxyarray)
{
	int contrl[6];
	
	contrl[0] = V_PLINE;
	contrl[1] = count;
	contrl[3] = 0;
	add_vdi_evnt( contrl, pxyarray, NULL, (VDI_EVNT *) win -> data);
}

void w_bar( WINDOW *win, int pxy[4])
{
	int contrl[6];
	
	contrl[0] = GDP;
	contrl[1] = 2;
	contrl[3] = 0;
	contrl[5] = V_BAR;
	add_vdi_evnt( contrl, pxy, NULL, (VDI_EVNT *) win -> data);
}

void w_arc( WINDOW *win, int x, int y, int r, int a1, int a2)
{
	VDI_EVNT *evnt;
	int contrl[6];
	int ptsin[8];
	int intin[2];
	
	contrl[0] = GDP;
	contrl[1] = 4;
	contrl[3] = 2;
	contrl[5] = V_ARC;
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = ptsin[3] = ptsin[4] = ptsin[5] = ptsin[7] = 0;
	ptsin[6] = r;
	intin[0] = a1;
	intin[1] = a2;
	evnt=add_vdi_evnt( contrl, ptsin, intin, (VDI_EVNT *) win -> data);
	evnt->endptsin = 2;
}

void w_pieslice( WINDOW *win, int x, int y, int r, int a1, int a2)
{
	VDI_EVNT *evnt;
	int contrl[6];
	int ptsin[8];
	int intin[2];
	
	contrl[0] = GDP;
	contrl[1] = 4;
	contrl[3] = 2;
	contrl[5] = V_PIESLICE;
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = ptsin[3] = ptsin[4] = ptsin[5] = ptsin[7] = 0;
	ptsin[6] = r;
	intin[0] = a1;
	intin[1] = a2;
	evnt=add_vdi_evnt( contrl, ptsin, intin, (VDI_EVNT *) win -> data);
	evnt->endptsin = 1;
}

void w_circle( WINDOW *win, int x, int y, int r)
{
	VDI_EVNT *evnt;
	int contrl[6];
	int ptsin[6];
	
	contrl[0] = GDP;
	contrl[1] = 3;
	contrl[3] = 0;
	contrl[5] = V_CIRCLE;
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = ptsin[3] = ptsin[5] = 0;
	ptsin[4] = r;
	evnt=add_vdi_evnt( contrl, ptsin, NULL, (VDI_EVNT *) win -> data);
	evnt->endptsin = 1;
}

void w_ellipse( WINDOW *win, int x, int y, int rx, int ry)
{
	VDI_EVNT *evnt;
	int contrl[6];
	int ptsin[4];
	
	contrl[0] = GDP;
	contrl[1] = 2;
	contrl[3] = 0;
	contrl[5] = V_ELLIPSE;
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = rx;
	ptsin[3] = ry;
	evnt=add_vdi_evnt( contrl, ptsin, NULL, (VDI_EVNT *) win -> data);
	evnt->endptsin = 1;
}

void w_ellarc( WINDOW *win, int x, int y, int rx, int ry, int a1, int a2)
{
	VDI_EVNT *evnt;
	int contrl[6];
	int ptsin[4];
	int intin[2];
	
	contrl[0] = GDP;
	contrl[1] = 2;
	contrl[3] = 2;
	contrl[5] = V_ELLARC;
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = rx;
	ptsin[3] = ry;
	intin[0] = a1;
	intin[1] = a2;
	evnt=add_vdi_evnt( contrl, ptsin, intin, (VDI_EVNT *) win -> data);
	evnt->endptsin = 1;
}

void w_ellpie( WINDOW *win, int x, int y, int rx, int ry, int a1, int a2)
{
	VDI_EVNT *evnt;
	int contrl[6];
	int ptsin[4];
	int intin[2];
	
	contrl[0] = GDP;
	contrl[1] = 2;
	contrl[3] = 2;
	contrl[5] = V_ELLPIE;
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = rx;
	ptsin[3] = ry;
	intin[0] = a1;
	intin[1] = a2;
	evnt=add_vdi_evnt( contrl, ptsin, intin, (VDI_EVNT *) win -> data);
	evnt->endptsin = 1;
}

void w_rbox( WINDOW *win, int pxy[4])
{
	int contrl[6];
	
	contrl[0] = GDP;
	contrl[1] = 2;
	contrl[3] = 0;
	contrl[5] = V_RBOX;
	add_vdi_evnt( contrl, pxy, NULL, (VDI_EVNT *) win -> data);
}

void w_rfbox( WINDOW *win, int pxy[4])
{
	int contrl[6];
	
	contrl[0] = GDP;
	contrl[1] = 2;
	contrl[3] = 0;
	contrl[5] = V_RFBOX;
	add_vdi_evnt( contrl, pxy, NULL, (VDI_EVNT *) win -> data);
}

void w_justified( WINDOW *win, int x, int y, char *text, int length,
					int wspace, int cspace)
{
	VDI_EVNT *evnt;
	int i=2;
	int contrl[6];
	int intin[157];
	int ptsin[2];

	contrl[0] = GDP;
	contrl[1] = 2;
	contrl[3] = (int)strlen( text)+2;
	contrl[5] = V_JUSTIFIED;
	while( *text != '\0')
	{
		intin[ i] = 0;
		intin[ i++] += (unsigned char)*text++;
	}
	intin[0] = wspace;
	intin[1] = cspace;
	ptsin[0] = x;
	ptsin[1] = y;
	ptsin[2] = length;
	ptsin[3] = 0;
	evnt = add_vdi_evnt( contrl, ptsin, intin, (VDI_EVNT *) win -> data);
	evnt -> endptsin = 1;
}


void w_gtext( WINDOW *win, int x, int y, char *text)
{
	int i=0;
	int contrl[6];
	int intin[157];
	int ptsin[2];

	contrl[0] = V_GTEXT;
	contrl[1] = 1;
	contrl[3] = (int)strlen( text);
	while( *text != '\0')
	{
		intin[ i] = 0;
		intin[ i++] += (unsigned char)*text++;
	}
	ptsin[0] = x;
	ptsin[1] = y;
	add_vdi_evnt( contrl, ptsin, intin, (VDI_EVNT *) win -> data);
}

void w_ftext( WINDOW *win, int x, int y, char *text)
{
	int i=0;
	int contrl[6];
	int intin[157];
	int ptsin[2];

	contrl[0] = V_FTEXT;
	contrl[1] = 1;
	contrl[3] = (int)strlen( text);
	while( *text != '\0')
	{
		intin[ i] = 0;
		intin[ i++] += (unsigned char)*text++;
	}
	ptsin[0] = x;
	ptsin[1] = y;
	add_vdi_evnt( contrl, ptsin, intin, (VDI_EVNT *) win -> data);
}


/* Text attribut */

void wst_color( WINDOW *win, int color)
{
	int contrl[6];
	
	contrl[0]=VST_COLOR;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &color, (VDI_EVNT *)win->data);
}

void wst_effects( WINDOW *win, int effects)
{
	int contrl[6];
	
	contrl[0]=VST_EFFECTS;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &effects, (VDI_EVNT *)win->data);
}

void wst_font( WINDOW *win, int index)
{
	int contrl[6];
	
	contrl[0]=VST_FONT;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &index, (VDI_EVNT *)win->data);
}

/* Fill attribut */

void wsf_color( WINDOW *win, int color)
{
	int contrl[6];
	
	contrl[0]=VSF_COLOR;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &color, (VDI_EVNT *)win->data);
}

void wsf_perimeter( WINDOW *win, int flag)
{
	int contrl[6];
	
	contrl[0]=VSF_PERIMETER;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &flag, (VDI_EVNT *)win->data);
}

void wsf_style( WINDOW *win, int style)
{
	int contrl[6];
	
	contrl[0]=VSF_STYLE;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &style, (VDI_EVNT *)win->data);
}

void wsf_interior( WINDOW *win, int interior)
{
	int contrl[6];
	
	contrl[0]=VSF_INTERIOR;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &interior, (VDI_EVNT *)win->data);
}

/* Attribut Line */

void wsl_color( WINDOW *win, int color)
{
	int contrl[6];
	
	contrl[0]=VSL_COLOR;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &color, (VDI_EVNT *)win->data);
}

void wsl_ends( WINDOW *win, int start, int end)
{
	int contrl[6];
	int intin[2];
	
	contrl[0]=VSL_ENDS;
	contrl[1]=0;
	contrl[3]=2;
	intin[0] = start;
	intin[1] = end;
	add_vdi_evnt( contrl, NULL, intin, (VDI_EVNT *)win->data);
}

void wsl_type( WINDOW *win, int type)
{
	int contrl[6];
	
	contrl[0]=VSL_TYPE;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &type, (VDI_EVNT *)win->data);
}

void wsl_udsty( WINDOW *win, int pattern)
{
	int contrl[6];
	
	contrl[0]=VSL_UDSTY;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &pattern, (VDI_EVNT *)win->data);
}

void wsl_width( WINDOW *win, int width)
{
	int contrl[6];
	
	contrl[0]=VSL_WIDTH;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &width, (VDI_EVNT *)win->data);
}

/* Attribut markers */

void w_pmarker( WINDOW *win, int count, int *pxy)
{
	int contrl[6];
	
	contrl[0] = V_PMARKER;
	contrl[1] = count;
	contrl[3] = 0;
	add_vdi_evnt( contrl, pxy, NULL, (VDI_EVNT *) win -> data);
}

void wsm_color( WINDOW *win, int color)
{
	int contrl[6];
	
	contrl[0]=VSM_COLOR;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &color, (VDI_EVNT *)win->data);
}

void wsm_height( WINDOW *win, int size)
{
	int contrl[6];
	
	contrl[0]=VSM_HEIGHT;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &size, (VDI_EVNT *)win->data);
}

void wsm_type( WINDOW *win, int type)
{
	int contrl[6];
	
	contrl[0]=VSM_TYPE;
	contrl[1]=0;
	contrl[3]=1;
	add_vdi_evnt( contrl, NULL, &type, (VDI_EVNT *)win->data);
}

/******************************************************************/
/* Les fonctions gestions de fenetres */

void std_vdi_drw( WINDOW *win)
{
	register VDI_EVNT *vdiop;
	int x, y, w, h, i;
	VDIPB vdipb;
	int ptsin[128];

	WindGet( win, WF_WORKXYWH, &x, &y, &w, &h);
	
	WindClear( win);
	
	/* On execute la liste des actions vdi */
	vdiop = ((VDI_EVNT *) win -> data)->next;
	while( vdiop)
	{
		for( i=0; i<vdiop->nbptsin; i++)
		{
			if( i<vdiop->endptsin && i>=vdiop->begptsin)
			{
				ptsin[2*i] = x - (int)win->xpos*win->w_u + vdiop->ptsin[2*i];
				ptsin[2*i+1] = y - (int)win->ypos*win->h_u + vdiop->ptsin[2*i+1];
			}
			else
			{
				ptsin[2*i] = vdiop->ptsin[2*i];
				ptsin[2*i+1] = vdiop->ptsin[2*i+1];
			}
		}

		_VDIParBlk.contrl[0] = vdiop->opcode1;
		_VDIParBlk.contrl[1] = vdiop->nbptsin;
		_VDIParBlk.contrl[3] = vdiop->nbintin;
		_VDIParBlk.contrl[5] = vdiop->opcode2;
		_VDIParBlk.contrl[6] = win->graf.handle;
		
		vdipb . contrl = _VDIParBlk . contrl;
		vdipb . ptsin = ptsin;
		vdipb . intin = vdiop -> intin;
		vdipb . ptsout = _VDIParBlk . ptsout;
		vdipb . intout = _VDIParBlk . intout;
		
		vdi( &vdipb);
		
		vdiop = vdiop -> next;
	}
}

void std_vdi_dty( WINDOW *win)
{
VDI_EVNT *vdi_action, *scan;

	vdi_action = (VDI_EVNT *)win -> data;
	while( vdi_action)
	{
		scan = vdi_action;
		vdi_action = vdi_action -> next;
		if( scan -> nbptsin)
			free( scan -> ptsin);
		if( scan -> nbintin)
			free( scan -> intin);
		free( scan);		
	}
	WindClose( win);
	WindDelete( win);
}

/*
	size = position de la fenetre et taille de la feuille
		   de travail (La fonction adapte la taille de la
		   fenetre a celle de la feuille).
		   
	w, h = taille de la feuille de travail
*/

WINDOW *WindVdi( int attrib, int wwork, int hwork)
{
	WINDOW *win;
	VDI_EVNT *vdi_action;
/*	GRECT coord;
	int dum, w, h;*/

	vdi_action = (VDI_EVNT *)malloc( sizeof(VDI_EVNT));
	vdi_action -> opcode1 = V_CLRWK;
	vdi_action -> next = NULL;
	
/*	wind_calc( WC_BORDER, attrib, 0, 0, size->g_w,
			   size->g_h, &dum, &dum, &w, &h);
	
	coord . g_x = max( size -> g_x, app.x);
	coord . g_y = max( size -> g_y, app.y);
	coord . g_w = min( w, app.w - coord . g_x);
	coord . g_h = min( h, app.h - coord . g_y); */

	win = WindCreate( attrib, app.x, app.y, app.w, app.h);
	
	if( !win)
	{
		free( vdi_action);
		return NULL;
	}

	win -> redraw = std_vdi_drw;
	win -> destroy = std_vdi_dty;
	win -> data = (void *)vdi_action;
	win -> type = W_VDI;
	win -> w_max = wwork;
	win -> h_max = hwork;
	win -> h_u = 6;	/* 6 semble etre un bon choix */
	win -> w_u = 6;
	win -> xpos_max = wwork / 6;
	win -> ypos_max = hwork / 6;

/*	WindOpen( win, coord.g_x, coord.g_y, coord.g_w, coord.g_h);
	WindSlider( win, VSLIDER|HSLIDER); */
/*
	if( attrib & NAME)
		WindSet( win, WF_NAME, name);
	if( attrib & INFO)
		WindSet( win, WF_NAME, info); */
	return win;
}

/* Cette fonction attend que l'on press une touche et retourne
	la valeur de la touche.
   Rem: Ne bloque pas les venements GEM.
*/

int WindKey( WINDOW *win)
{
	int evnt_res, top, dum, handle;
	
	handle = win -> handle;
	do {
		evnt_res = EvntWindom( MU_MESAG | MU_KEYBD);
		WindGet( NULL, WF_TOP, &top, &dum, &dum, &dum);
		if( evnt_res & MU_KEYBD && top == win->handle)
		{
			snd_rdw( win);
			return evnt.keybd;
		}
	} while( WindHandle(handle) != NULL);
	return -1;
}


/* Nouvelle fonction:
	sauvegarde du contenu fenetre VDI dans un fichier
	METAFILE.
*/

/* Lire un word au format intel */

int ReadIntelWord( int );

int ReadIntelWord( int i)
{
char hi, lo;

	lo = (char)i;
	hi = (char)(i>>8);
	return( ((int)lo<<8) + ((int)hi));
}

#define Macro( i) ( (int)((char)(i))<<8 + (int)((char)(i)>>8) )

/* tableau contrl:								metafile
	mot 0: opcode vdi,							idem
	mot 1: nb couple coord dans ptsin			idem
	mot 3: nb valeurs dans intin				idem (mot 2)
	mot 5: num sous fonction ou 0				idem (mot 3)
	mot 6: handle Vdi							element ptsin ...
	mot											element intin ...
*/

/* executer une fonction vdi: utiliser la fonction
	vdi( VDIPB *vdipb );   avec le tableau VDIPB->contrl correctement
	initialis.
*/