/*--------------------------------------------------------------
*                                                              *
*		Header for DOLMEN-XBIOS-Library (rev. 1Beta)               *
*		for PureC                                                  *
*		Auteur: David REN                                         *
*                                                              *
*		Last update, dernire Mise  Jour: 23.02.98	               *
*                                                              *
*   Tabulation texte = 2,   Tab setting = 2                    *
*                                                              *
*   DOLMEN is trademark of CENTEK compagny                     *
*                                                              *
*--------------------------------------------------------------*/

#ifndef __DOLMEN__
#define __DOLMEN__

typedef struct
{
	int	x;
	int	y;
} VPOS;

typedef struct
{
	long sys_id;				/* nom de la librairie ou un numro ex: "_VID" */
	long sys_ver;				/* version de la librairie ex: 1.0.1 (0x101) */
	long sys_date;			/* date de la librairie ex: 0x01061997(01/06/1997) */
  char *sys_version;	/* pointeur sur un texte de 4 lignes de 40
  											 caractres. Un CR+LF termine chaque ligne.
  											 Le texte est termin	par un 0. */
	long *sys_install;	/* routine d'installation du driver */
	long *sys_open;			/* routine appel pour  chaque ouverture d'une station */
	long *sys_close;		/* ... la fermeture */
} DOLMEN_DRV_HEADER;

typedef struct
{
	DOLMEN_DRV_HEADER Head;
	long *vid_maj_vars;						/* pointeur sur les variables principales */
	long *vid_cur_vars;						/* pointeur sur les variables courantes */
	void (*vid_shut_down)(void);	/* routine d'extinction	 */
	void (*vid_wake_up)(void);		/* routine de reveil     */
} COOKIE_VID;

typedef struct
{
	long cnts_name;			/* nom du cookie */
	long cnts_version;	/* numro de la version, ex: 1.0.1 (0x101) */
	char cnts_kbd_on;		/* flag activant le reveil au clavier */
	char cnts_midi_on;	/* idem pour le midi */
	char cnts_mouse_on;	/* idem pour la souris */
	char cnts_joy_on;		/* idem_pour les joysticks */
	char cnts_tst_eco;  /* combinaison de touches pour activer l'conomiseur */
	char cnts_turbo_on; /* valide le turbo de la souris */
} COOKIE_CNTS;


/* mode code xxxx xxxF SOPV 8NNN */
typedef struct 
{
	unsigned int Plan:3;						/* bit 0  2: NNN (nombre de plan) */
	unsigned int _80Col:1;					/* bit 3: Flag 80 colonnes (8)     */
	unsigned int VGA:1;							/* bit 4: Flag VGA (V) */
	unsigned int Pal:1;							/* bit 5: Flag Pal (P) */
	unsigned int Overscan:1;				/* bit 6: Flag overscan (O) */
	unsigned int STComp:1;					/* bit 7: Flag ST compatible (S) */
	unsigned int Vertical:1;				/* bit 8: Flag Vertical (F) */
	unsigned int NRJStart:1;				/* bit 9: mode energy star actif ou non */
	unsigned int Eco:1;							/* bit 10: conomiseur actif ou non */
	unsigned int Virtual:1;					/* bit 11: cran virtuel actif ou non */
	unsigned int ExtClock:1;				/* bit 12: horloge externe 32/36MHz (CT2) */
	unsigned int ExtClockEnable:1;	/* bit 13: validation de l'horloge externe */
	unsigned int StandardResol:1;		/* bit 14: rsolution standard */
	unsigned int DefaultMode:1;			/* bit 15: mode vido par dfaut */
} VDO_MODE;

typedef struct
{
	int V_Hdl;				/* handle du mode vido 				*/
	VDO_MODE V_mode;	/* mode vido 									*/
	int V_physw;			/* largeur physique 						*/
	int V_physh;			/* hauteur physique 						*/
	int V_plan;				/* nombre de plan 							*/
	int V_logw;				/* largeur virtuelle 						*/
	int V_logh;				/* hauteur virtuelle 						*/
	int V_eco;				/* dlai de l'conomiseur 			*/
	int V_eco2;				/* dlai pour l'energy star 		*/
	char V_name[33];	/* nom du mode  32+1 nul 				*/
	char Reserved;		/* Rserv pour un usage futur 	*/
	long V_length;	 	/* taille du buffer 						*/
} VDO_PARAM;

void 	Vread(VDO_PARAM *);
int 	Vwrite(int InitVDI, VDO_PARAM *InParam, VDO_PARAM *OutParam);
void 	Vattrib (VDO_PARAM *InParam, VDO_PARAM *OutParam);
void 	Vcreate (VDO_PARAM *InParam, VDO_PARAM *OutParam);
int 	Vdelete(int Handle);
int 	Vfirst(VDO_PARAM *Mask, VDO_PARAM *Mode);
int 	Vnext(VDO_PARAM *Mask, VDO_PARAM *Mode);
int 	Vvalid(int Handle);
int 	Vload(void);
int 	Vsave(void);
int 	Vopen(void);
int 	Vclose(void);
int 	Vscroll(int ScrollMode);
long 	Voffset(void);
long 	Vseek(int Xpos, int Ypos);
int 	Vlock(int Cmd);
int 	SetMon(int MontType);
int 	MultiMon(int Cmd);
int 	SizeComp(int Cmd);
int 	VmodeValid(int Mode);

#endif