/*
 *	Conversion atari <-> unix
 */

#include <stdio.h>
#include <string.h>

int act = 0;

#define UNIX2ATARI 0x1
#define ATARI2UNIX 0x2
#define NOSPEC     0x4

char t_atari2unix[] = ""
	""
	"ܢfѪ*"
	"**ը*"
	"*******************"
	"***********^******"
	"****************"
	"**";

char t_unix2atari[] = "**"	/* 128 */
	"********************"	/* 130 */
	"************|ݹ"  /* 150 */
	"-,*"	/* 170 */
	"*AAEEEIIIID"	/* 190 */
	"OOO*UUUY*"	/* 210 */
	"뤕"	/* 230 */
	"y*";	


void atari2unix( char *in, char *out) {
  FILE *fi, *fo;
  char c;
  
  fi = (*in=='-')?stdin:fopen( in, "rb");
  fo = (*out=='-')?stdout:fopen( out, "wb");
  
  while( !feof( fi)) {
    c = fgetc( fi);
    if( c == '\r')
      continue;
    if( c != '\n') {
      if( !(act & NOSPEC) && (unsigned char)(c) > 127 && 
	  t_atari2unix[(unsigned char)c-128] != '*')
	c = t_atari2unix[(unsigned char)c-128];
    }
    fputc( c, fo);
  }
  
  if( *in != '-') fclose( fi);
  if( *out != '-') fclose( fo);
}

void unix2atari( char *in, char *out) {
  FILE *fi, *fo;
  char c;
  
  fi = (*in=='-')?stdin:fopen( in, "rb");
  fo = (*out=='-')?stdout:fopen( out, "wb");
  
  while( !feof( fi)) {
    c = fgetc( fi);
    if( c == '\n') {
      fputc( '\r', fo);
      /*	fputc( '\n', fo); */
    } else {
      if( !(act & NOSPEC) && (unsigned char)(c) > 127 && 
	  t_unix2atari[(unsigned char)c-128] != '*')
	c = t_unix2atari[(unsigned char)c-128];
    }
    fputc( c, fo);
  }
  
  if( *in != '-') fclose( fi);
  if( *out != '-') fclose( fo);
}

int main( int argc, char *argv[]) {
  int i=1;
  char in[255]="", out[255]="";
  
  if( argc < 4) {
    fprintf( stderr, 
	     "Export: an utility to convert atari file into unix file and inversly.\n"
	     "        by Dominique B\\'er\\'eziat, all right reserved 1998.\n"
	     "Usage is: export [option] in out\n"
	     "          option are:\n"
	     "          -unix:  convert from atari to unix format\n"
	     "          -atari: convert from unix to atari format\n"
	     "          -nospec: don't convert special characters\n"
	     "          in, out: name of inpout, output file or '-' for stdin , stdout\n");
  } else {
    while( i < argc) {
      if( !strcmp( argv[i], "-unix"))
	act |= ATARI2UNIX;
      else if( !strcmp( argv[i], "-atari"))
	act |= UNIX2ATARI;
      else if( !strcmp( argv[i], "-nospec"))
	act |= NOSPEC;
      else if( *in )
	strcpy( out, argv[i]);
      else 
	strcpy( in , argv[i]);
      i ++;
    }
    if( *in == '\0' || *out == '\0') 
      fprintf( stderr, "Need input and output file name.\n");
    else if( act & ATARI2UNIX)
      atari2unix(in,out);
    else if( act & UNIX2ATARI)
      unix2atari(in,out);
    else
      fprintf( stderr, "Nothing to do!");
  }
  return 0;
}
