/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

/*
	Kernal Message Handler
*/

#ifndef _KERNAL_H_
#define _KERNAL_H_
#include <OSTRUCT.H>
#include "K_DEFS.H"
#include "XA_DEFS.H"
#include "XA_TYPES.H"

void kernal(void);
void setup_k_function_table(void);
void set_active_function(GeneralCallback f, long p0, long p1, short t);
void clear_active_function(void);

typedef unsigned long (*AESroutine)(short clnt_pid,AESPB*);		/* All AES command handers are of this type */

typedef struct {		/* Kernal command packet structure */
	short pid;			/* client pid */
	unsigned short cmd;	/* command code */
	AESPB *pb;			/* pointer to AES parameter block */
} K_CMD_PACKET;

typedef struct {
	short mx;
	short my;
	short state;
	short clicks;
} MOUSE_DATA;

/* Mouse device commands */

#define	MOOSE_INIT_PREFIX		0x4d49		/* 'MI' */
#define	MOOSE_DCLICK_PREFIX		0x4d44		/* 'MD' */
#define MOOSE_BUTTON_PREFIX		0x5842		/* 'XB' */

typedef struct moose_init_com {
	unsigned short	init_prefix;
	void *ikbd_table;
} MOOSE_INIT_COM;

typedef struct moose_dclick_com {
	unsigned short dclick_prefix;
	unsigned short dclick_time;
} MOOSE_DCLICK_COM;

typedef struct moose_button_data {
	unsigned short x;
	unsigned short y;
	unsigned short state;
	unsigned short clicks;
} MOOSE_BUTTON_DATA;


#endif
