/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

/*
	Draw a boxtext object
*/

void d_g_fboxtext(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	GRECT gr;
	short parent_x=odc_p->parent_x, parent_y=odc_p->parent_y;
	OBJC_COLORWORD *colourword;
	TEDINFO *textblk;
	unsigned short zap;
	short coords[4],selected=ob->ob_state&SELECTED;
	short border_thick=0,curs_x;
	char temp_text[200];

	textblk=(TEDINFO*)ob->ob_spec;
	colourword=(OBJC_COLORWORD*)&zap;
	gr=set_text(ob, colourword, &border_thick, parent_x, parent_y);

	shadow_object(ob, parent_x, parent_y, colourword, border_thick);
	set_colours(ob, colourword);

	switch(textblk->te_just)
	{
		case 0:
			gr.g_x=parent_x+ob->ob_x;
			break;
		case 1:
			gr.g_x=parent_x+ob->ob_x+ob->ob_width;
			break;
		case 2:
			gr.g_x=parent_x+ob->ob_x+(ob->ob_width/2);
			break;
	}
	
	curs_x=format_dialog_text(temp_text, textblk->te_ptmplt, textblk->te_ptext, textblk->te_tmplen);

	
	if (ob->ob_flags&FLD3DANY)
	{
		XA_3D_pushbutton(parent_x+ob->ob_x-1, parent_y+ob->ob_y-1, ob->ob_width+1, ob->ob_height+1, selected);
		if (selected)
		{
			gr.g_x+=PUSH3D_DISTANCE; gr.g_y+=PUSH3D_DISTANCE;
		}
		vswr_mode(V_handle, colourword->opaque ? MD_REPLACE:MD_TRANS);
		v_gtext(V_handle,gr.g_x,gr.g_y,temp_text);
	}else{
/*		if (colourword->opaque)*/
		{
			coords[0]=parent_x+ob->ob_x;
			coords[1]=parent_y+ob->ob_y;
			coords[2]=coords[0]+ob->ob_width-1;
			coords[3]=coords[1]+ob->ob_height-1;
			v_bar(V_handle, coords);
		}
				
		vswr_mode(V_handle, colourword->opaque ? MD_REPLACE:MD_TRANS);
		v_gtext(V_handle,gr.g_x,gr.g_y,temp_text);

		if (selected)
		{
			coords[0]=parent_x+ob->ob_x;
			coords[1]=parent_y+ob->ob_y;
			coords[2]=coords[0]+ob->ob_width-1;
			coords[3]=coords[1]+ob->ob_height-1;
			vswr_mode(V_handle,MD_XOR);
			vsf_color(V_handle,BLACK);
			vsf_interior(V_handle,FIS_SOLID);
			v_bar(V_handle, coords);
		}

		if (border_thick)	/* Display a border? */
		{
			vswr_mode(V_handle, MD_REPLACE);
			draw_2d_box(parent_x+ob->ob_x, parent_y+ob->ob_y, 
						ob->ob_width, ob->ob_height, 
						border_thick, colourword->borderc);
		}
	}
	
	if (ob->ob_state&IS_EDIT)
	{
		coords[0]=parent_x+ob->ob_x+curs_x*gr.g_w;
		coords[1]=parent_y+ob->ob_y;
		coords[2]=coords[0]+gr.g_w-1;
		coords[3]=coords[1]+gr.g_h-1;
		vswr_mode(V_handle,MD_XOR);
		vsf_color(V_handle,BLACK);
		vsf_interior(V_handle,FIS_SOLID);
		v_bar(V_handle, coords);
	}

}