/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

void d_g_title(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	unsigned short zap;
	short ty,temp,coords[4];
	OBJC_COLORWORD *colourword;

	zap=0x0100;
	colourword=(OBJC_COLORWORD*)&zap;
	ty=odc_p->parent_y + ob->ob_y + ((ob->ob_height-display.c_max_h)/2);

	vst_font(V_handle,display.standard_font_id);
	vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);
	vswr_mode(V_handle, MD_TRANS);
	vst_alignment(V_handle,0,5,&temp,&temp);
	vst_color(V_handle, colourword->textc);
	v_gtext(V_handle,odc_p->parent_x+ob->ob_x,ty,(char*)ob->ob_spec);

	if (ob->ob_state&SELECTED)
	{
		coords[0]=odc_p->parent_x+ob->ob_x;
		coords[1]=ty;
		coords[2]=coords[0]+ob->ob_width-1;
		coords[3]=coords[1]+ob->ob_height-1;
		vswr_mode(V_handle,MD_XOR);
		vsf_color(V_handle,BLACK);
		vsf_interior(V_handle,FIS_SOLID);
		v_bar(V_handle, coords);
	}

}
