#include <lynx.h>
#include <lynxlib.h>
#include <stdlib.h>

// Bug in cc65? Needs real code before C++ comments occur?



// SPRDEMO1
// 1. April 2000
// Shows the usage of SPRPCK to create 8 tiles (2 rows with 4 columns)
// All tiles share the same colour palette indexes
//
// ----------------------------------------------------------------------
//
// Create the 8 tiles by calling SPRPCK with these parameters:
// sprpck -t6 -S040051 -r004002 -p0 yx.bmp
//
// -t6      --> source is a MS Windows BMP-file
// -Swwwhhh --> capital S, set the width and height of the created sprite(s)
// -rxxxyyy --> split source image into yyy*xxx tiles (of -Swwwhhh size)
// -p0      --> creates OBJ-files from the SPR-files
// yx.bmp   --> the source file is a BMP with 160*102 pixels (w*h)
//
// The created sprites will have a 4bit colour depth


// Access to the created 8 sprites:

// The 4 sprites of the first row
extern char yx000000[];
extern char yx000001[];
extern char yx000002[];
extern char yx000003[];

// The 4 sprites of the second row
extern char yx001000[];
extern char yx001001[];
extern char yx001002[];
extern char yx001003[];

char *sprtab[2][4] = {{yx000000, yx000001, yx000002, yx000003},
                      {yx001000, yx001001, yx001002, yx001003}};

extern char SCB1[];
#asm         
_SCB1     dc.b $c0,$10,$20
          dc.w 0,0
          dc.w 0,0,$100,$100
          ; Because we didn't use -C when calling SPRPCK we can
          ; use the same colour palette indexes for all tiles
          dc.b $01,$23,$45,$67,$89,$Ab,$cd,$ef
#endasm


// The colour palette
#include "yx.pal"


/*********************/
/* wait for a button */
/*********************/
uchar WaitButton()
{
   uchar key;
   while ( !(key = joystick))
      ;
   /* wait for the button to be released */
   while ( joystick )
      ;
   return key;
}


/*********************/
/* main              */
/*********************/
main()
{
register uchar x,y;

  CLI;
  SetBuffers(0x9000,0,0);

  _SetRGB(pal);                         // Set the colour palette

  for (;;)
     {
     DrawFBox(0, 0, 160, 102, 15);      // Colour 15 is white

     for (y=0; y<2; ++y)                // 2 rows
        {
        for (x=0; x<4; ++x)             // 4 columns
           {
           SCBX(SCB1) = 40*x;
           SCBY(SCB1) = 51*y;
           SCBDATA(SCB1) = sprtab[y][x];
           DrawSprite(SCB1);
           WaitButton();
           }
        }
     } // forever
}
