// DO   = Matthias Domin (Matthias.Domin@t-online.de)
// 42BS = 42Bastian Schick (b.schick@enea.de)


// June 5, 1999: DO ported from 68k-assembler

// #define DEBUG

#define VER "5.0"

#define MAXFILE 256

#define CARDHEADLEN 0x0408
#define MAXCARDMEM (256*BLOCKSIZE)-CARDHEADLEN
#define CARDSIZE 10
#define BLOCKSIZE (1<<CARDSIZE)
#define HEADERLEN 10

#include "lynxer.h"

//unsigned char CardHead[CARDHEADLEN];		// 1032
#include "loader26.h"
#include <ctype.h>

char AccessPath[256];
char MAKPath[256];
char LYXPath[256];

char Drive[256];		// drive letter followed by a colon (:)
char Path[256];		// directory path including trailing slash
char FileName[256];	// Base filename ( no extension)
char Extension[256];	// filename extension including leading period (.)

char OldDrive[256];	// drive letter followed by a colon (:)
char OldPath[256];
char OldExtension[256];// filename extension including leading period (.)


char PathArray[MAXFILE][256];

long FileLengths[MAXFILE];

unsigned char *pCardMem;
long nCardLen;
long nCardOffset;

unsigned char MAKbuffer[1024];
unsigned char crctab[256];
unsigned char BuildLYX[256*BLOCKSIZE];

/*************************************************************
*** splitpath											   ***
*************************************************************/
void splitpath (char* path, char* drv, char* dir, char* name, char* ext) {
	char* end; /* end of processed string */
	char* p;   /* search pointer */
	char* s;   /* copy pointer */

	/* extract drive name */
	if (path[0] && path[1]==':') {
		if (drv) {
			*drv++ = *path++;
			*drv++ = *path++;
			*drv = '\0';
			}
        }
	else if (drv) *drv = '\0';

	/* search for end of string or stream separator */
	for(end=path; *end && *end!=':'; ) end++;

	/* search for begin of file extension */
	for(p=end; p>path && *--p!='\\' && *p!='/'; )
		if (*p == '.') {
			end = p;
			break;
			}

	if (ext)
		for(s=end; (*ext=*s++); )
			ext++;

	/* search for end of directory name */
	for(p=end; p>path; )
		if (*--p=='\\' || *p=='/') { p++; break; }

	if (name) {
		for(s=p; s<end; ) *name++ = *s++;
		*name = '\0';
        }

	if (dir) {
		for(s=path; s<p; ) *dir++ = *s++;
		*dir = '\0';
        }
	}

/*************************************************************
*** makepath											   ***
*************************************************************/
void makepath(char *path,char *drive,char *dir,char *fname,char *ext) {
	int dir_len;

	if ((drive != NULL) && (*drive)) {
		strcpy(path, drive);
		}
	else (*path)=0;

	if (dir != NULL) {
		strcat(path, dir);
		dir_len = strlen(dir);
		if (dir_len && *(dir + dir_len - 1) != '\\') strcat(path, "\\");
		}

	if (fname != NULL) {
		strcat(path, fname);
		if (ext != NULL) { if (*ext != '.') { strcat(path, "."); } strcat(path, ext); }
		}

	}



/*************************************************************
*** error                                                  ***
*************************************************************/
void error(int line,char *f,...)
{
  va_list argp;
  
  va_start(argp,f);
  printf("Error (%d):",line);
  printf(f,va_arg(argp,char *) );
  va_end(argp);

  exit(-1);
}

/*************************************************************
*** InitBuffer                                             ***
*************************************************************/
void InitBuffer()
{
	int i;
	for (i=0; i<256*1024; i++)
		BuildLYX[i] = -1;
}

/*************************************************************
*** Check                                                  ***
*** Builds a checksum and puts it at the end of the image  ***
*************************************************************/
void Check()
{
	int i, len;
	unsigned char *cp;
	unsigned char ch, d1, d2, d2old;


// check1:    Initializing crctab
	ch = 0;
	do
	{
// check2:
		d2 = ch;
		for (len = 7; len >= 0; len--)
		{
			d2old = d2;
			d2 <<= 1;
			if (d2old & 0x80)
				d2 ^= 0x95;
		}
		crctab[ch] = d2;
	}
	while(--ch);



// loopCheck:
	cp = BuildLYX;
	len  = nCardLen;
	d1 = 0;
	while (len > 0)
	{
		ch = *cp++;
		ch = crctab[ch];
		d1 ^= ch;
		len--;
	}

// loopCheck1:
	for (i=255; i>=0; i--)
	{
		ch = crctab[i];
		ch ^= d1;
		if (ch == '\0')
			break;
	}
// ok_check:
	*cp = i;
}


/*************************************************************
*** ToUpper                                                ***
*** converts a string to upper chars                       ***
*** string ends at 0, CR, ';' or '*'                       ***
*************************************************************/
int ToUpper(char **pSource, char *pDest) {

	int nCount;
	char *pSrc = *pSource;
	char ch;


	if (*pSrc == '\0')	// Something there?
		goto EOF_TU;	// no!

	nCount = 0;

ToUpper2:
	if ((ch = *pSrc++) == '\0')
		goto EOL_TU0;

	if (ch == ' ')
		goto ToUpper2;

	if (ch == '\t')
		goto ToUpper2;

	if (ch == '\r')
		goto EOL_TU1;

	// comment
	if (ch == '*' || ch == ';')
	{
comment:
		if ((ch = *pSrc++) == '\0')
			goto EOL_TU0;
		if (ch == '\r')
			goto EOL_TU1;
		goto comment;
	}

// no_comment:
	*pDest++ = toupper(ch);
	nCount++;
	goto ToUpper2;			// loop



EOL_TU0:
	--pSrc;
	*pSource = pSrc;
	*pDest = 0;
	return nCount;

EOL_TU1:
	++pSrc;
	*pSource = pSrc;
	*pDest = 0;
	return nCount;

EOF_TU:
	return -1;
}

/*************************************************************
*** LoadFile                                               ***
*************************************************************/
long LoadFile(char *fn, unsigned char* ptr) {

	long len;
	FILE *f;
	
	 f = fopen(fn, "rb");

	if (f != NULL) {
		fseek(f, 0, SEEK_END);
		len = ftell(f);
		fseek(f, 0, SEEK_SET);

#ifdef DEBUG
		printf("filesize: %lu\r\n", len);
#endif
		len  = fread(ptr, 1, len, f);
#ifdef DEBUG
		printf("bytes read: %lu\r\n", len);
#endif
		fclose(f);

		return (len);
		}
	
	return 0;
	}


/*************************************************************
*** SaveFile                                               ***
*************************************************************/
void SaveFile(char *filename, unsigned char *ptr, long size) {

	FILE *f;
	
	f = fopen(filename, "wb");
   
	if (f == NULL) { error(__LINE__,"Couldn't open %s for writing !\r\n",filename); }
	
	if ( fwrite(ptr, 1, size, f) != size ) {
		printf("Error: Couldn't write %s !\r\n",filename);
		}
		
	fclose(f);
	}

/*************************************************************
*** SaveLoader                                             ***
*** Helper function: Transforms a binary into a *.H-file   ***
*************************************************************/
void SaveLoader(char *filename,unsigned char *ptr, long size) {

	char buffer[256];
	int i;
	FILE *f;

	f = fopen(filename, "wt");
	   
	if (f == NULL) { error(__LINE__,"Couldn't open %s for writing !\r\n",filename); }

	sprintf(buffer, "/****************************************\r\n");
	fwrite(buffer, 1, strlen(buffer), f);
	sprintf(buffer, "*** LOADER26.H                       ***\r\n");
	fwrite(buffer, 1, strlen(buffer), f);
	sprintf(buffer, "***************************************/\r\n\r\n");
	fwrite(buffer, 1, strlen(buffer), f);

	sprintf(buffer, "unsigned char CardHead[1032] = {\r\n");
	fwrite(buffer, 1, strlen(buffer), f);
	while (size > 8) {
		sprintf(buffer, "\t0x%x, 0x%x, 0x%x, 0x%x,  0x%x, 0x%x, 0x%x, 0x%x,\r\n",
			*(ptr+0), *(ptr+1), *(ptr+2), *(ptr+3), *(ptr+4), *(ptr+5), *(ptr+6), *(ptr+7));

		fwrite(buffer, 1, strlen(buffer), f);
		ptr += 8;
		size -= 8;
		}

	buffer[0] = '\0';
	sprintf(buffer, "\t");
	fwrite(buffer, 1, strlen(buffer), f);

	for (i=0; i < size-1; i++) {
		sprintf(buffer, "0x%x, ", *ptr++);
		fwrite(buffer, 1, strlen(buffer), f);
		}
	
	sprintf(buffer, "0x%x\r\n", *ptr);
	fwrite(buffer, 1, strlen(buffer), f);

	sprintf(buffer, "\t};\r\n");
	fwrite(buffer, 1, strlen(buffer), f);

	fclose(f);
	}

/*************************************************************
*** Fsfirst                                                ***
*** Returns the filelength                                 ***
*************************************************************/
long Fsfirst(char *fn) {

	long len;
	FILE *f;
	
	f = fopen(fn, "rb");

	if (f != NULL) {
		fseek(f, 0, SEEK_END);
		len = ftell(f);
		fseek(f, 0, SEEK_SET);

		fclose(f);

		return (len);
		}
	
	return 0;
	}


/*************************************************************
*** Main                                                   ***
*************************************************************/
int main(int argc, char *argv[]) {

	int i;
	long nLen;
	unsigned char *cp;
	unsigned char *fp;
	unsigned char *pMB;
	unsigned char fflag;

	int nErr;
	int nFileCount;
	long nSum;

	int nBlockNo, nBlockOffset, nTmpBlockOffset, nStart;
	int nTmpFileLength, nTmpFileLength2;

	printf("------------------------------\r\n"
         "Lynxer Version "VER"\r\n"
         "(c) 1996-1999 42Bastian Schick \r\n"
         "              Matthias  Domin  \r\n"
         "------------------------------\r\n");

	if (argc == 1 )
	{
		printf(argv[0]);
		printf("\r\n");
		printf("Usage :\r\n"
		"lynxer homebrew.o\r\n"
		"or\r"
		"lynxer batchfile\r\n" );
		exit(0);
	}

	--argc;

/*
    The next lines were used to transform a binary file
	into a *.H-file!

	printf("Loading Card header file LOADER26.O\r\n");
	if (LoadFile("LOADER26.O", CardHead) <= 0)
	{
		printf("LOADER26.O not found!");
		exit(EXIT_FAILURE);
	}
	SaveLoader("loader26.h", CardHead, CARDHEADLEN);
	exit(0);
*/
	InitBuffer();

	// The path from which LYNXER is called
	splitpath(argv[0], OldDrive, OldPath, FileName, Extension);
#ifdef DEBUG
	printf("****pathfile of program: %s\r\n", argv[0]);
	printf(OldDrive);
	printf("\r\n");
	printf(OldPath);
	printf("\r\n");
	printf(FileName);
	printf("\r\n");
	printf(Extension);
	printf("\r\n");
	printf("****parameters: %s\r\n", argv[1]);
#endif

	// Path of the first commandline argument (Make-file or *.O-file)
	splitpath(argv[1], Drive, Path, FileName, Extension);
	// Path of the result of LYNXERs work
	makepath(LYXPath, Drive, Path, FileName, ".LYX");

	if (strlen(Extension) == 0 ||
		!stricmp(Extension, ".OBJ") ||
		!stricmp(Extension, ".LYX") ||		// ?????
		!stricmp(Extension, ".O"))
	{
		strcpy(OldExtension, Extension);
		strcpy(Extension, ".MAK");
	}

	if (strlen(FileName) == 0)
		strcpy(FileName, "MAKE_ROM");

	if (strlen(Path) == 0)
		strcpy(Path, OldPath);

	if (strlen(Drive) == 0)
		strcpy(Drive, OldDrive);

#ifdef DEBUG
	printf("****pathfile of parameter:\r\n");
	printf(Drive);
	printf("\r\n");
	printf(Path);
	printf("\r\n");
	printf(FileName);
	printf("\r\n");
	printf(Extension);
	printf("\r\n");
#endif

	makepath(MAKPath, Drive, Path, FileName, Extension);
#ifdef DEBUG
	printf("****pathfile of make file:\r\n");
	printf(MAKPath);
	printf("\r\n");
#endif


	// Nun lesen wir entweder eine MAK-Datei nach MAKbuffer ein,
	if (LoadFile(MAKPath, MAKbuffer) < 1) {	//  oder erzeugen uns dort selbst eine
#ifdef DEBUG
		printf("Generating internal MAK-file:\r\n");
#endif	
		// Zunchst "INSERT.O" als Titlesprite
		makepath(MAKbuffer,  OldDrive, OldPath, "INSERT", ".O");
		cp = MAKbuffer + strlen(MAKbuffer);
		*cp++ = '\r';	// Carriage return und
		*cp++ = '\n';	// Linefeed anhngen
		makepath(cp, Drive, Path, FileName, OldExtension);
		}
		
#ifdef DEBUG
	printf(MAKbuffer);
	printf("\r\n");

	printf("Parsen der MAK-Datei ergibt:\r\n");
#endif	

// Parsen der MAKbuffer-Liste und bertragen in das PathArray
	nFileCount = 0;
	pMB = MAKbuffer;
	while ((nLen = (long)ToUpper(&pMB, AccessPath)) > 0) {
		
		if (nLen > 0) {
			strcpy(PathArray[nFileCount++], AccessPath);
			printf("%s in make file\r\n", AccessPath);
			}

		if (nFileCount == MAXFILE) { break; }
		}


// Makedatei wurde in interne Dateiliste berfhrt
	nErr = 0;
	for (i = 0; i < nFileCount; i++) {
		
		splitpath(PathArray[i], Drive, Path, FileName, Extension);
		
		if (!stricmp(FileName, "#ALIGN")) { // Align-Anweisung
			
			FileLengths[i] = 0;
			}
		else {	// Dateiangabe
			
			if (!strlen(Extension)) { strcpy(Extension, ".O"); }
			
			makepath(PathArray[i], Drive, Path, FileName, Extension);
			
			if ((nLen = Fsfirst(PathArray[i])) < 1) {
				nErr = -1;
				printf("File not found: %s\r\n", PathArray[i]);
				}

			FileLengths[i] = ((nLen + 1) & 0xfffffffe);
#ifdef DEBUG
			printf("%ld ==> %ld\r\n", nLen, FileLengths[i]);
#endif	
			}
		}

	if (nErr == -1) { error(__LINE__, "Unable to load all files!"); }

	nSum = 0;
	for (i = 0; i < nFileCount; i++) { nSum += FileLengths[i]; }

#ifdef DEBUG
	printf("==> Image size: %ld\r\n", nSum);
#endif	

	if (nSum > MAXCARDMEM) { error(__LINE__, "IMAGE size exceeds ROM size!"); }
	
// Jetzt geht's los:
// Zunchst den Header
	nCardLen = nSum;
	cp = BuildLYX;
	pCardMem = BuildLYX + 0x0380;

	for (i=0; i< CARDHEADLEN; i++) // 0x0408
		*cp++ = CardHead[i];

	nCardOffset = (nFileCount + 1) * 8 + 0x0380;
	if (nCardOffset < CARDHEADLEN)	// ??????????????????????
		nCardOffset = CARDHEADLEN;

	nCardLen += nCardOffset;

	cp = BuildLYX + nCardOffset;  // cp = a5 --> Ab hier wird abgelegt

	nBlockOffset = nCardOffset % BLOCKSIZE;
	nBlockNo = nCardOffset / BLOCKSIZE;

#ifdef DEBUG
	printf("nCardLen: %ld = %ld\r\n", nCardLen, nCardLen);
	printf("nCardOffset: %ld = %ld\r\n", nCardOffset, nCardOffset);
	printf("Block %xh, Offset %xh\r\n", nBlockNo, nBlockOffset);
	printf("*********************************************\r\n");
#endif	


// loop7
	for (i=0; i < nFileCount; i++)
	{
#ifdef DEBUG
			printf("%d. entry in list ----------------------------\r\n", i+1);
#endif	

		if (FileLengths[i] == 0)	// Dann Block-Align durchfhren
		{
			if (nBlockOffset != 0)
			{
				nBlockNo += 1;
				cp += ((1<<CARDSIZE) - nBlockOffset);
				nCardLen += ((1<<CARDSIZE) - nBlockOffset);
				nBlockOffset = 0;
			}
#ifdef DEBUG
			printf("#ALIGN:\r\n");
			printf("Next one will be at: Block %x, Offset %x\r\n", nBlockNo, nBlockOffset);
#endif	
		}
		else	// sonst war es eine Datei
		{
			fp = cp;
			LoadFile(PathArray[i], fp);
			nTmpFileLength = FileLengths[i];
			nTmpFileLength2 = FileLengths[i];
			cp += nTmpFileLength;
			*(pCardMem + 0) = nBlockNo;
			*(pCardMem + 1) = ((nBlockOffset ^ 0xffff) & 0xff);
			*(pCardMem + 2) = ((nBlockOffset ^ 0xffff) >> 8);
			nStart = 0;
			fflag = *fp | *(fp+1);
			if ((fflag == 0x88) ||	// Normales Programm
				(fflag == 0x89))	// Gepacktes Programm
			{
				// Korrigierten Offset
				nTmpBlockOffset = nBlockOffset + HEADERLEN;  // und die BlockNo ???
				*(pCardMem + 1) = ((nTmpBlockOffset ^ 0xffff) & 0xff);
				*(pCardMem + 2) = ((nTmpBlockOffset ^ 0xffff) >> 8);
				*(pCardMem + 3) = fflag;
				nStart = (*(fp+2))*256 + *(fp+3);
				nTmpFileLength -= HEADERLEN;

				if (fflag == 0x89)	// Gepacktes Prg.
				{
					nTmpFileLength = (*(fp+4))*256 + *(fp+5);
				}

			}
// noPrg
			*(pCardMem + 4) = nStart & 0xff;	// Steht "falsch" rum drin
			*(pCardMem + 5) = nStart >> 8;
			*(pCardMem + 6) = ((nTmpFileLength ^ 0xffff) & 0xff);
			*(pCardMem + 7) = ((nTmpFileLength ^ 0xffff) >> 8);

			nBlockNo += nTmpFileLength2 / BLOCKSIZE;
			nBlockOffset += nTmpFileLength2 % BLOCKSIZE;
			while(nBlockOffset >= BLOCKSIZE)
			{
				nBlockNo += 1;
				nBlockOffset -= BLOCKSIZE;
			}
			pCardMem += 8;
#ifdef DEBUG
			printf("File handled:\r\n");
			printf("Next one will be at:  %x, Offset %x\r\n", nBlockNo, nBlockOffset);
#endif	
		}

	} // for 

	Check();	// 
	BuildLYX[0x303] = 0x80; // Patch: BRA instead of BEQ --> No checksum required
	SaveFile(LYXPath, BuildLYX, nCardLen);

  return 0;
}

