SET TALK OFF
* 3-10-87 NEW VERSION NAME 1.00B
* 3-10-87 CHANGE DOS TO TOS
* 3-10-87 REMOVE TRAP FILE FROM PROCEDURE  FILENAME ASSIST1.CMD
* 10-30-86
SET TALK OFF
SET ESCAPE OFF
*SET ESCAPE ON
SET CONFIRM ON
ERASE
X.FILE_PATH = '\*.DBF                 '
STORE 'SET SAY VIDEO TO 7' TO SAYNORMAL
STORE 'SET SAY VIDEO TO 112' TO SAYREVERSE
STORE 'SET SAY VIDEO TO 7' TO SAYBRIGHT
STORE 'SET SAY VIDEO TO 7' TO SAYBLINK
STORE '00,00,24,79' TO FULL
X.PMENU_HELP = ''
&SAYNORMAL
******************************************************************************
* SCREEN LAYOUT
* 20 CMD:
* 23 STATUS (FILE IN USE, RECORD # ...)
* 24 ERROR MSG, V/HMENU KEYS
******************************************************************************
@ 08,00
TEXT
                             dBMAN ASSIST Ver 1.00 B
                   Copyright (c) 1986 VersaSoft Corporation.

                                      for

                              Atari ST Computers


                             VersaSoft Corporation
                          San Jose,  California, USA.
                                 (408)723-9044
ENDTEXT
ASSIGN DRAWLINE(05,10,05,70,0,0,0)
ASSIGN DRAWLINE(05,70,20,70,0,0,0)
ASSIGN DRAWLINE(20,70,20,10,0,0,0)
ASSIGN DRAWLINE(20,10,05,10,0,0,0)
@ 24,00 ESAY CENTER ('LOADING ASSIST PLEASE WAIT.....',79)
&SAYNORMAL
SET PROCEDURE TO ASSIST
DO A
SET PROCEDURE TO
SET SAY VIDEO TO 7
SET ESCAPE ON
ASSIGN TRAP(F),TRAPFILE('')
RETURN


***********
PROCEDURE SELFIELD
* SELECT ONE FIELD NAME
***********
DO WHILE T | GET ITEMS
  &SAYREVERSE
  @ 24,00 ESAY CENTER('Select "Cancel" to return to Main Menu.',79)
  @ 06,00 ESAY CENTER("Please select field.  Field Types: C=Character  N=Number  D=Date  L=Logical",80)
  &SAYNORMAL
  Y.CANCEL_TXT = '"Cancel"'
  Y.CANCEL_NO = TOKENS('|',X.MENU_TXT) + 2
  ASSIGN MMENU(7,1,1,15,5,'|',X.MENU_TXT,Y.CANCEL_TXT)
  IF HMENU() = Y.CANCEL_NO | PRESSED ESC
    RETURN TO A
  ENDIF
  IF HMENU() > 40 | HELP
    DO HELP
    LOOP
  ENDIF
  EXIT
ENDDO
RETURN	| ************** END OF SELFIELD ***********


*********
PROCEDURE GETVMENU
* Z.MSG1_TEXT
* Z.VMENU_TEXT = MENU ITEMS
* Z_VMENU_COL = THE COL ADR WITHIN THE BOX
*********
DO WHILE T
  &SAYREVERSE
  @ 24,00 ESAY CENTER('Select "Cancel" to return to Main Menu.',79)
  &SAYNORMAL
  ASSIGN BOX(8,20,20,60,201,187,200,188,186,205)
  @ 9,21 SAY CENTER(Z.MSG1_TEXT,39)
  Y.CANCEL_TXT = '"Cancel"'
  Y.CANCEL_NO = TOKENS('|',Z.VMENU_TEXT) + 2
  ASSIGN MMENU(11,(20+Z.VMENU_COL-1),1,(40-Z.VMENU_COL-Z.VMENU_COL),;
1,'|',Z.VMENU_TEXT,Y.CANCEL_TXT)
  DO CASE
    CASE VMENU() = Y.CANCEL_NO
      RETURN TO A
    CASE VMENU() > 40
      DO HELP
      LOOP
    OTHERWISE
      EXIT
  ENDCASE
ENDDO
RETURN	| ************* END OF GETVMENU ************


*********
PROCEDURE GETFNAME
*********
* THIS PROCEDURE GETS THE FILE NAME IN X.FILE_NAME
* INPUT X.MSG_TXT MSG IS DISPLAYED ON LINE 1 OF THE BOX
* X.FILE_EXT IS THE FILE EXTENSION
* THE PROG RETURNS TO THE MAIN MENU (A) WHEN CANCEL IS SELECTED
* THE ROUTINE MAKES SURE THAT A FILE NAME IS ENTERED.
* CHECKS IF THE FILE EXISTS AND SETS X.FILE_OK

@ 2,0 ESAY CENTER(X.MSG_TXT,79)
Y.VAR = SRCH('.',X.FILE_PATH)
IF Y.VAR = 0
  X.FILE_PATH = MIDSTR(X.FILE_PATH - X.FILE_EXT,SPACE(14),1)
ELSE
  X.FILE_PATH = MIDSTR(X.FILE_EXT,X.FILE_PATH,Y.VAR)
ENDIF 
X.FILE_NAME = SPACE(14)
ASSIGN SELFILE(X.FILE_PATH,X.FILE_NAME)
IF LEN(TRIM(X.FILE_NAME)) = 0
  RETURN TO A	| CANCEL
ENDIF
IF SRCH('.',X.FILE_NAME) = 0
  X.FILE_NAME = TRIM(X.FILE_NAME) + X.FILE_EXT
ENDIF
X.FILE_NAME = EXTRACT('*',X.FILE_PATH,1) - X.FILE_NAME
DO FINDFILE
RETURN	| **************** END OF GETFNAME **************


*************************** END OF ATARI ST SPECIFIC **********************


***********
PROCEDURE A
***********
* ASSIST.PRG VERSION 1.0
* BY MIKE DAUSEND
*
ASSIGN TRAP(T),TRAPFILE('ASSIST1')
*ASSIGN TRAP(F),TRAPFILE('')
*
STORE SPACE(14) TO X.FILE_NAME,X.DBF_NAME,X.NDX_NAME,X.RPT_NAME | DOS FILE NAMES
*
X.MAIN_TITLE = " FILES  | CREATE  | MODIFY  | DATA  | LOCATE  | SORT  | REPORT |  QUIT  "
X.TITLE_FILE = "DISPLAY FILE(S)|OPEN A DATABASE|OPEN AN INDEX|CLOSE THE DATABASE|CLOSE ALL INDEXES|RENAME A FILE|DELETE A FILE|COPY A FILE"
X.TITLE_CREA = "CREATE A DATABASE|CREATE AN INDEX|CREATE A REPORT|CONVERT A dBASE"+CHR(248)+" FILE"
X.TITLE_MOD  = "DATABASE STRUCTURE|DATABASE FIELD NAMES|REPORT FORMAT|EDIT RECORD"
X.TITLE_DATA = "DISPLAY RECORDS|APPEND (ADD RECORDS)|APPEND FROM A FILE|EDIT RECORD|REPLACE IN SEVERAL RECORDS|DELETE RECORD(S)|UN-DELETE RECORD(S)|REMOVE DELETED RECORD(S)|REMOVE ALL THE RECORDS|COPY RECORDS TO A FILE"
X.TITLE_LOC  = "GO TO A RECORD|FIND (NEEDS AN INDEX)|LOCATE|CONTINUE LOCATING"
X.TITLE_SORT = "SORT A DATABASE|CREATE AN INDEX|RE-INDEX"
X.TITLE_REP  = "CREATE REPORT|MODIFY REPORT|PRINT REPORT|LIST RECORD(S)|SUM RECORD(S)"
X.TITLE_SET  = "SET DEFAULT DRIVE|TOP MARGIN|BOTTOM MARGIN|LEFT MARGIN|LINE COUNT|SHOW DELETED RECS|HIDE DELETED RECS"
X.TITLE_Q    = "TO dBMAN|TO TOS"
*
DO WHILE T
  ERASE
  X.CMD_LINE = ''
  DO SHOWCMD
  DO SHOWSTAT
  &SAYREVERSE
  @ 24,00 ESAY X.PMENU_HELP
  &SAYBRIGHT
  ASSIGN PMENU("|",X.MAIN_TITLE,X.TITLE_FILE,X.TITLE_CREA,X.TITLE_MOD,X.TITLE_DATA,X.TITLE_LOC,X.TITLE_SORT,X.TITLE_REP,X.TITLE_Q)
  DO CASE
    CASE PMENU() = 0 OR PMENU() = 8 | SHOULD BE 9
      Y.QUIT_TO = VMENU()
      Y.MSG1_TEXT = 'DO YOU REALLY WANT TO QUIT NOW?'
      @ 22,00 ESAY CENTER('TO RE-RUN ASSIST TYPE "DO ASSIST" FROM THE "CMD:" PROMPT',80)
      DO SHOWYESNO
      IF VMENU() = 0 OR VMENU() = 2
	LOOP
      ENDIF
      IF Y.QUIT_TO = 0 OR Y.QUIT_TO = 1
	ERASE
	RELEASE ALL
	RETURN	| RET TO DBMAN
      ENDIF
      CLEAR
      QUIT	| RET TO DOS
    CASE PMENU() = 1 | ****************** FILES *****************
      DO CASE
	CASE VMENU() = 1 | DISPLAY FILES
	  DO DSPFILE
	CASE VMENU() = 2 | OPEN DATABASE
	  DO OPNDATA
	CASE VMENU() = 3 | OPEN INDEX
	  DO OPNINDX
	CASE VMENU() = 4 | CLOSE DATABASE
	  CLOSE
	CASE VMENU() = 5 | CLOSE INDEXES
	  CLOSE INDEX
	CASE VMENU() = 6 | RENAME
	  DO RENFILE
	CASE VMENU() = 7 | DELETE FILE
	  DO DELFILE
	CASE VMENU() = 8 | COPY FILE
	  DO CPYFILE
	CASE VMENU() > 40 | HELP
      ENDCASE
      LOOP
    CASE PMENU() = 2 | ************* CREATE **************
      DO CASE
	CASE VMENU() = 1 | CREATE FILE
	  DO CRDATA
	CASE VMENU() = 2 | CREATE INDEX
	  DO CRINDEX
	CASE VMENU() = 3 | CREATE REPORT
	  DO CRREP
	CASE VMENU() = 4 | CONVERT dBASE FILE
	  DO CNVDBASE
	CASE VMENU() > 40 | HELP
	  DO HELP
      ENDCASE
      LOOP
    CASE PMENU() = 3 | *************** MODIFY *************
      DO CASE
	CASE VMENU() = 1	| MODIFY DATABASE STRUCTURE
	  DO MODSTRCT
	CASE VMENU() = 2	| MODIFY FIELD NAME
	  DO MODFLD
	CASE VMENU() = 3	| MODIFY REPORT
	  DO MODREP
	CASE VMENU() = 4	| EDIT RECORD
	  DO EDTREC
	CASE VMENU() > 40 | HELP
	  DO HELP
      ENDCASE
      LOOP
    CASE PMENU() = 4 | **************** DATA ****************
      DO CASE
	CASE VMENU() = 1	| DISPLAY RECORDS
	  DO DSPREC
	CASE VMENU() = 2	| ADD RECORDS
	  DO ADDREC
	CASE VMENU() = 3	| APPEND FROM A FILE
	  DO APPDFILE
	CASE VMENU() = 4	| EDIT RECORD
	  DO EDTREC
	CASE VMENU() = 5	| REPLACE RECORD
	  DO REPLREC
	CASE VMENU() = 6	| DELETE RECORD
	  DO DELREC
	CASE VMENU() = 7	| RECALL RECORD
	  DO RCLREC
	CASE VMENU() = 8	| PACK FILE
	  DO PACKFILE
	CASE VMENU() = 9	| ZAP FILE
	  DO ZAPFILE
	CASE VMENU() = 10	| COPY RECORD
	  DO CPYREC
      ENDCASE
      LOOP
    CASE PMENU() = 5 | *************** LOCATE **********
      DO CASE
	CASE VMENU() = 1 | GO TO A RECORD
	  DO GOREC
	CASE VMENU() = 2 | FIND A RECORD
	  DO FNDREC
	CASE VMENU() = 3 | LOCATE A RECORD
	  DO LOCREC
	CASE VMENU() = 4 | CONTINUE
	  DO CONREC
      ENDCASE
      LOOP
    CASE PMENU() = 6 | **************** SORT *******************
      DO CASE
	CASE VMENU() = 1 | SORT
	  DO SRTDATA
	CASE VMENU() = 2 | CREATE INDEX
	  DO CRINDEX
	CASE VMENU() = 3 | RE-INDEX
	  DO RNDXDATA
      ENDCASE
      LOOP
    CASE PMENU() = 7 | ****************** REPORT *****************
      DO CASE
	CASE VMENU() = 1 | CREATE REPORT
	  DO CRREP
	CASE VMENU() = 2 | MODIFY REPORT
	  DO MODREP
	CASE VMENU() = 3 | PRINT REPORT
	  DO PRNTREP
	CASE VMENU() = 4 | LIST RECORDS
	  DO LSTREC
	CASE VMENU() = 5 | SUM RECORDS
	  DO SUMREC
      ENDCASE
      LOOP
  ENDCASE
ENDDO
RETURN | ************* END OF PROCEDURE *********


******
* ASSIST1 USED TO BE HERE

******
PROCEDURE CRDATA
* CREATE DATABASE FILE
*****
X.MSG_TXT = 'CREATE A DATABASE FILE'
X.FILE_NAME = ''
X.FILE_EXT = '.DBF'
DO WHILE T
  X.CMD_LINE = 'CREATE '
  DO SHOWCMD
  DO GETFNAME
  IF NOT X.FILE_OK
    SET TALK ON
    CREATE &X.FILE_NAME
    SET TALK OFF
    EXIT
  ELSE
    Y.ERR_TEXT = 'File already exists. Try another name.'
    DO SHOWERR
    LOOP
  ENDIF
ENDDO
RETURN	| END OF CRDATA

***********
PROCEDURE CRINDEX
***********
DO CKINUSE
X.MSG_TXT = 'CREATE AN INDEX FILE'
X.FILE_NAME = ''
X.FILE_EXT = '.NDX'
DO WHILE T
  X.CMD_LINE = 'INDEX ON '
  DO SHOWCMD
  DO FLDMENU
  X.MENU_TXT = '"No more"|' + X.MENU_TXT
  DO WHILE T
    DO SELFIELD
    IF HMENU() > 1
      Y.FLD_CHOICE = HMENU() - 1
      X.FIELD_TYPE = EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),2)
      X.FIELD_LEN = VAL(EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),3))
      X.KEY_LEN = X.KEY_LEN + X.FIELD_LEN
      INC X.FLD_CNT
      DO CASE
	CASE X.FIELD_TYPE = 'C'
	  X.CMD_LINE = X.CMD_LINE + EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),1) + ' + '

	CASE X.FIELD_TYPE = 'N'
	  X.CMD_LINE = X.CMD_LINE + "STR(" + EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),1) + "," + EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),3) + "," +  EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),4) + ") + "

	CASE X.FIELD_TYPE = 'D'
	  X.CMD_LINE = X.CMD_LINE + "DTOK(" + EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),1) + ") + "

	CASE X.FIELD_TYPE = 'L'
	  X.CMD_LINE = X.CMD_LINE + "LTOC(" + EXTRACT(',',FIELDSPEC(FP,Y.FLD_CHOICE),1) + ") + "
      ENDCASE
      DO SHOWCMD1
      LOOP
    ENDIF
    EXIT
  ENDDO
  DO CASE
    CASE X.FLD_CNT > 7
      Y.ERR_TEXT = 'Too many fields in the index expression.'
      DO SHOWERR
      LOOP
    CASE X.KEY_LEN > 128
      Y.ERR_TEXT = 'The key length is too long (max 128 bytes).'
      DO SHOWERR
      LOOP
    CASE X.KEY_LEN = 0
      Y.ERR_TEXT = 'Please enter an index key.'
      DO SHOWERR
      LOOP
    OTHERWISE
      EXIT
  ENDCASE
ENDDO | END GET ITEMS
* REMOVE THE LAST ' + '
X.CMD_LINE = $(X.CMD_LINE,1,(LEN(TRIM(X.CMD_LINE))-2)) + ' TO '
DO SHOWCMD
DO WHILE T
  DO GETFNAME
  IF X.FILE_OK
    Y.ERR_TEXT = 'File already exists. Try another name.'
    DO SHOWERR
    LOOP
  ELSE
    X.CMD_LINE = X.CMD_LINE + X.FILE_NAME
    DO SHOWCMD
    Y.MSG1_TEXT = 'Indexing '+LTRIM(STR(LASTREC(),5))+' records to '+TRIM(X.FILE_NAME)+'  Please wait....'
    DO SHOWMSG1
    &X.CMD_LINE
    EXIT
  ENDIF
ENDDO
RETURN | ************* END OF CRINDEX *********


***********
PROCEDURE CRREP
**********
DO CKINUSE
DO CKRDBM
X.MSG_TXT = 'CREATE A REPORT FORM'
X.FILE_NAME = ''
X.FILE_EXT = '.FRM'
DO WHILE T
  X.CMD_LINE = 'CREATE REPORT '
  DO SHOWCMD
  DO GETFNAME
  IF NOT X.FILE_OK
    CREATE REPORT &X.FILE_NAME
    EXIT
  ELSE
    Y.ERR_TEXT = 'File already exists. Use MODIFY REPORT.'
    DO SHOWERR
    LOOP
  ENDIF
ENDDO
RETURN | END OF CRREP


*****
PROCEDURE CNVDBASE
*****
X.FILE_NAME = ''
X.FILE_EXT = '.DBF'
DO WHILE T
  X.CMD_LINE = 'CONVERT '
  DO SHOWCMD
  X.MSG_TXT = 'dBASE'+CHR(248)+' FILE'
  DO GETFNAME
  IF NOT X.FILE_OK
    DO NOFILE
    LOOP
  ENDIF
  Y.DBASE_FN = X.FILE_NAME
  X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME) + ' TO '
  DO SHOWCMD
  X.MSG_TXT = 'dBMAN FILE'
  DO GETFNAME
  X.CMD_LINE = X.CMD_LINE + X.FILE_NAME
  DO SHOWCMD
  Y.MSG1_TEXT = 'Converting '+TRIM(Y.DBASE_FN)+' to '+X.FILE_NAME
  DO SHOWMSG1
  &X.CMD_LINE
  EXIT
ENDDO
RETURN TO A


*****
PROCEDURE DSPFILE
* DISPLAY FILE
*****
DO WHILE T
  X.CMD_LINE = 'DISPLAY FILE '
  DO SHOWCMD
  X.GET_VAR = SPACE(30)
  Y.MSG1_TEXT =  'DISPLAY FILES'
  Y.MSG2_TEXT =  'Please enter a TOS wild card pattern.'
  Y.GET_TEXT = 'X.GET_VAR'
  DO GETREAD
  ERASE
  IF LEN(TRIM(X.GET_VAR)) = 0
    X.GET_VAR = '\*.DBF'
  ENDIF
  DISPLAY FILE &X.GET_VAR
  Y.ERR_TEXT = "Directory of " + X.GET_VAR - ' .'
  DO SHOWERR
  EXIT
ENDDO
RETURN


*****
PROCEDURE OPNDATA
* OPEN DATABASE
*****
X.MSG_TXT = 'OPEN A DATABASE'
X.FILE_NAME = ''
X.FILE_EXT = '.DBF'
DO WHILE T
  X.CMD_LINE = 'USE '
  DO SHOWCMD
  DO GETFNAME
  IF X.FILE_OK
    EXIT
  ENDIF
  DO NOFILE
ENDDO
X.CMD_LINE = X.CMD_LINE + X.FILE_NAME
DO SHOWCMD
USE FP &X.FILE_NAME
RETURN	| END OF OPNDATA


*****
PROCEDURE OPNINDX
* OPEN INDEX FILE
*****
DO CKINUSE
X.MSG_TXT = 'OPEN AN INDEX FILE'
X.FILE_NAME = ''
X.FILE_EXT = '.NDX'
DO WHILE T
  X.CMD_LINE = 'SET INDEX TO '
  DO SHOWCMD
  DO GETFNAME
  IF X.FILE_OK
    EXIT
  ENDIF
  DO NOFILE
ENDDO
X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME)
DO SHOWCMD
SET FP INDEX TO &X.FILE_NAME
RETURN	| END OF OPNINDX


*****
PROCEDURE APPDFILE
* APPEND FROM A FILE
*****
DO CKINUSE
X.MSG_TXT = 'APPEND FILE'
X.FILE_NAME = ''
X.FILE_EXT = '.DBF'
DO WHILE T
  X.CMD_LINE = 'APPEND FROM '
  DO SHOWCMD
  DO GETFNAME
  IF X.FILE_OK
    EXIT
  ENDIF
  DO NOFILE
ENDDO
X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME)
DO SHOWCMD
Y.MSG1_TEXT = 'Appending. Please wait....'
DO SHOWMSG1
&X.CMD_LINE
RETURN	| ************ END OF APPDFILE ***********


*****
PROCEDURE RENFILE
* RENAME FILE
*****
DO WHILE T
  X.CMD_LINE = 'RENAME '
  DO SHOWCMD
  X.MSG_TXT = 'RENAME A TOS FILE'
  X.FILE_NAME = ''
  X.FILE_EXT = '.DBF'
  DO GETFNAME
  IF NOT X.FILE_OK
    DO NOFILE
    LOOP
  ENDIF
  IF TRIM(X.FILE_NAME) = FILENAME(FP)
    DO FILEOPEN
    LOOP
  ENDIF
  X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME) + ' TO '
  DO SHOWCMD
  Y.OLD_FILE = X.FILE_NAME
  X.MSG_TXT = 'NEW TOS FILE NAME'
  X.FILE_NAME = ''
  X.FILE_EXT = '.DBF'
  DO GETFNAME
  IF X.FILE_NAME = Y.OLD_FILE
    Y.ERR_TEXT = 'Can not rename to the same name.'
    DO SHOWERR
    LOOP
  ENDIF
  IF X.FILE_OK
    Y.ERR_TEXT = 'File already exists. Try another name'
    DO SHOWERR
    LOOP
  ENDIF
  X.CMD_LINE = X.CMD_LINE + X.FILE_NAME
  DO SHOWCMD
  RENAME &Y.OLD_FILE TO &X.FILE_NAME
  EXIT
ENDDO
RETURN


*****
PROCEDURE DELFILE
* DELETE FILE
*****
X.CMD_LINE = 'DELETE FILE '
DO SHOWCMD
X.MSG_TXT = 'DELETE A TOS FILE'
X.FILE_NAME = ''
X.FILE_EXT = '.DBF'
DO WHILE T
  DO GETFNAME
  IF TRIM(X.FILE_NAME) = FILENAME(FP)
    DO FILEOPEN
    LOOP
  ENDIF
  IF NOT X.FILE_OK
    DO NOFILE
    LOOP
  ENDIF
  X.CMD_LINE = X.CMD_LINE + X.FILE_NAME
  DO SHOWCMD
  DELETE FILE &X.FILE_NAME
  EXIT
ENDDO
RETURN	| END OF DELFILE


*****
PROCEDURE CPYFILE
* COPY FILE
*****
X.FILE_NAME = ''
DO WHILE T
  X.CMD_LINE = 'COPY FILE '
  DO SHOWCMD
  X.MSG_TXT = 'COPY A TOS FILE (SOURCE)'
  X.FILE_EXT = '.DBF'
  DO GETFNAME
  IF TRIM(X.FILE_NAME) = FILENAME(FP)
    DO FILEOPEN
    LOOP
  ENDIF
  IF NOT X.FILE_OK
    DO NOFILE
    LOOP
  ENDIF
  X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME) + ' TO '
  DO SHOWCMD
  Y.OLD_FILE = X.FILE_NAME
  X.MSG_TXT = 'COPY A TOS FILE (DEST)  '
  X.FILE_NAME = ''
  X.FILE_EXT = '.DBF'
  DO GETFNAME
  IF TRIM(X.FILE_NAME) = FILENAME(FP)
    DO FILEOPEN
    X.FILE_NAME = Y.OLD_FILE
    LOOP
  ENDIF
  IF X.FILE_NAME = Y.OLD_FILE
    Y.ERR_TEXT = 'Can not copy to the same name.'
    DO SHOWERR
    X.FILE_NAME = Y.OLD_FILE
    LOOP
  ENDIF
  IF X.FILE_OK
    Y.ERR_TEXT = 'File already exists. Press any key to over write it, or ESC to abort.'
    DO SHOWERR
    DO CASE
      CASE LASTKEY() = 27
	RETURN TO A
    ENDCASE
  ENDIF
  X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME)
  DO SHOWCMD
  Y.MSG1_TEXT = 'Copying file. Please wait ...'
  DO SHOWMSG1
  COPY FILE &Y.OLD_FILE TO &X.FILE_NAME
  EXIT
ENDDO
RETURN	| END OF CPYFILE


***********
PROCEDURE FINDFILE
***********
* FINDFILE.PRG
* CHECKS IF A FILE X.FILE_NAME EXISTS
IF FILE (X.FILE_NAME)
  X.FILE_OK = T
ELSE
  X.FILE_OK = F
ENDIF
RETURN	| ************* END OF FINDFILE *******


***********
PROCEDURE FLDMENU
***********
X.FIELD_NO = 1
X.MENU_TXT = ''
DO WHILE X.FIELD_NO < 41
  IF LEN(EXTRACT(',',FIELDSPEC(FP,X.FIELD_NO),1)) = 0
    EXIT
  ENDIF
  X.MENU_TXT = X.MENU_TXT + EXTRACT(',',FIELDSPEC(FP,X.FIELD_NO),1) + ","+EXTRACT(',',FIELDSPEC(FP,X.FIELD_NO),2)+"|"
  INC X.FIELD_NO
ENDDO
X.MENU_TXT = $(X.MENU_TXT,1,LEN(X.MENU_TXT)-1)
ERASE
DO SHOWSTAT
DO SHOWCMD
X.KEY_LEN = 0
X.FLD_CNT = 0
RETURN | ************* END OF FLDMENU *********


***********
PROCEDURE GOREC
* GO TO A RECORD
**********
DO CKINUSE
DO CKNEMPTY
X.CMD_LINE = 'GOTO '
DO SHOWCMD
Y.MSG1_TEXT = 'GO TO'
Y.VMENU_TEXT = 'RECORD|TOP|BOTTOM'
Y.VMENU_COL = 16
DO GETVMENU
DO CASE
  CASE VMENU() = 1
    X.GET_VAR = 1
    Y.MSG1_TEXT = ''
    Y.MSG2_TEXT = 'Please enter a record number.'
    Y.GET_TEXT = 'X.GET_VAR PICTURE "#########" GETFILE CHKREC'
    DO GETREAD
    GO X.GET_VAR
  CASE VMENU() = 2
    X.CMD_LINE = X.CMD_LINE + 'TOP'
    &X.CMD_LINE
  CASE VMENU() = 3
    X.CMD_LINE = X.CMD_LINE + 'BOTTOM'
    &X.CMD_LINE
ENDCASE
RETURN	| ********* END OF GOREC *************


***********
PROCEDURE FNDREC
* FIND A RECORD
**********
DO CKINUSE
DO CKNEMPTY
DO CKNDX
DO WHILE T
  X.CMD_LINE = 'FIND '
  DO SHOWCMD
  X.GET_VAR = SPACE(25)
  Y.MSG1_TEXT =  ''
  Y.MSG2_TEXT =   'Please enter search argument'
  Y.GET_TEXT = 'X.GET_VAR'
  DO GETREAD
  Y.TEMP = TRIM(X.GET_VAR)
  IF LEN(Y.TEMP) = 0
    Y.ERR_TEXT = 'No key was entered. Please try again.'
    DO SHOWERR
    LOOP
  ENDIF
  IF TYPE(Y.TEMP) = 'U'
    Y.TEMP = '"' + Y.TEMP + '"'
    IF TYPE(Y.TEMP) = 'U'
      Y.ERR_TEXT = 'Invalid search argument. Please try again.'
      DO SHOWERR
      LOOP
    ENDIF
  ENDIF
  X.CMD_LINE = X.CMD_LINE + TRIM(Y.TEMP)
  DO SHOWCMD
  &X.CMD_LINE
  IF EOF(FP)
    Y.ERR_TEXT = 'No matching record was found.'
    DO SHOWERR
    LOOP
  ENDIF
  EXIT
ENDDO
RETURN	| ********* END OF FNDREC ***********


***********
PROCEDURE LOCREC
* LOCATE A RECORD
**********
DO CKINUSE
DO CKNEMPTY
DO WHILE T
  X.CMD_LINE = 'LOCATE '
  DO SHOWCMD
  DO SCOPE
  DO FORPHRASE
  &X.CMD_LINE
  IF EOF(FP)
    Y.ERR_TEXT = 'No matching records were found.'
    DO SHOWERR
    LOOP
  ENDIF
  EXIT
ENDDO
RETURN  | ******** END OF LOCREC ************


***********
PROCEDURE CONREC
* CONTINUE A RECORD
**********
DO CKINUSE
DO CKNEMPTY
CONTINUE
IF EOF(FP)
  Y.ERR_TEXT = 'No matching records were found.'
  DO SHOWERR
  RETURN TO A
ENDIF
RETURN	| ************ END OF CONREC *************


***********
PROCEDURE MODSTRCT
* MODIFY STRUCTURE
***********
DO CKINUSE
SET TALK ON
MODIFY STRUCTURE
SET TALK OFF
RETURN


***********
PROCEDURE MODFLD
* MODIFY FIELD NAME
***********
DO CKINUSE
SET TALK ON
MODIFY FIELDNAME
SET TALK OFF
RETURN


***********
PROCEDURE MODREP
***********
DO CKINUSE
DO CKRDBM
X.MSG_TXT = 'MODIFY A REPORT FORM'
X.FILE_NAME = ''
X.FILE_EXT = '.FRM'
DO WHILE T
  X.CMD_LINE = 'MODIFY REPORT '
  DO SHOWCMD
  DO GETFNAME
  IF X.FILE_OK
    MODIFY REPORT &X.FILE_NAME
    RETURN TO A
  ELSE
    DO NOFILE
    LOOP
  ENDIF
ENDDO
RETURN | ************* END OF PROCEDURE *********


*****
PROCEDURE PRNTREP
* PRINT REPORT
*****
DO CKINUSE
X.MSG_TXT = 'PRINT A REPORT FORM'
X.FILE_NAME = ''
X.FILE_EXT = '.FRM'
DO WHILE T
  X.CMD_LINE = 'REPORT FORM '
  DO SHOWCMD
  DO GETFNAME
  IF X.FILE_OK
    X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME) + ' '
    DO SHOWCMD
    DO FORPHRASE
    Y.MSG1_TEXT = 'PRINT ON'
    Y.VMENU_TEXT = 'SCREEN|PRINTER'
    Y.VMENU_COL = 15
    DO GETVMENU
    DO CASE
	CASE VMENU() = 1 | PRINT ON SCREEN
	  EXIT
	CASE VMENU() = 2  | PRINT ON PRINTER
	  X.CMD_LINE = X.CMD_LINE + ' TO PRINT'
	  EXIT
    ENDCASE
  ELSE
    DO NOFILE
    LOOP
  ENDIF
ENDDO
SET TALK ON
&X.CMD_LINE
SET TALK OFF
RETURN	| END OF PRNTREP


***********
PROCEDURE SRTDATA
* SORT THE DATA BASE
***********
DO CKINUSE
X.MSG_TXT = 'SORT FILE NAME'
X.FILE_NAME = ''
X.FILE_EXT = '.DBF'
X.CMD_LINE = 'SORT ON '
DO SHOWCMD
DO GFLDLST1
X.CMD_LINE = X.CMD_LINE + ' TO '
DO SHOWCMD
DO GETFNAME
IF X.FILE_OK
  Y.ERR_TEXT = 'File already exists. Press any key to over write it, or ESC to abort.'
  DO SHOWERR
ENDIF
X.CMD_LINE = X.CMD_LINE + TRIM(X.FILE_NAME)
DO SHOWCMD
Y.MSG1_TEXT = 'Sorting '+ LTRIM(STR(LASTREC(),6))+' records.  Please wait.....'
DO SHOWMSG1
SET SAFETY OFF
&X.CMD_LINE
SET SAFETY ON
RETURN	| ************* END OF SRTDATA *************


***********
PROCEDURE RNDXDATA
* REINDEX THE DATA BASE
***********
DO CKINUSE
DO CKNDX
X.CMD_LINE = 'REINDEX'
DO SHOWCMD
Y.MSG1_TEXT = 'Re-indexing ' + LTRIM(STR(LASTREC(),6)) + ' records.  Please wait.....'
DO SHOWMSG1
REINDEX
RETURN	| ************* END OF RNDXDATA *************


*************
PROCEDURE HELP
*************
Y.ERR_TEXT = 'Sorry help is not yet available'
DO SHOWERR
RETURN
********

***********
PROCEDURE ADDREC
* APPEND RECORD
***********
DO CKINUSE
SET TALK ON
APPEND
SET TALK OFF
RETURN


***********
PROCEDURE EDTREC
* EDIT RECORD
***********
DO CKINUSE
DO CKNEMPTY
X.GET_VAR = 0
Y.MSG1_TEXT = 'EDIT RECORD'
Y.MSG2_TEXT = 'Enter a record number. 0 = Current rec.'
Y.GET_TEXT = 'X.GET_VAR PICTURE "#########"'
DO WHILE T
  DO GETREAD
  IF X.GET_VAR >= LASTREC()
    Y.ERR_TEXT = 'Record '+ LTRIM(STR(X.GET_VAR,6)) + ' is not in the database file. '
    DO SHOWERR
    LOOP
  ENDIF
  IF X.GET_VAR <> 0
    GO X.GET_VAR
  ENDIF
  EXIT
ENDDO
SET TALK ON
EDIT
SET TALK OFF
RETURN


***********
PROCEDURE DELREC
* DELETE RECORD
***********
DO CKINUSE
X.CMD_LINE = 'DELETE '
DO SHOWCMD
DO SCOPE
DO FORPHRASE
&X.CMD_LINE
RETURN


***********
PROCEDURE RCLREC
* RECALL RECORDS
***********
DO CKINUSE
X.CMD_LINE = 'RECALL '
DO SHOWCMD
DO SCOPE
DO FORPHRASE
&X.CMD_LINE
RETURN


***********
PROCEDURE DSPREC
* DISPLAY RECORD
***********
DO CKINUSE
DO CKNEMPTY
X.CMD_LINE = 'DISPLAY '
DO SHOWCMD
DO SCOPE
DO FORPHRASE
DO GETFLDLST
ERASE
SET TALK ON
&X.CMD_LINE
SET TALK OFF
RETURN	| ********** END OF DSPREC ******


***********
PROCEDURE LSTREC
* LIST RECORDS
***********
DO CKINUSE
X.CMD_LINE = 'LIST '
DO SHOWCMD
DO SCOPE
DO FORPHRASE
DO GETFLDLST
Y.MSG1_TEXT = 'PRINT ON'
Y.VMENU_TEXT = 'SCREEN|PRINTER'
Y.VMENU_COL = 15
DO GETVMENU
DO CASE
  CASE VMENU() = 2  | PRINT ON PRINTER
    X.CMD_LINE = X.CMD_LINE + ' TO PRINT'
ENDCASE
ERASE
SET TALK ON
&X.CMD_LINE
SET TALK OFF
Y.ERR_TEXT = ''
DO SHOWERR
RETURN	| ************** END OF LSTREC *************


***********
PROCEDURE REPLREC
* REPLACE RECORD
***********
DO CKINUSE
X.CMD_LINE = 'REPLACE '
DO SHOWCMD
DO SCOPE
DO FLDMENU
DO GETWITH
* GET A WITH LIST
DO WHILE T
  Y.MSG1_TEXT = 'REPLACE FIELDS'
  Y.VMENU_TEXT = 'NO MORE FIELD|MORE FIELD'
  Y.VMENU_COL = 12
  DO GETVMENU
  IF VMENU() = 1
    EXIT
  ENDIF
  X.CMD_LINE = X.CMD_LINE+','
  DO SHOWCMD
  DO GETWITH
ENDDO
DO FORPHRASE
Y.MSG1_TEXT = 'REPLACEing please wait.....'
DO SHOWMSG1
&X.CMD_LINE
RETURN	| ********** END OF REPLREC *****


***********
PROCEDURE PACKFILE
* PACK FILE
***********
DO CKINUSE
X.CMD_LINE = 'PACK'
DO SHOWCMD
Y.MSG1_TEXT = 'DO YOU REALLY WANT TO REMOVE DATA NOW?'
DO SHOWYESNO
Y.MSG1_TEXT = 'Preparing to remove deleted records, (PACK). Please wait....'
DO SHOWMSG1
PACK
RETURN	| ************ END OF PACKFILE **********



***********
PROCEDURE ZAPFILE
* ZAP FILE
***********
DO CKINUSE
X.CMD_LINE = 'ZAP'
DO SHOWCMD
Y.MSG1_TEXT = 'DO YOU REALLY WANT TO REMOVE DATA NOW?'
DO SHOWYESNO
Y.MSG1_TEXT = 'Preparing to remove ALL records, (ZAP). Please wait....'
DO SHOWMSG1
ZAP
RETURN	| ************ END OF ZAPFILE **********


***********
PROCEDURE CPYREC
* COPY RECORDS
***********
DO CKINUSE
X.CMD_LINE = 'COPY '
DO SHOWCMD
DO SCOPE
X.CMD_LINE = X.CMD_LINE+'TO '
DO SHOWCMD
X.MSG_TXT = 'TARGET FILE NAME'
X.FILE_NAME = ''
X.FILE_EXT = '.DBF'
DO WHILE T
  DO GETFNAME
  IF NOT X.FILE_OK
    X.CMD_LINE = X.CMD_LINE+ TRIM(X.FILE_NAME)+' '
    DO SHOWCMD
    EXIT
  ENDIF
  Y.ERR_TEXT = 'File already exists. Try another name.'
  DO SHOWERR
ENDDO
DO FORPHRASE
DO GETFLDLST
Y.MSG1_TEXT = 'COPYing. Please wait.....'
DO SHOWMSG1
&X.CMD_LINE
RETURN	| ********** END OF CPYREC *********


***********
PROCEDURE SUMREC
* SUM RECORDS
***********
DO CKINUSE
X.CMD_LINE = 'SUM '
DO SHOWCMD
    DO FLDMENU
    Y.ERR_TEXT = "PLEASE SELECT A NUMERIC EIELD ONLY"
    DO SHOWERR
    DO GETFIELD
    IF TYPE(TRIM($(X.CMD_LINE,4))) <> 'N'
      Y.ERR_TEXT = 'Field was not a numeric field.'
      DO SHOWERR
      RETURN TO A
    ENDIF
    X.CMD_LINE = X.CMD_LINE + ' TO Y.SUM_VAR '
    DO SHOWCMD
    DO SCOPE
    DO FORPHRASE
    @ 20,00 ESAY 'SUM = '
    Y.SUM_VAR = 0
    &X.CMD_LINE
    @ 20,07 SAY Y.SUM_VAR
    Y.ERR_TEXT = ''
    DO SHOWERR
    RETURN


***********
PROCEDURE FILECLOS
***********
Y.ERR_TEXT = 'No data file in use.'
DO SHOWERR
RETURN


***********
PROCEDURE FILENP
***********
Y.ERR_TEXT = 'You must enter a file name.'
DO SHOWERR
RETURN


***********
PROCEDURE FILEOPEN
***********
Y.ERR_TEXT = 'File is in use. Please try again.'
DO SHOWERR
RETURN


***********
PROCEDURE NOFILE
***********
Y.ERR_TEXT = 'File not found. Please try again.'
DO SHOWERR
RETURN | ************* END OF PROCEDURE *********


***********
PROCEDURE GETFLDLST
* GET FIELD LIST
***********
Y.MSG1_TEXT = 'SELECT FIELDS'
Y.VMENU_TEXT = 'ALL FIELDS|SELECTED FIELDS'
Y.VMENU_COL = 12
DO GETVMENU
IF VMENU() = 2
  DO GFLDLST1
ENDIF
RETURN	| ******* END OF GETFLDLST ************


***********
PROCEDURE GFLDLST1
* GET FIELD LIST
***********
DO FLDMENU	| CREATE FIELD MENU
DO GETFIELD
DO WHILE T
  Y.MSG1_TEXT = 'SELECT MORE FIELDS?'
  Y.VMENU_TEXT = 'NO MORE SELECTIONS|MORE FIELDS TO SELECT'
  Y.VMENU_COL = 9
  DO GETVMENU
  IF VMENU() = 1
    EXIT
  ENDIF
  X.CMD_LINE = X.CMD_LINE+','
  DO SHOWCMD
  DO GETFIELD
ENDDO
RETURN	| ************ END OF GFLDLST1 ************


***********
PROCEDURE GETFIELD
* GET ONE FIELD NAME IN X.CMD_LINE
***********
DO SELFIELD
X.FIELD_NAME = EXTRACT(',',FIELDSPEC(FP,HMENU()),1)
X.FIELD_TYPE = EXTRACT(',',FIELDSPEC(FP,HMENU()),2)
X.FIELD_LEN = VAL(EXTRACT(',',FIELDSPEC(FP,HMENU()),3))
X.FIELD_DEC = VAL(EXTRACT(',',FIELDSPEC(FP,HMENU()),4))
X.KEY_LEN = X.KEY_LEN + X.FIELD_LEN
X.CMD_LINE = X.CMD_LINE + X.FIELD_NAME
INC X.FLD_CNT
DO SHOWCMD1
RETURN | ************* END OF GETFIELD *********


***********
PROCEDURE GETWITH
* GET A WITH PHRASE
***********
DO GETFIELD
X.CMD_LINE = X.CMD_LINE +' WITH '
DO SHOWCMD
DO GETEXP
RETURN	| ************** END OF GETWITH *************


***********
PROCEDURE SCOPE
* GET SCOPE PHRASE
***********
*SCOPE.PRG
*FIND SCOPE AND CONDITIONS FOR A COMMAND
* X.CMD_LINE IS THE COMMAND TO BUILD
Y.REC_NUM = 1
DO WHILE T
  Y.MSG1_TEXT = 'PLEASE SELECT A SCOPE'
  Y.VMENU_TEXT = 'ALL THE RECORDS|RECORD (JUST ONE)|NEXT ? RECORDS|REST OF THE FILE'
  Y.VMENU_COL = 11
  DO GETVMENU
  DO CASE
    CASE VMENU() = 1 | ALL
      X.CMD_LINE = X.CMD_LINE + 'ALL '
      EXIT
    CASE VMENU() = 2 | RECORD
	X.GET_VAR = 0
	Y.MSG1_TEXT = ''
	Y.MSG2_TEXT = 'Please enter a record number.'
	Y.GET_TEXT = 'X.GET_VAR  PICTURE "######" GETFILE CHKREC'
	DO GETREAD
	X.CMD_LINE = X.CMD_LINE + 'RECORD '+ LTRIM(STR(X.GET_VAR,5))
	SET TALK ON
	&X.CMD_LINE
	SET TALK OFF
	RETURN TO A
    CASE VMENU() = 3 | NEXT ? RECORD
	X.GET_VAR = 0
	Y.MSG1_TEXT = ''
	Y.MSG2_TEXT = 'Please enter number of records.'
	Y.GET_TEXT = 'X.GET_VAR  PICTURE "######"'
	DO GETREAD
	X.CMD_LINE = X.CMD_LINE + 'NEXT '+ LTRIM(STR(X.GET_VAR,5))+' '
	EXIT
    CASE VMENU() = 4 | REST
      X.CMD_LINE = X.CMD_LINE + 'REST '
      EXIT
  ENDCASE
ENDDO
DO SHOWCMD
RETURN


***********
PROCEDURE FORPHRASE
* GET FOR EXPRESSION
* IN X.CMD_LINE
***********
Y.MSG1_TEXT = 'CREATE A SELECTION'
Y.VMENU_TEXT = 'NO SELECTIONS|CREATE SELECTIONS'
Y.VMENU_COL = 10
DO GETVMENU
IF VMENU() = 1
  RETURN
ENDIF
*
X.CMD_LINE = X.CMD_LINE + 'FOR '
DO SHOWCMD
DO FLDMENU
DO GETLEXP
DO WHILE LEN(TRIM(X.CMD_LINE)) < 76
  Y.MSG1_TEXT = 'CREATE A SELECTION'
  Y.VMENU_TEXT = 'NO FURTHER SELECTIONS|CONTINUE WITH AND|CONTINUE WITH OR'
  Y.VMENU_COL = 9
  DO GETVMENU
  DO CASE
    CASE VMENU() = 1
      EXIT
    CASE VMENU() = 2
      X.CMD_LINE = X.CMD_LINE + 'AND '
    CASE VMENU() = 3
      X.CMD_LINE = X.CMD_LINE + 'OR '
  ENDCASE
  DO SHOWCMD1
  DO GETLEXP
ENDDO
RETURN | ************* END OF FORPHRASE *********


***********
PROCEDURE GETLEXP
* GET A LOGICAL EXPRESSION
***********
DO GETFIELD
DO GETRELOP
DO GETVALUE
RETURN | ************* END OF GETLEXP *********


***********
PROCEDURE GETVALUE
* GET THE CONSTANT 
***********
DO CASE
  CASE X.FIELD_TYPE = 'C'
    DO WHILE T
      X.GET_VAR = SPACE(20)
      Y.MSG1_TEXT =  ''
      Y.MSG2_TEXT = 'Enter character STRING (no quotes)'
      Y.GET_TEXT = 'X.GET_VAR'
      DO GETREAD
      IF SRCH('"',X.GET_VAR) > 0
	Y.ERR_TEXT = 'Please re-enter a string without quotes'
	DO SHOWERR
	LOOP
      ENDIF
      X.CMD_LINE = X.CMD_LINE + '"' + TRIM(X.GET_VAR)+'" '
      EXIT
    ENDDO
  CASE X.FIELD_TYPE = 'D'
    DO WHILE T
      X.GET_VAR = {//}
      Y.MSG1_TEXT =  ''
      Y.MSG2_TEXT =  'Please enter a DATE.'
      Y.GET_TEXT = 'X.GET_VAR'
      DO GETREAD
      X.CMD_LINE = X.CMD_LINE + '{' + DTOC(X.GET_VAR)+'} '
      EXIT
    ENDDO
  CASE X.FIELD_TYPE = 'N'
    X.GET_PIC = DUPCHAR(35,X.FIELD_LEN + 1) | PICTURE FOR GETING NUMBER
    X.GET_PIC = MIDSTR('.',X.GET_PIC,(X.FIELD_LEN - X.FIELD_DEC)+1)
    DO WHILE T
      X.GET_VAR =  VAL(STR(0,X.FIELD_LEN,X.FIELD_DEC))
      Y.MSG1_TEXT =  ''
      Y.MSG2_TEXT =  'Please enter a NUMBER.'
      Y.GET_TEXT = 'X.GET_VAR PICTURE X.GET_PIC'
      DO GETREAD
      X.CMD_LINE = X.CMD_LINE + LTRIM(STR(X.GET_VAR,X.FIELD_LEN,X.FIELD_DEC))+' '
      EXIT
    ENDDO
  CASE X.FIELD_TYPE = 'L'
    DO WHILE T
      Y.MSG1_TEXT = 'Please select'
      Y.VMENU_TEXT = X.FIELD_NAME + ' = YES|' + X.FIELD_NAME + ' = NO'
      Y.VMENU_COL = 13
      DO GETVMENU
      IF VMENU() = 2
	Y.LENFLD = LEN(X.FIELD_NAME)
	Y.LENCMD = LEN(X.CMD_LINE)
        X.CMD_LINE = MIDSTR(SPACE(Y.LENFLD),X.CMD_LINE,Y.LENCMD - Y.LENFLD +1)
	X.CMD_LINE = X.CMD_LINE - ' NOT ' + X.FIELD_NAME
      ENDIF
      X.CMD_LINE = X.CMD_LINE + ' '
      EXIT
    ENDDO
ENDCASE
DO SHOWCMD1
RETURN | ************* END OF GETVALUE *********


***********
PROCEDURE GETRELOP
* GET RELATIONAL OPERATOR
***********
* GETRELOP.PRG
* GET A LOGICAL OPERATOR FROM THE USER FOR THE FOR PHRASE
IF X.FIELD_TYPE = 'L'
  RETURN
ENDIF
Y.MSG1_TEXT = 'PLEASE SELECT AN OPERATOR'
Y.VMENU_TEXT = '=  Equal To|<= Less Than or Equal To|<  Less Than|>  Greater Than|>= Greater Than or Equal To|<> Not Equal To'
Y.VMENU_COL = 7
DO WHILE T
  DO GETVMENU
  DO CASE
    CASE VMENU() = 1
      X.CMD_LINE = X.CMD_LINE + ' = '
    CASE VMENU() = 2
      X.CMD_LINE = X.CMD_LINE + ' <= '
    CASE VMENU() = 3
      X.CMD_LINE = X.CMD_LINE + ' < '
    CASE VMENU() = 4
      X.CMD_LINE = X.CMD_LINE + ' > '
    CASE VMENU() = 5
      X.CMD_LINE = X.CMD_LINE + ' >= '
    CASE VMENU() = 6
      X.CMD_LINE = X.CMD_LINE + ' <> '
  ENDCASE
  EXIT
ENDDO
DO SHOWCMD1
RETURN | ************* END OF GETRELOP *********


***********
PROCEDURE GETEXP
* GET AN EXPRESSION.
* X.FIELD_TYPE IS THE EXPRESSION DATA TYPE
***********
X.GET_VAR = SPACE(35)
Y.MSG1_TEXT =  ''
Y.GET_TEXT = 'X.GET_VAR'
DO CASE
  CASE X.FIELD_TYPE = 'C'
    Y.MSG2_TEXT =  'Please enter a STRING EXPRESSION.'
    DO WHILE T
      DO GETREAD
      IF TYPE(X.GET_VAR) = 'C'
	X.CMD_LINE = X.CMD_LINE + X.GET_VAR - ' '
	EXIT
      ENDIF
      Y.ERR_TEXT = 'This is not a STRING EXPRESSION.'
      DO SHOWERR
    ENDDO
  CASE X.FIELD_TYPE = 'N'
    Y.MSG2_TEXT =  'Please enter a NUMERIC EXPRESSION.'
    DO WHILE T
      DO GETREAD
      IF TYPE(X.GET_VAR) = 'N'
	X.CMD_LINE = X.CMD_LINE + X.GET_VAR - ' '
	EXIT
      ENDIF
      Y.ERR_TEXT = 'This is not a NUMERIC EXPRESSION.'
      DO SHOWERR
    ENDDO
  CASE X.FIELD_TYPE = 'D'
    Y.MSG2_TEXT =  'Please enter a DATE EXPRESSION.'
    DO WHILE T
      DO GETREAD
      IF TYPE(X.GET_VAR) = 'D'
	X.CMD_LINE = X.CMD_LINE + X.GET_VAR - ' '
	EXIT
      ENDIF
      Y.ERR_TEXT = 'This is not a DATE EXPRESSION.'
      DO SHOWERR
    ENDDO
  CASE X.FIELD_TYPE = 'L'
    Y.MSG2_TEXT =  'Please enter a LOGIC EXPRESSION.'
    DO WHILE T
      DO GETREAD
      IF TYPE(X.GET_VAR) = 'L'
	X.CMD_LINE = X.CMD_LINE + X.GET_VAR - ' '
	EXIT
      ENDIF
      Y.ERR_TEXT = 'This is not a LOGIC EXPRESSION.'
      DO SHOWERR
    ENDDO
ENDCASE
DO SHOWCMD1
RETURN | ************* END OF GETEXP *********


***********
PROCEDURE CKINUSE
* CHECKS IF A DATA BASE FILE IS USED
* RETURNS TO "A" IF NOT IN USE
***********
IF FILENAME(FP) = ''
  DO FILECLOS
  RETURN TO A
ENDIF
RETURN	| END OF CKINUSE


***********
PROCEDURE CKNDX
* CHECKS IF A INDEX FILE IS USED
* RETURNS TO "A" IF NOT IN USE
***********
IF TRIM(INDEXNAME()) = ''
  Y.ERR_TEXT = 'No index file in use.'
  DO SHOWERR
  RETURN TO A
ENDIF
RETURN


***********
PROCEDURE CKNEMPTY
* CHECKS IF A DATA BASE FILE IS NOT EMPTY
* ERROR AND RETURNS TO A IF NOT IN USE
***********
IF LASTREC() = 0
  Y.ERR_TEXT = 'The file is empty.'
  DO SHOWERR
  RETURN TO A
ENDIF
RETURN	| END OF CKNEMPTY


***********
PROCEDURE CKRDBM
* CHECKS IF RPRTI.DBM EXIST
* RETURNS TO "A" IF NOT IN IT DOES NOT EXIST
***********
IF NOT FILE("RPRTI.DBM")
  Y.ERR_TEXT = 'No RPRTI.DBM file. Please copy from Master disk.'
  DO SHOWERR
  RETURN TO A
ENDIF
RETURN	| END OF CKRDBM


***********
PROCEDURE CHKREC
***********
*CHKREC.PRG
*CHECK IF A RECORD NUMBER TO GOTO IS VALID
*THIS IS A GET FILE CALLED FROM LOCPROC.PRG
IF LASTKEY() = 27
  ASSIGN USERSTAT(255)
  RETURN
ENDIF
IF NRANGE(X.GET_VAR,1,LASTREC(FP))
  ASSIGN USERSTAT(255)
  RETURN
ENDIF
ASSIGN USERSTAT(0)
Y.ERR_TEXT = 'Record '+ LTRIM(STR(X.GET_VAR,6)) + ' is not in the database file. '
DO SHOWERR
RETURN


***********
PROCEDURE SHOWSTAT
***********
&SAYREVERSE
@ 23,00 SAY SPACE(80)
@ 23,00 SAY 'FILE IN USE: '+ FILENAME(FP)
@ 23,26 SAY 'CURRENT RECORD: '+LTRIM(STR(RECNO(FP),7))
@ 23,50 SAY 'TOTAL RECORDS IN FILE: '+LTRIM(STR(LASTREC(FP),7))
&SAYNORMAL
RETURN | ************* END OF SHOWSTAT *********


***********
PROCEDURE SHOWCMD
* DISPLAYS THE COMMAND LINE
* CMD LINE IN X.CMD_LINE
***********
&SAYBRIGHT
@ 21,00 ESAY 'CMD: ' + X.CMD_LINE
&SAYNORMAL
RETURN	| ************* END OF SHOWCMD ***********


***********
PROCEDURE SHOWCMD1
* DISPLAYS THE COMMAND LINE
* CMD LINE IN X.CMD_LINE
* COMMAND BYTES REMAINING
***********
DO SHOWCMD
&SAYREVERSE
@ 05,00 ESAY RTJUST("Command Bytes Remaining "+ STR(75 - LEN(X.CMD_LINE),3),80)
&SAYNORMAL
RETURN	| ************* END OF SHOWCMD1 **********


***********
PROCEDURE SHOWMSG1
* SHOWS Y.MSG1_TEXT
***********
&SAYBLINK
@ 24,00 ESAY CENTER (Z.MSG1_TEXT,79)
&SAYNORMAL
RETURN


***********
PROCEDURE SHOWYESNO
* SHOWS Y.MSG1_TEXT
* AND GET YES OR NO ANSWER.
* 'NO' OR ESC RETURNS TO MAIN MENU.
***********
Y.MSG1_TEXT = Z.MSG1_TEXT
Y.VMENU_TEXT = 'YES|NO'
Y.VMENU_COL = 15
DO GETVMENU
IF VMENU() = 2 OR VMENU() = 0
  RETURN TO A
ENDIF
RETURN	| ************ END OF SHOWYESNO **************


***********
PROCEDURE SHOWERR
***********
BEEP
&SAYBRIGHT
if LEN(Z.ERR_TEXT) > 55
  @ 24,00 ESAY CENTER(Z.ERR_TEXT,78)
ELSE
  @ 24,00 ESAY CENTER(Z.ERR_TEXT+' Press any key to continue.',78)
ENDIF
WAIT
IF LASTKEY() = 27
  RETURN TO A
ENDIF
RETURN


*********
PROCEDURE GETREAD
* Z.MSG1_TEXT, Z.MSG2_TEXT
* Z.GET_TEXT
*********
@ 24,00
DO WHILE T
  &SAYBRIGHT
  ASSIGN BOX(11,20,20,60,201,187,200,188,186,205)
  @ 12,21 SAY SPACE(39)
  @ 13,21 SAY SPACE(39)
  @ 14,21 SAY SPACE(39)
  @ 15,21 SAY SPACE(39)
  @ 16,21 SAY SPACE(39)
  @ 17,21 SAY SPACE(39)
  @ 18,21 SAY SPACE(39)
  @ 19,21 SAY SPACE(39)
  @ 12,21 SAY CENTER(Z.MSG1_TEXT,39)
  &SAYNORMAL
  @ 13,21 SAY CENTER(Z.MSG2_TEXT,39)
  @ 15,21 SAY CENTER('Press Esc to abort',39)
  @ 17,23 GET &Z.GET_TEXT
  READ
  DO CASE
    CASE LASTKEY() = 27
      RETURN TO A
    CASE LASTKEY() = 196
      DO HELP
      LOOP
    OTHERWISE
      EXIT
  ENDCASE
ENDDO
RETURN	| ************* END OF GETREAD ************
