******************************************************** 
* Basic checkbook program                              *
* by Jim Hawley, 1450 SW 26th Court, Gresham Ore 97030 *
* demonstrates some of the abilities of dBMAN          *
* particularly the use of procedures                   *
********************************************************
SET TALK OFF
SET PUBLIC OFF
ERASE
@ 10,00 SAY CENTER("Loading Checkbook, Please Wait ....",80)
SET DELETED ON
SET PROCEDURE TO CHEKBOOK
STORE 1 TO ChekBook
STORE DATE() TO ChekDate
STORE "Return" TO CrSymbol
SELECT FJ
if not file("CHEKBOOK.NDX")
  use chekbook
  index on bookname to chekbook
else
  USE CHEKBOOK INDEX CHEKBOOK
endif
SELECT FK
if not file("CHECKS.NDX")
  use checks
  index on bookname to checks
else
  USE CHECKS INDEX CHECKS
endif
ERASE
DO CHEKFORM
DO WHILE T
  STORE HMENU("|","|Open Checkbook||Kill Checkbook||Exit CHEKBOOK",23,1,0,0,10)\40 TO MainOpt
  DO CASE
   CASE MainOpt = 0
     INC MainOpt
    CASE MainOpt = 2
      DO OPENBOOK
   CASE MainOpt = 4
     DO KILLBOOK
   CASE MainOpt = 6
     ERASE
     return
  ENDCASE
  @ 23,0
ENDDO
SET PROCEDURE TO
RETURN

PROCEDURE OPENBOOK
******************
DO BOOKLIST
STORE x.booklisk + "New Book" TO x.booklisk
STORE 1 TO ChekBook
@ 23,1 SAY CENTER("Select checkbook",78)
DO WHILE T
  STORE HMENU("|",x.booklisk,19,ChekBook,0,0,10)\40 TO ChekBook
  @ 19,0
  @ 20,0
  @ 21,0
  DO CASE
    CASE ChekBook = 0   
      INC ChekBook
      LOOP
    CASE ChekBook > TOKENS("|",x.booklisk)
      DO NEWBOOK
      IF TRIM(NewBook) = ""
        RETURN
      ENDIF
    OTHERWISE
      DO GOTOLAST 
  ENDCASE
  @ 23,0
  EXIT
ENDDO
DO SHOWBOOK
DO SHOWCHEK        
STORE J.NEXTCHEK TO ChekNumber
STORE 4 TO BookOpt
DO WHILE T
  STORE HMENU("|","|||Enter||Edit||List||Reconcile|||Close",23,BookOpt,0,0,5)\40 TO BookOpt
  DO CASE
    CASE BookOpt = 0
      STORE 4 TO BookOpt
      LOOP
    CASE BookOpt = 4
      DO CBENTER
    CASE BookOpt = 6
      DO CBEDIT
    CASE BookOpt = 8
      DO CBLIST
    CASE BookOpt = 10
      DO CBRECON
    CASE BookOpt = 13
      DO CLEARFRM
      EXIT
  ENDCASE      
  @ 23,0
ENDDO
RETURN

PROCEDURE NEWBOOK
*****************
STORE SPACE(8) TO NewBook
@ 23,1 ESAY " Enter new checkbook name or " + CrSymbol + " to abort " + CHR(16) + " " GET NewBook PICTURE "!!!!!!!!"
DO WHILE T
  READ
  IF TRIM(NewBook) = ""
    RETURN
  ELSE
    FIND FJ NewBook
    IF ERRCODE() = 0
      @ 23,1 ESAY TRIM(NewBook) + " already in use, re-enter or " + CrSymbol + " to abort " + CHR(16)
      STORE SPACE(8) TO NewBook
      @ ROW(),COL()+2 GET NewBook PICTURE "!!!!!!!!"
      LOOP
    ELSE
      APPEND FJ BLANK
      REPLACE FJ J.BOOKNAME WITH NewBook
      @  4, 4 GET J.NAME
      @  5, 4 GET J.JOINT
      @  6, 4 GET J.ADDRESS1
      @  7, 4 GET J.ADDRESS2
      @ 23, 1 SAY CENTER("Enter Checkbook identification",78)
      READ
      APPEND FK BLANK
      REPLACE FK K.BOOKNAME WITH NewBook, K.CATEGORY WITH "D", K.ENTRYDATE WITH {//}
      REPLACE FK K.PAIDTO WITH "B E G I N N I N G   B A L A N C E", K.CLEARED WITH Y
      @ 10,66 GET K.AMOUNT PICTURE "##,###.##"
      @ 23, 1 SAY CENTER("Enter amount of beginning balance",78)
      READ
      STORE 0 TO ChekNumber 
      @  4,70 GET ChekNumber PICTURE "#####"
      @ 23, 1 SAY CENTER("Enter beginning check number",78)
      READ
      REPLACE FJ J.NEXTCHEK WITH ChekNumber, J.BALANCE WITH K.AMOUNT
      EXIT
    ENDIF
  ENDIF
ENDDO
RETURN

        
PROCEDURE KILLBOOK
******************
DO BOOKLIST
STORE x.booklisk + "Abort" TO x.booklisk
STORE TOKENS("|",x.booklisk) + 1 TO ChekBook
@ 23,1 SAY CENTER("Select checkbook",78)
DO WHILE T
  STORE HMENU("|",x.booklisk,19,ChekBook,0,0,10)\40 TO ChekBook
  @ 19,0
  @ 20,0
  @ 21,0
  DO CASE
    CASE ChekBook = 0   
      STORE TOKENS("|",x.booklisk) + 1 TO x.booklisk
      LOOP
    CASE ChekBook = TOKENS("|",x.booklisk) + 1
      EXIT
    OTHERWISE
      @ 23,1 SAY CENTER("D E L E T I N G",78) 
      GOTO FJ TOP
      SKIP ChekBook -1
      FIND FK J.BOOKNAME
      DELETE FK WHILE K.BOOKNAME = J.BOOKNAME
      PACK
      DELETE FJ
      SELECT FJ
      PACK
      SELECT FK
      EXIT
  ENDCASE
ENDDO
RETURN

PROCEDURE CBENTER
*****************
DO WHILE T
  @ 23,1 ESAY " Enter " + CHR(16) + "  (C)heck  (D)eposit  (M)isc. charge  (E)dit  (Q)uit  " + CHR(16)
  STORE "?" TO Response
  DO WHILE NOT Response $ "CDMQE"
    @ 23,66 GET Response PICTURE "!"
    READ
  ENDDO
  DO CASE
    CASE Response = "Q"
      REPLACE FJ J.NEXTCHEK WITH ChekNumber
      RETURN
    CASE Response = "E"
      @ 23,66 SAY "EDIT"
      STORE K.ENTRYDATE TO ChekDate
      DO CASE
        CASE K.CATEGORY = "C"
          DO CHECK
        CASE K.CATEGORY = "D"
          DO DEPOSIT
        OTHERWISE
          DO CHARGE
      ENDCASE
      REPLACE K.ENTRYDATE WITH ChekDate
    OTHERWISE
      APPEND FK BLANK
      REPLACE FK K.BOOKNAME WITH J.BOOKNAME, K.CATEGORY WITH Response
      DO CASE
        CASE K.CATEGORY = "C"
          @ 23,66 SAY "CHECK"
          REPLACE FK K.NUMBER WITH ChekNumber
          DO CHECK
          INC ChekNumber
        CASE K.CATEGORY = "D"
          @ 23,66 SAY "DEPOSIT"
          REPLACE FK PAIDTO WITH "D E P O S I T"
          DO DEPOSIT
        OTHERWISE
          @ 23,66 SAY "MISC CHARGE"
          REPLACE FK K.PAIDTO WITH "M I S C   C H A R G E"
          DO CHARGE
      ENDCASE  
      REPLACE FK K.ENTRYDATE WITH ChekDate 
  ENDCASE
  DO SHOWCHEK
ENDDO

PROCEDURE CBEDIT
****************
@ 23,1 ESAY " Enter transaction date to edit or " + CrSymbol + " for all " + CHR(16)
DO WHILE T
  STORE {//} TO EditDate
  @ ROW(),COL()+2 GET EditDate
  READ
  IF EditDate = {//}
    FIND FK J.BOOKNAME
    EXIT
  ELSE
    FIND FK J.BOOKNAME + DTOK(EditDate)
    IF ERRCODE() = 0
      EXIT
    ELSE
      @ 23,1 ESAY " No " + DTOC(EditDate) + " transactions on file, re-enter or " + CrSymbol + " for all " + CHR(16)
    ENDIF
  ENDIF
ENDDO
DO WHILE T
  DO SHOWCHEK
  @ 23,1 ESAY " Enter " + CHR(16) + "  (P)revious  (N)ext  (E)dit  (Q)uit  " + CHR(16) 
  STORE "?" TO Response
  DO WHILE NOT Response $ "PNEQ"
    @ 23,50 GET Response PICTURE "!"
    READ
  ENDDO
  DO CASE
    CASE Response = "Q"
      RETURN
    CASE Response = "P"
      SKIP FK -1
      IF K.BOOKNAME <> J.BOOKNAME
        SKIP FJ 
        FIND FK J.BOOKNAME
        SKIP FK -1
        SKIP FJ -1
      ENDIF
    CASE Response = "N"
      SKIP FK
      IF K.BOOKNAME <> J.BOOKNAME
        FIND FK J.BOOKNAME
      ENDIF
    OTHERWISE
      @ ROW(),COL()-1 SAY "EDIT"
      STORE K.ENTRYDATE TO ChekDate
      DO CASE
        CASE K.NUMBER > 0
          DO CHECK
        CASE K.CATEGORY = "D"
          DO DEPOSIT
        OTHERWISE
          DO CHARGE
      ENDCASE
      REPLACE FK K.ENTRYDATE WITH ChekDate
  ENDCASE
ENDDO
RETURN

PROCEDURE CBLIST
****************
FIND FK J.BOOKNAME
DO WHILE K.BOOKNAME = J.BOOKNAME
  @ 23,0
  ASSIGN ROW(2)
  DO WHILE K.BOOKNAME = J.BOOKNAME AND ROW() < 17
    @ ROW()+1,2 SAY SPACE(76) 
    IF K.NUMBER > 0
      @ ROW(),4 SAY STR(K.NUMBER,5) + "  " + DTOC(K.ENTRYDATE) + "  " + K.PAIDTO + "  $ " 
    ELSE
      @ ROW(),4 SAY SPACE(7) + DTOC(K.ENTRYDATE) + "  " + K.PAIDTO + "  $ " 
    ENDIF
    @ ROW(),COL() SAY K.AMOUNT USING "##,###.##"
    IF K.CLEARED
      @ ROW(),COL()+1 SAY "*"
    ENDIF
    SKIP FK
  ENDDO
  IF K.BOOKNAME = J.BOOKNAME
    @ 23,1 SAY CENTER(CrSymbol + " to continue listing",78)
    SET CONSOLE OFF
    WAIT
    SET CONSOLE ON
  ELSE
    EXIT
  ENDIF
ENDDO
DO WHILE ROW() < 17
  @ ROW()+1,2 SAY SPACE(76)
ENDDO
@ 23,1 SAY CENTER("End of listing, " + CrSymbol + " to continue",78)
SET CONSOLE OFF
WAIT
SET CONSOLE ON
SKIP FK -1
DO CHEKFORM
DO SHOWBOOK
DO SHOWCHEK
RETURN

PROCEDURE CBRECON
*****************
STORE J.BALANCE TO Statement
FIND FK J.BOOKNAME
LOCATE FK FOR NOT CLEARED WHILE K.BOOKNAME = J.BOOKNAME
DO WHILE K.BOOKNAME = J.BOOKNAME
  DO SHOWCHEK
  @ 23,1 ESAY " Enter  " + CHR(16) + "  (C)lear  (S)kip  (F)inished  " + CHR(16)
  STORE "?" TO Response
  DO WHILE NOT Response $ "CSF"
    @ 23,44 GET Response PICTURE "!"
    READ
  ENDDO
  DO CASE
    CASE Response = "C"
      REPLACE FK CLEARED WITH Y
    CASE Response = "S"
      IF K.CATEGORY = "D"
        STORE Statement - K.AMOUNT TO Statement
      ELSE
        STORE Statement + K.AMOUNT TO Statement
      ENDIF
    OTHERWISE
      EXIT
  ENDCASE
  CONTINUE FK
ENDDO
DO WHILE K.BOOKNAME = J.BOOKNAME
  IF K.CATEGORY = "D"
    STORE Statement - K.AMOUNT TO Statement
  ELSE
    STORE Statement + K.AMOUNT TO Statement
  ENDIF
  CONTINUE FK
ENDDO
@ 20,24 ESAY "Statement balance : $ " - STR(Statement,8,2) 
STORE Y TO DoClear
@ 23, 1 ESAY " Delete cleared entries ? " GET DoClear
READ
IF DoClear
  @ 23,1 SAY CENTER("C L E A R I N G",78)
  DELETE FK ALL FOR K.BOOKNAME = J.BOOKNAME AND K.CLEARED
  PACK
  APPEND BLANK
  REPLACE FK K.BOOKNAME WITH J.BOOKNAME, K.CATEGORY WITH "D", K.AMOUNT WITH Statement
  REPLACE FK K.ENTRYDATE WITH {//}, K.PAIDTO WITH "B E G I N N I N G   B A L A N C E", K.CLEARED WITH Y
ENDIF
DO GOTOLAST
DO SHOWCHEK
RETURN

PROCEDURE CHECK
***************
REPLACE FJ J.BALANCE WITH J.BALANCE + K.AMOUNT
@  4,70 SAY K.NUMBER USING "#####"
@  6,55 GET ChekDate
@ 10,17 GET K.PAIDTO
@ 10,66 GET K.AMOUNT PICTURE "##,###.##"
@ 13, 6 SAY SPACE(59)
@ 16,11 GET K.MEMO
@ 16,69 SAY SPACE(7)
READ
REPLACE FJ J.BALANCE WITH J.BALANCE - K.AMOUNT
RETURN

PROCEDURE DEPOSIT
*****************
REPLACE FJ J.BALANCE WITH J.BALANCE - K.AMOUNT
@  4,70 SAY SPACE(5)
@  6,55 GET ChekDate
@ 10,17 SAY K.PAIDTO
@ 10,66 GET K.AMOUNT PICTURE "##,###.##"
@ 13, 6 SAY SPACE(59)
@ 16,11 GET K.MEMO
@ 16,69 SAY SPACE(7)
READ
REPLACE FJ J.BALANCE WITH J.BALANCE + K.AMOUNT 
RETURN

PROCEDURE CHARGE
****************
REPLACE FJ J.BALANCE WITH J.BALANCE + K.AMOUNT
@  4,70 SAY SPACE(5)
@  6,55 GET ChekDate
@ 10,17 SAY K.PAIDTO
@ 10,66 GET K.AMOUNT PICTURE "##,###.##"
@ 13, 6 SAY SPACE(59)
@ 16,11 GET K.MEMO
@ 16,69 SAY SPACE(7)
READ
REPLACE FJ J.BALANCE WITH J.BALANCE - K.AMOUNT 
RETURN

PROCEDURE CHEKFORM
******************
@  2,1 SAY ".............................................................................."
@  3,1 SAY ".                                                                  ......... ."
@  4,1 SAY ".                                                                  .       . ."
@  5,1 SAY ".                                                   ............   ......... ."
@  6,1 SAY ".                                                   .   /  /   .             ."
@  7,1 SAY ".                                                   ............             ."
@  8,1 SAY ".                                                                            ."
@  9,1 SAY ".  pay to the ..............................................   ............. ."
@ 10,1 SAY ".  Order of   .                                            . $ .           . ."
@ 11,1 SAY ".             ..............................................   ............. ."
@ 12,1 SAY ".  ...............................................................           ."
@ 13,1 SAY ".  .                                                             .  Dollars  ."
@ 14,1 SAY ".  ...............................................................           ."
@ 15,1 SAY ".       ..........................................................           ."
@ 16,1 SAY ".  Memo .                                                        .           ."
@ 17,1 SAY ".       ..........................................................           ."
@ 18,1 SAY ".............................................................................."
@ 22,1 SAY DUPCHAR(46,78)
@ 24,1 SAY DUPCHAR(46,78)
RETURN

PROCEDURE CLEARFRM
******************
@  4, 3 SAY SPACE(40)
@  4,70 SAY SPACE(5)
@  5, 3 SAY SPACE(40)
@  6, 3 SAY SPACE(40)
@  6,55 SAY {//}
@  7, 3 SAY SPACE(40)
@ 10,17 SAY SPACE(42)
@ 10,66 SAY SPACE(9)
@ 13, 6 SAY SPACE(59)
@ 16,11 SAY SPACE(54)
@ 16,69 SAY SPACE(7)
@ 20, 0
@ 23 ,0
RETURN

PROCEDURE BOOKLIST
******************
GOTO FJ TOP
STORE "" TO x.booklisk
DO WHILE NOT EOF(FJ)
  STORE x.booklisk + J.BOOKNAME + "|" TO x.booklisk
  SKIP FJ
ENDDO
RETURN

PROCEDURE SHOWBOOK
******************
@  4, 3 SAY CENTER(J.NAME,40)
@  5, 3 SAY CENTER(J.JOINT,40)
@  6, 3 SAY CENTER(J.ADDRESS1,40)
@  7, 3 SAY CENTER(J.ADDRESS2,40)
RETURN

PROCEDURE GOTOLAST
******************
GOTO FJ TOP
SKIP FJ (ChekBook)
FIND FK J.BOOKNAME
SKIP FJ -1
SKIP FK -1
STORE K.ENTRYDATE TO ChekDate
RETURN

PROCEDURE SHOWCHEK
******************
IF K.NUMBER > 0
  @ 4,70 SAY K.NUMBER USING "#####"
ELSE
  @ 4,70 SAY SPACE(5)
ENDIF    
@  6,55 SAY K.ENTRYDATE
@ 10,17 SAY K.PAIDTO
@ 10,66 SAY K.AMOUNT USING "##,###.##"
@ 13, 6 SAY SPACE(59)
@ 13, 6 SAY TONAME(TOMONEY(K.AMOUNT,"& ","/100"))
@ 16,11 SAY K.MEMO
IF K.CLEARED
  @ 16,69 SAY "CLEARED"
ELSE
  @ 16,69 SAY SPACE(7)
ENDIF
@ 20,24 SAY "Checkbook balance : $ " - STR(J.BALANCE,8,2)
RETURN
