/* aesutil.c - AES utility functions
 * FontForm, Copyright (c) 1990, Atari Corporation
 * ======================================================================
 * 901219 kbad	Use AES version for Fsel...functions, final sweep.
 * 901202 kbad	Cleanup
 * 901126 kbad	From AESALT library
 */

#if LATTICE
#include <osbind.h>
#include <string.h>
#include <vdi.h>
#include <aes.h>
#define AESversion _AESglobal[0]
#endif

#if __TURBOC__
#include <tos.h>
#include <string.h>
#include <vdi.h>
#include <aes.h>
#define AESversion _GemParBlk.global[0]
#endif

#if MWC
#include <osbind.h>
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
char *strrchr();
char *strchr();
#define graf_movebox graf_mbox

#include "portab.h"

EXTERN WORD	global[15];
#define AESversion global[0]

#define FSEL_EXINPUT	91
EXTERN char	ctrl_cnts[115][3];
EXTERN int	int_out[];
EXTERN long	addr_in[];
EXTERN VOID	crys_if();
#endif

#if __GNUC__
#include <string.h>
#include <osbind.h>
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
EXTERN WORD	global[15];
#define AESversion global[0]
#endif

#include "portab.h"
#include "aesutil.h"


#define FNSIZE 13   /* maximum file name size */
#define PNSIZE 128  /* maximum path name size */

/* Global variables (initialized by FselInit)
 * ----------------------------------------------------------------------
 */
GLOBAL BYTE	bootdev = -1;

/* Local variables & functions
 * ----------------------------------------------------------------------
 */
MLOCAL char	save_path[PNSIZE];
MLOCAL char	wildext[] = ".*";

MLOCAL VOID	FselInit( VOID );
MLOCAL long	init_fsvars( VOID );


/* AESUTIL functions
 * ======================================================================
 */

/*
 * Form functions .......................................................
 */

/* ----------------------------------------------------------------------
 * Initialize a form, and optionally draw it
 * rstart -> small rectangle for the zoombox, or NULL
 */
GLOBAL VOID	FormInit( tree, rstart, drawit )
OBJECT		*tree;
GRECT		*rstart;
BOOLEAN		drawit;
{
    GRECT	r, r0;

    form_center( tree, &r.g_x, &r.g_y, &r.g_w, &r.g_h );
    ObX(ROOT) = r.g_x + (r.g_w-ObW(ROOT))/2;
    ObY(ROOT) = r.g_y + (r.g_h-ObH(ROOT))/2;

    if( rstart )
	r0 = *rstart;
    else
	RectCenter( &r, r.g_w/2-1, r.g_h/2-1, &r0 );

    form_dial( FMD_START, r0.g_x, r0.g_y, r0.g_w, r0.g_h,
		r.g_x, r.g_y, r.g_w, r.g_h );
    form_dial( FMD_GROW, r0.g_x, r0.g_y, r0.g_w, r0.g_h,
		r.g_x, r.g_y, r.g_w, r.g_h );

    if( drawit )
	ObjcDraw( tree, ROOT, MAX_DEPTH, NULL );
}

/* ----------------------------------------------------------------------
 * Clean up after a form
 * rstart -> small rectangle for the zoombox, or NULL
 */
GLOBAL VOID	FormExit( tree, rstart )
OBJECT		*tree;
GRECT		*rstart;
{
    GRECT	r, r0;

    ObjcExtent( tree, ROOT, &r );

    if( rstart )
	r0 = *rstart;
    else
	RectCenter( &r, r.g_w/2-1, r.g_h/2-1, &r0 );

    form_dial( FMD_SHRINK, r0.g_x, r0.g_y, r0.g_w, r0.g_h,
		r.g_x, r.g_y, r.g_w, r.g_h );
    form_dial( FMD_FINISH, r0.g_x, r0.g_y, r0.g_w, r0.g_h,
		r.g_x, r.g_y, r.g_w, r.g_h );
}


/*
 * File selector functions ..............................................
 */

#if MWC
/* ----------------------------------------------------------------------
 * fsel_exinput binding for MWC
 */
MLOCAL WORD	fsel_exinput( path, file, button, label )
char		*path, *file;
WORD		*button;
const char	*label;
{
    register int *i = int_out;
    register long *a = addr_in;

    if( AESversion <= 0x0140 )
	return fsel_input( path, file, button );

    *a++ = (long)path;
    *a++ = (long)file;
    *a	 = (long)label;

    crys_if( FSEL_EXINPUT );
    *button = i[1];
    return i[0];
}
#endif

/* ----------------------------------------------------------------------
 * Get system variables used by FselName, called in supervisor mode.
 */
MLOCAL long	init_fsvars( VOID )
{
    bootdev = (BYTE)(*(UWORD *)0x446) + 'A';
    return 0;
}

/* ----------------------------------------------------------------------
 * Initialize variables used by FselName.
 */
MLOCAL VOID	FselInit( VOID )
{
    Supexec( init_fsvars );
    save_path[0] = (char)Dgetdrv() + 'A';
    save_path[1] = ':';
    Dgetpath( &save_path[2], 0 );

#if MWC
    if( AESversion >= 0x0140 )
    {
	/* patch ctrl_cnts array */
	register char *c = ctrl_cnts[FSEL_EXINPUT-10];
	*c++ = 0;
	*c++ = 2;
	*c   = 3;
    }
#endif
}

/* ----------------------------------------------------------------------
 * Handle file and/or path selection via fsel_(ex)input.
 */
GLOBAL WORD	FselName( remember, name, searchmask, label )
BOOLEAN		remember;
char		*name;
const char	*searchmask;
const char	*label;
{
    char	path[PNSIZE], file[FNSIZE];
    char	*p_path, *p_ext;
    WORD	button, ret;

    if( bootdev == -1 )
	FselInit();

    if( name[0] )
    {
	/*
	 * Copy the supplied path\filename into local arrays.
	 * If no trailing '\', assume only filename passed in,
	 *   and use saved path.
	 */
	if( (p_path = strrchr(name, '\\')) != NULL)
	{
	    *p_path++ = '\0';
	    strcpy( path, name );
	}
	else
	{
	    strcpy( path, save_path );
	    p_path = path;
	}
	strcpy( file, p_path );
	p_path = strchr( file, '.' );
	if( p_path == NULL )
	    p_path = wildext;

    } else {
	/*
	 * No pathname supplied, use the saved path
	 */
	strcpy( path, save_path );
	file[0] = '\0';
	p_path = wildext;
    }
    strcat( path, "\\" );

    /*
     * Add search mask extender.  At this point p_path points to
     * either the extender of the supplied filename or `wildext'.
     * If no searchmask, is provided, use whatever p_path points to.
     */
    if( searchmask != NULL )
    {
	strcat( path, searchmask );
    }
    else
    {
	strcat( path, &wildext[1] );
	strcat( path, p_path );
    }

    /*
     * Finally... make the fsel_input call.
     * The AES version check is not needed for Lattice, because
     * their binding for fsel_exinput works on all TOS versions.
     * Likewise for the MWC binding above.
     */
#if LATTICE || MWC
    if( label == NULL )
	ret = fsel_input( path, file, &button );
    else
	ret = fsel_exinput( path, file, &button, label );

#else
    if( (label == NULL) || (AESversion < 0x0140) )
	ret = fsel_input( path, file, &button );
    else
	ret = fsel_exinput( path, file, &button, (char *)label );
#endif

    if( ret <= 0 || (ret = button) == 0 )
    {
	name[0] = '\0';
    }
    else
    {
	/*
	 * Copy the path\filename into the caller's variable.
	 */
	p_path = strrchr( path, '\\' );
	*p_path = '\0';
	strcpy( name, path );
	strcat( name, "\\" );
	strcat( name, file );

	/*
	 * Auto-append the search mask
	 */
	p_path = strrchr( name, '\\' );
	p_ext = strrchr( name, '.' );
	if( searchmask && (p_ext < p_path) )
	{
	    p_ext = strrchr( searchmask, '.' );
	    if( p_ext )
		strcat( name, p_ext );
	}

    /* and remember the path the user selected */
	if( remember )
	    strcpy( save_path, path );

    /* if no file, return FAILURE (so path can be returned) */
	if( !file[0] )
	    ret = FAILURE;
    }
    return ret;
}


/*
 * Graphics functions ..................................................
 */

/* ----------------------------------------------------------------------
 * Alternate binding for graf_mkstate using a struct * vice 4 WORD *'s.
 * In a real AES utility library, this would be made compiler dependent
 * and efficient.  In this program, it's here for my convenience.
 */
GLOBAL VOID	GrafMKState( m )
MoInfo		*m;
{
    graf_mkstate( &m->x, &m->y, &m->buttons, &m->keys );
}

/* ----------------------------------------------------------------------
 * Alternate binding for graf_m(ove)box, using a GRECT * and end x/y.
 * In a real AES utility library, this would be made compiler dependent
 * and efficient.  In this program, it's here for my convenience.
 */
GLOBAL VOID	GrafMovebox( box, endx, endy )
const GRECT	*box;
WORD		endx, endy;
{
    graf_movebox( box->g_w, box->g_h, box->g_x, box->g_y, endx, endy );
}

/* ----------------------------------------------------------------------
 * graf_shrinkbox/growbox combo.
 */
GLOBAL VOID	GrafZoombox( r1, r2 )
const GRECT		*r1, *r2;
{
    if( (r1->g_w > r2->g_w) || (r1->g_h > r2->g_h) )
	graf_shrinkbox( r2->g_x, r2->g_y, r2->g_w, r2->g_h,
			r1->g_x, r1->g_y, r1->g_w, r1->g_h );
    else
	graf_growbox( r1->g_x, r1->g_y, r1->g_w, r1->g_h,
		      r2->g_x, r2->g_y, r2->g_w, r2->g_h );
}


/*
 * Object functions .....................................................
 */

/* ----------------------------------------------------------------------
 * Get the rectangle of an object in screen coordinates.
 * DESTINATION RECT MUST NOT BE THE OBJECT'S GRECT!!!
 * Unless you really do want to screw up your object tree.
 */
GLOBAL VOID	ObjcRect( tree, obj, r )
OBJECT		*tree;
WORD		obj;
GRECT		*r;
{
    objc_offset( tree, obj, &r->g_x, &r->g_y );
    *(long *)&r->g_w = *(long *)&ObW(obj);
}

/* ----------------------------------------------------------------------
 * Get the full extent of an object, including border, outline, and/or
 * shadow.  Use to calculate clip rectangles for objc_draw.
 */
GLOBAL VOID	ObjcExtent( tree, obj, r )
OBJECT		*tree;
WORD		obj;
GRECT		*r;
{
    WORD	offset, border;
    VOIDP	pspec;

    /*
     * Get the basic screen extent of the object.
     */
    ObjcRect( tree, obj, r );


    /*
     * Calculate offsets due to border and/or outline,
     * making sure to get actual ob_spec for indirect objects.
     * `pspec' gets the ADDRESS of the ob_spec, regardless.
     */
    if( IsIndirect(obj) )
	pspec = (VOIDP)ObSpec(obj);
    else
	pspec = (VOIDP)&ObSpec(obj);

    if( IsTed(obj) )
	border = (*(TEDINFO **)pspec)->te_thickness;
    else
	border = ((ObInfo *)pspec)->border;

    if( border >= 0 )	/* interior or no border */
	offset = 0;
    else		/* outside border */
	offset = border, border = -border;

    if( IsOutlined(obj) && offset > -3 )
	offset = -3;

    /*
     * Center the rectangle outside itself, then
     * add the shadow extent if needed.
     */
    if( offset )
	RectCenter( r, offset, offset, r );

    if( IsShadowed(obj) && border )
	r->g_w += 2 * border, r->g_h += 2 * border;
}    

/* ----------------------------------------------------------------------
 * Alternate objc_draw binding which will calculate a clip rectangle
 * if passed a NULL pointer in `clip'.
 */
GLOBAL VOID	ObjcDraw( tree, obj, depth, clip )
OBJECT		*tree;
WORD		obj, depth;
GRECT		*clip;
{
    GRECT	r;

    if( !clip )
	ObjcExtent( tree, obj, (clip = &r) );

    objc_draw( tree, obj, depth, clip->g_x, clip->g_y, clip->g_w, clip->g_h );
}


/*
 * Rectangle functions ..................................................
 */

#if __TURBOC__ || __GNUC__
short min( short a, short b ) { if (a < b) return a; else return b; }
short max( short a, short b ) { if (a > b) return a; else return b; }
#endif

/* ----------------------------------------------------------------------
 * Inset a rectangle by xoffset, yoffset (affects g_w, g_h).
 */
GLOBAL VOID	RectInset( xoffset, yoffset, r )
WORD		xoffset, yoffset;
GRECT		*r;
{
    r->g_w -= xoffset;
    r->g_h -= yoffset;
}

/* ----------------------------------------------------------------------
 * If rs and rd intersect, change rd to the intersection and return TRUE.
 * Otherwise, leave rd alone and return FALSE.
 */
GLOBAL BOOLEAN	RectIntersect( rs, rd )
const GRECT	*rs;
GRECT		*rd;
{
    WORD	tx, ty, tw, th;
    BOOLEAN	ret;

    tx = (WORD)max( rd->g_x, rs->g_x );
    ty = (WORD)max( rd->g_y, rs->g_y );
    tw = (WORD)min( rd->g_x + rd->g_w, rs->g_x + rs->g_w );
    th = (WORD)min( rd->g_y + rd->g_h, rs->g_y + rs->g_h );
    /*
     * WARNING!  Psychotic if statement ahead!
     */
    if( ((ret = ((tw -= tx) > 0)) != FALSE )
    &&  ((ret = ((th -= ty) > 0)) != FALSE ) )
	rd->g_x = tx, rd->g_y = ty, rd->g_w = tw, rd->g_h = th;

    return ret;
}

/* ----------------------------------------------------------------------
 * Offset a rectangle by xoffset, yoffset (affects g_x, g_y).
 */
GLOBAL VOID	RectOffset( xoffset, yoffset, r )
WORD		xoffset, yoffset;
GRECT		*r;
{
    r->g_x += xoffset;
    r->g_y += yoffset;
}

/* ----------------------------------------------------------------------
 * Center destination rectangle within (or outside, for negative offsets)
 * source rectangle.
 */
GLOBAL VOID	RectCenter( rs, xoffset, yoffset, rd )
GRECT		*rs;
WORD		xoffset, yoffset;
GRECT		*rd;
{
    *rd = *rs;
    /*
     * The casts are here so that the expressions are properly passed
     * if promoted to type `int' when compiling with 32-bit integers.
     */
    RectInset( (WORD)(xoffset*2), (WORD)(yoffset*2), rd );
    RectOffset( xoffset, yoffset, rd );
}

/* ----------------------------------------------------------------------
 * Convert GRECT to vdi x,y array.
 */
GLOBAL VOID	Rect2xy( r, pxy )
GRECT		*r;
WORD		*pxy;
{
    *(GRECT *)pxy = *r;
    pxy[2] += pxy[0] - 1;
    pxy[3] += pxy[1] - 1;
}

/* ----------------------------------------------------------------------
 * Blit from one section of the screen to another.
 */
GLOBAL VOID	RectBlit( clip, rs, rd )
GRECT		*clip, *rs, *rd;
{
    WORD	physid, pxy[8], clipxy[4];

#if __TURBOC__
MLOCAL MFDB	mfdb0;
#else
MLOCAL FDB	mfdb0;
#endif

    /*
     * Use physical workstation handle for the blit.
     *
     * Normally, one wouldn't use a physical handle for such a thing.
     * In this case, I'm only blitting, so it doesn't affect any
     * workstation attributes except clipping.  I don't want to use
     * the application's virtual workstation handle because this is
     * a library function.  I suppose I could have passed in the
     * workstation handle, but I didn't code it that way when I wrote
     * my AES utility library some time ago, so, WYSIWYG.
     */
    physid = graf_handle( pxy, pxy, pxy, pxy );

    Rect2xy( clip, clipxy );
    Rect2xy( rs, pxy );
    Rect2xy( rd, &pxy[4] );

    v_hide_c( physid );
    vs_clip( physid, 1, clipxy );
    vro_cpyfm( physid, 3, pxy, &mfdb0, &mfdb0 );
    vs_clip( physid, 0, clipxy );
    v_show_c( physid, TRUE );
}
