/* aesutil.h - AES utility functions.
 * FontForm, Copyright (c) 1990, Atari Corporation
 * ======================================================================
 * 901219 kbad	Final sweep
 * 901202 kbad	Cleanup
 * 901126 kbad	From AESALT library
 *
 * NOTES:
 * *	This file requires AES.H and PORTAB.H.
 * *	To make this file work with Turbo C, change the type definition of
 *	OBSPEC in TC's AES.H to `typedef void *OBSPEC;'
 */

#ifndef AESUTIL_H
#define AESUTIL_H

/*
 * NIL is not defined in some compilers' AES include files.
 * I use ObNIL (defined later on) instead.
 */
#ifndef NIL
#define NIL -1
#endif

/*
 * GrafMouse cursors.  The HOURGLASS is dead, long live the BUSYBEE.
 */
enum MoCursors
{
	MoARROW = 0,
	MoTEXT,
	MoBUSYBEE,
	MoPOINTHAND,
	MoFLATHAND,
	MoTHINCROSS,
	MoTHICKCROSS,
	MoOUTLINECROSS,
	MoUSERDEF = 255,
	MoOFF,
	MoON
};


/*
 * Point(less?) structure
 */
typedef struct sPoint
{
	WORD    x, y;
} Point;

/*
 * Mouse Info struct for mouse parameters returned by GrafMKState,
 * EvntButton, EvntMouse, EvntMulti (of which only GrafMKState is here).
 */
typedef struct
{
	WORD	x, y;
	WORD	buttons;
	WORD	keys;
} MoInfo;

/*
 * Mouse Block struct for parameters to EvntMouse and EvntMulti
 */
typedef struct sMoBlock
{
	BOOLEAN exiting;
	GRECT	r;
} MoBlock;

/* evnt_multi message buffer definitions
 * ----------------------------------------------------------------------
 */
#define MsgId(msg)	((msg)[0])	/* MN_SELECTED, WM_REDRAW, etc. */
#define MsgSender(msg)	((msg)[1])	/* apid of message sender	*/
#define MsgExtra(msg)	((msg)[2])	/* extra bytes in the pipe	*/

#define MenTitle(msg)	((msg)[3])	/* for MN_SELECTED		*/
#define MenItem(msg)	((msg)[4])	/* for MN_SELECTED		*/

#define WinId(msg)	((msg)[3])	/* for all WM_ messages		*/
#define WinRect(msg)	(*(GRECT *)(&(msg)[4]))
					/* WM_REDRAW, WM_SIZED, WM_MOVED*/
#define WinAction(msg)	((msg)[4])	/* for WM_ARROWED, contains	*/
					/* WA_ number			*/
#define WinSlider(msg)	((msg)[4])	/* WM_HSLID, WM_VSLID		*/

#define AccOpenid(msg)	((msg)[4])	/* AC_OPEN			*/
#define AccCloseid(msg)	((msg)[3])	/* AC_CLOSE			*/
#define CtlKey(msg)	((msg)[3])	/* XControl CT_KEY		*/



/* Structures for getting at object color information
 * ----------------------------------------------------------------------
 * NOTE:
 *	These bitfield structures depend on bitfield ordering!
 *	If the structure access macros are used, minimum size restrictions
 *	shouldn't matter.  q.v. HIBIT_1ST definition in PORTAB.H
 */

typedef struct sColorword
{
#if HIBIT_1ST
	unsigned cborder : 4;
	unsigned ctext   : 4;
	unsigned replace : 1;
	unsigned pattern : 3;
	unsigned cfill   : 4;
#else
	unsigned cfill   : 4;
	unsigned pattern : 3;
	unsigned replace : 1;
	unsigned ctext   : 4;
	unsigned cborder : 4;
#endif
} Colorword;

typedef struct sObInfo
{
	char	    letter;
	BYTE	    border;
	Colorword   c;
} ObInfo;

typedef struct sIconInfo
{
#if HIBIT_1ST
	unsigned fcolor : 4;
	unsigned bcolor : 4;
	unsigned letter : 8;
#else
	unsigned letter : 8;
	unsigned bcolor : 4;
	unsigned fcolor : 4;
#endif
} IconInfo;


/* Object constant definitions
 * ----------------------------------------------------------------------
 * A lot of these object definitions are only marginally different than
 * their OBDEFS predecessors.  Frankly, I got tired of running into
 * symbol clashes with defines like ROOT and IBM and SMALL and other
 * OBDEFS defines.  What I've done is classify the definitions in a
 * (hopefully) logical manner, prepending the "kind" of definition to the
 * old-style definition.  Another advantage to these defines is that
 * they'll work directly with languages that don't support underscores
 * in identifiers, which is a goal I'm working towards.
 */
#define ObNIL		-1	/* not an object */
#define ObROOT		0	/* root object of tree */
#define ObMAXLEN	81	/* max string length for text fields */
#define ObMAXDEPTH	8	/* max depth of find or draw */

/* Object types */
typedef WORD ObType;
enum ObTypes
{
	ObBOX = 20,
	ObTEXT,
	ObBOXTEXT,
	ObIMAGE,
	ObUSERDEF,
	ObIBOX,
	ObBUTTON,
	ObBOXCHAR,
	ObSTRING,
	ObFTEXT,
	ObFBOXTEXT,
	ObICON,
	ObTITLE
};

/* Object flags */
typedef UWORD ObFlags;
#define ObNONE		0x000U
#define ObSELECTABLE	0x001U
#define ObDEFAULT	0x002U
#define ObEXIT		0x004U
#define ObEDITABLE	0x008U
#define ObRADIO 	0x010U
#define ObLASTOB	0x020U
#define ObTOUCHEXIT	0x040U
#define ObHIDETREE	0x080U
#define ObINDIRECT	0x100U

/* Object States */
typedef UWORD ObState;
#define ObNORMAL	0x00U
#define ObSELECTED	0x01U
#define ObCROSSED	0x02U
#define ObCHECKED	0x04U
#define ObDISABLED	0x08U
#define ObOUTLINED	0x10U
#define ObSHADOWED	0x20U

/* Object Colors */
typedef WORD ObColor;
enum ObColors
{
	ObWHITE = 0,
	ObBLACK,
	ObRED,
	ObGREEN,
	ObBLUE,
	ObCYAN,
	ObYELLOW,
	ObMAGENTA,
	ObLGRAY,
	ObGRAY,
	ObLRED,
	ObLGREEN,
	ObLBLUE,
	ObLCYAN,
	ObLYELLOW,
	ObLMAGENTA
};

/* TEDINFO fonts */
#define TeSYSTEMFONT	3
#define TeSMALLFONT	5

/* TEDINFO justifications */
typedef WORD TeJust;
enum TeJusts
{
	TeLEFT = 0,
	TeRIGHT,
	TeCENTER
};

/* Object structure access macros
 * ----------------------------------------------------------------------
 * NOTE: These macros require an in-scope OBJECT *tree declaration.
 */
#define ObNext(obj)	( tree[(obj)].ob_next )
#define ObHead(obj)	( tree[(obj)].ob_head )
#define ObTail(obj)	( tree[(obj)].ob_tail )
#define ObType(obj)	( tree[(obj)].ob_type )
#define ObFlags(obj)	( tree[(obj)].ob_flags )
#define ObState(obj)	( tree[(obj)].ob_state )
#define ObSpec(obj)	( tree[(obj)].ob_spec )

/* ObSpecs for ObBOX, ObIBOX, ObBOXCHAR */
#define ObChar(obj)	( (*(ObInfo *)&ObSpec(obj)).letter )
#define ObBorder(obj)	( (*(ObInfo *)&ObSpec(obj)).border )
#define ObCBorder(obj)	( (*(ObInfo *)&ObSpec(obj)).c.cborder )
#define ObCText(obj)	( (*(ObInfo *)&ObSpec(obj)).c.ctext )
#define ObReplace(obj)	( (*(ObInfo *)&ObSpec(obj)).c.replace )
#define ObPattern(obj)	( (*(ObInfo *)&ObSpec(obj)).c.pattern )
#define ObCFill(obj)	( (*(ObInfo *)&ObSpec(obj)).c.cfill )

/* TEDINFO access macros, for ObTEXT, ObBOXTEXT, ObFTEXT, ObFBOXTEXT */
#define PTedinfo(obj)	( (TEDINFO *)ObSpec(obj) )
#define TedText(obj)	( PTedinfo(obj)->te_ptext )
#define TedTemplate(obj)( PTedinfo(obj)->te_ptmplt )
#define TedValid(obj)	( PTedinfo(obj)->te_pvalid )
#define TedFont(obj)	( PTedinfo(obj)->te_font )
#define TedJust(obj)	( PTedinfo(obj)->te_just )
#define TedCBorder(obj) ( (*(Colorword *)&PTedinfo(obj)->te_color).cborder )
#define TedCText(obj)	( (*(Colorword *)&PTedinfo(obj)->te_color).ctext )
#define TedReplace(obj) ( (*(Colorword *)&PTedinfo(obj)->te_color).replace )
#define TedPattern(obj) ( (*(Colorword *)&PTedinfo(obj)->te_color).pattern )
#define TedCFill(obj)	( (*(Colorword *)&PTedinfo(obj)->te_color).cfill )
#define TedBorder(obj)	( PTedinfo(obj)->te_thickness )
#define TedLen(obj)	( PTedinfo(obj)->te_txtlen )
#define TedTempLen(obj) ( PTedinfo(obj)->te_tmplen )

/* ICONBLK access for ObICON */
#define PIconblock(obj) ( (ICONBLK *)ObSpec(obj) )
#define IconMask(obj)	( PIconblock(obj)->ib_pmask )
#define IconData(obj)	( PIconblock(obj)->ib_pdata )
#define IconText(obj)	( PIconblock(obj)->ib_ptext )
#define IconFColor(obj) ( (*(IconInfo *)&PIconblock(obj)->ib_char).fcolor )
#define IconBColor(obj) ( (*(IconInfo *)&PIconblock(obj)->ib_char).bcolor )
#define IconChar(obj)	( (*(IconInfo *)&PIconblock(obj)->ib_char).letter )
#define IconXYChar(obj) ( *(Point *)&PIconblock(obj)->ib_xchar )
#define IconRect(obj)	( *(GRECT *)&PIconblock(obj)->ib_xicon )
#define IconTRect(obj)	( *(GRECT *)&PIconblock(obj)->ib_xtext )

/* BITBLK access for ObIMAGE */
#define PBitblock(obj)	( (BITBLK *)ObSpec(obj) )
#define ImageData(obj)	( PBitblock(obj)->bi_pdata )
#define ImageWb(obj)	( PBitblock(obj)->bi_wb )
#define ImageH(obj)	( PBitblock(obj)->bi_hl )
#define ImageXY(obj)	( *(Point *)&PBitblock(obj)->bi_x )
#define ImageColor(obj) ( PBitblock(obj)->bi_color )

/* String access for ObBUTTON, ObSTRING, ObTITLE */
#define ObString(obj)	( (char *)ObSpec(obj) )

/* Object extents */
#define ObX(obj)	( tree[(obj)].ob_x )
#define ObY(obj)	( tree[(obj)].ob_y )
#define ObXY(obj)	( *(Point *)&tree[(obj)].ob_x )
#define ObW(obj)	( tree[(obj)].ob_width )
#define ObH(obj)	( tree[(obj)].ob_height )
#define ObRect(obj)	( *(GRECT *)&tree[(obj)].ob_x )

/*
 * Object manipulation macros
 * ----------------------------------------------------------------------
 */

/*
 * rsrc_gaddr macros, take an object index and the address of a pointer
 */
#define GetTree(n,ptree)	( rsrc_gaddr(R_TREE,(n),(VOIDP)(ptree)) )
#define GetString(n,pchar)	( rsrc_gaddr(R_STRING,(n),(VOIDP)(pchar)) )
#define GetAlert(n,pchar)	GetString(n,pchar)
#define GetButton(n,pchar)	GetString(n,pchar)
#define GetImage(n,pUWORD)	( rsrc_gaddr(R_IMAGEDATA,(n),(VOIDP)(pUWORD)) )

/*
 * Object flags & states macros
 */
#define IsSelectable(obj)	( ObFlags(obj) & ObSELECTABLE )
#define IsDefault(obj)		( ObFlags(obj) & ObDEFAULT )
#define IsExit(obj)		( ObFlags(obj) & ObEXIT )
#define IsEditable(obj)		( ObFlags(obj) & ObEDITABLE )
#define IsRadio(obj)		( ObFlags(obj) & ObRADIO )
#define IsRButton(obj)		IsRadio(obj)
#define IsLast(obj)		( ObFlags(obj) & ObLASTOB )
#define IsLastob(obj)		IsLast(obj)
#define IsTouchexit(obj)	( ObFlags(obj) & ObTOUCHEXIT )
#define IsHidden(obj)		( ObFlags(obj) & ObHIDETREE )
#define IsVisible(obj)		( !IsHidden(obj) )
#define IsIndirect(obj)		( ObFlags(obj) & ObINDIRECT )

#define IsSelected(obj)		( ObState(obj) & ObSELECTED )
#define IsCrossed(obj)		( ObState(obj) & ObCROSSED )
#define IsChecked(obj)		( ObState(obj) & ObCHECKED )
#define IsDisabled(obj)		( ObState(obj) & ObDISABLED )
#define IsEnabled(obj)		( !IsDisabled(obj) )
#define IsOutlined(obj)		( ObState(obj) & ObOUTLINED )
#define IsShadowed(obj)		( ObState(obj) & ObSHADOWED )
#define IsTed(obj)		( (ObType(obj) == ObTEXT)   || \
				  (ObType(obj) == ObBOXTEXT)|| \
				  (ObType(obj) == ObFTEXT)  || \
				  (ObType(obj) == ObFBOXTEXT) )

/*
 * Object flags & states manipulation macros.
 *
 * NOTE: These do not affect the visual appearance of the object;
 *	 state changes will be reflected the next time it is drawn.
 */
#define MakeSelectable(obj)	( ObFlags(obj) |= ObSELECTABLE )
#define MakeDefault(obj)	( ObFlags(obj) |= ObDEFAULT )
#define MakeExit(obj)		( ObFlags(obj) |= ObEXIT )
#define MakeEditable(obj)	( ObFlags(obj) |= ObEDITABLE )
#define MakeRadio(obj)		( ObFlags(obj) |= ObRADIO )
#define MakeRButton(obj)	MakeRadio(obj)
#define MakeLast(obj)		( ObFlags(obj) |= ObLASTOB )
#define MakeLastob(obj)		MakeLast(obj)
#define MakeTouchexit(obj)	( ObFlags(obj) |= ObTOUCHEXIT )
#define HideObj(obj)		( ObFlags(obj) |= ObHIDETREE )
#define MakeHidden(obj)		HideObj(obj)
#define MakeHidetree(obj)	HideObj(obj)
#define MakeIndirect(obj)	( ObFlags(obj) |= ObINDIRECT )

#define NoSelect(obj)		( ObFlags(obj) &= ~ObSELECTABLE )
#define NoDefault(obj)		( ObFlags(obj) &= ~ObDEFAULT )
#define NoExit(obj)		( ObFlags(obj) &= ~ObEXIT )
#define NoEdit(obj)		( ObFlags(obj) &= ~ObEDITABLE )
#define NoRadio(obj)		( ObFlags(obj) &= ~ObRADIO )
#define NoRButton(obj)		NoRadio(obj)
#define NoLast(obj)		( ObFlags(obj) &= ~ObLASTOB )
#define NoLastob(obj)		NoLast(obj)
#define NoTouchexit(obj)	( ObFlags(obj) &= ~ObTOUCHEXIT )
#define ShowObj(obj)		( ObFlags(obj) &= ~ObHIDETREE )
#define NoHidetree(obj)		ShowObj(obj)
#define NoIndirect(obj)		( ObFlags(obj) &= ~ObINDIRECT )

#define SelectObj(obj)		( ObState(obj) |= ObSELECTED )
#define CrossObj(obj)		( ObState(obj) |= ObCROSSED )
#define CheckObj(obj)		( ObState(obj) |= ObCHECKED )
#define DisableObj(obj)		( ObState(obj) |= ObDISABLED )
#define OutlineObj(obj)		( ObState(obj) |= ObOUTLINED )
#define ShadowObj(obj)		( ObState(obj) |= ObSHADOWED )

#define DeselectObj(obj)	( ObState(obj) &= ~ObSELECTED )
#define UnCrossObj(obj)		( ObState(obj) &= ~ObCROSSED )
#define UnCheckObj(obj)		( ObState(obj) &= ~ObCHECKED )
#define EnableObj(obj)		( ObState(obj) &= ~ObDISABLED )
#define NoOutlineObj(obj)	( ObState(obj) &= ~ObOUTLINED )
#define NoShadowObj(obj)	( ObState(obj) &= ~ObSHADOWED )

/*
 * Use these for visual changes.  q.v. ObjcDraw below.
 * 
 * NOTE: These will not work for some `obj' arguments with side-effects!
 */
#define ObjcSelect(obj) \
		( SelectObj(obj), ObjcDraw(tree,(obj),ObMAXDEPTH,NULL) )
#define ObjcDeselect(obj) \
		( DeselectObj(obj), ObjcDraw(tree,(obj),ObMAXDEPTH,NULL) )


/*
 * Utility functions
 * ----------------------------------------------------------------------
 */

#if __TURBOC__ || __GNUC__
short min( short a, short b );
short max( short a, short b );
#endif

#define EvntTimer(t) evnt_timer( (WORD)((t) & 0xffffL), \
				 (WORD)(((t)>>16) & 0xffffL) )
#if __GNUC__
#undef EvntTimer
#define EvntTimer(t) evnt_timer(t)
#endif
/* Goofy GNU binding for evnt_timer is more logical, but wrong.
 * __OLD_WAY__ is provided for evnt_multi but not evnt_timer.
 */

VOID	FormExit __PROTO(( OBJECT *tree, GRECT *rstart ));
/* Clean up after a form.
 * rstart -> small rectangle for the zoombox, or NULL.
 */

VOID	FormInit __PROTO(( OBJECT *tree, GRECT *rstart, BOOLEAN drawit ));
/* Initialize a form, and optionally draw it.
 * rstart -> small rectangle for the zoombox, or NULL.
 */

WORD	FselName __PROTO(( BOOLEAN remember, char *name,
			   const char *searchmask, const char *label ));
/* Handle file and/or path selection.
 *	If `remember' is TRUE, the file selector module remembers the path
 *	chosen by the user.
 *	`name' must point to a string at least 128 chars long.
 *	`searchmask' is the default file mask for the file selector top line.
 *	`label' is used as the file selector prompt string.
 *
 *	If path\filename is supplied in `name', use it as default,
 *	    NOTE: if caller supplies path\filename, there must be a filename,
 *		  or the path must end in a backslash.  Otherwise FselName
 *		  will think that the end of the path is the default filename!
 *	else use remembered default path.
 *
 *	If `searchmask' is NULL, and a default filename is supplied,
 *	use the extender of the filename as a searchmask.
 *	If `searchmask' is non-NULL, append its extender if the user
 *	supplies a filename with no extender.
 *
 *	Return conditions:
 *	1)  If fsel_input returns an error, return that error and  "" in name.
 *	2)  If the user selects OK, copy full path\filename to name,
 *	    and return SUCCESS (TRUE).
 *	3)  If the user selects OK with no file, copy the backslash-terminated
 *	    path to name, and return FAILURE (FALSE).
 *	4)  If the user selects Cancel, return FAILURE and "" in name.
 */

VOID	GrafMKState __PROTO(( MoInfo *minfo ));
/* Like AES graf_mkstate, but passing struct pointer rather than 4 WORD *'s.
 */

VOID	GrafMovebox __PROTO(( const GRECT *box, WORD endx, WORD endy ));
/* Like AES graf_movebox/mbox, but passes GRECT * for source rectangle.
 */

VOID	GrafZoombox __PROTO(( const GRECT *start, const GRECT *finish ));
/* Growbox/shrinkbox combo.  If `start' is smaller than `finish', it does
 * a growbox, otherwise it does a shrinkbox.
 */

VOID	ObjcDraw __PROTO(( OBJECT *tree, WORD obj, WORD depth, GRECT *clip ));
/* Like AES objc_draw, but calculates the clip rectangle if NULL is passed
 * in `clip'.
 */

VOID	ObjcExtent __PROTO(( OBJECT *tree, WORD obj, GRECT *r ));
/* Get the full extent of an object, including border, outline, and/or shadow.
 * Useful for calculating clip rectangles if you don't use ObjcDraw, above.
 */

VOID	ObjcRect __PROTO(( OBJECT *tree, WORD obj, GRECT *r ));
/* Get the rectangle of an object in screen coordinates.
 * DESTINATION RECT MUST NOT BE THE OBJECT'S GRECT!!!
 * Unless you really do want to screw up your object tree.
 */

/*
 * WARNING!  Psychotic typecasts ahead!
 */
#define RectEqual( r1ptr, r2ptr ) \
		( *(long *)(r1ptr) == *(long *)(r2ptr) && \
		  *(long *)&(r1ptr)->g_w == *(long *)&(r2ptr)->g_w )

#define RectEmpty(r)	( ! *(long *)&(r)->g_w )

VOID	Rect2xy __PROTO(( GRECT *r, WORD *pxy ));
/* Convert GRECT to vdi ulx, uly, lrx, lry array.
 */

VOID	RectBlit __PROTO(( GRECT *clip, GRECT *rs, GRECT *rd ));
/* Blit from one section of the screen to another.
 * rs -> source rect, rd -> destination rect.
 */

VOID	RectCenter __PROTO(( GRECT *rs, WORD xoffset, WORD yoffset,
			      GRECT *rd ));
/* Center destination rectangle (rd) within (or outside, for negative offsets)
 * source rectangle (rs).
 */

VOID	RectInset __PROTO(( WORD xoffset, WORD yoffset, GRECT *r ));
/* Inset a rectangle by xoffset, yoffset (affects g_w, g_h).
 */

BOOLEAN	RectIntersect __PROTO(( const GRECT *rs, GRECT *rd ));
/* If rs and rd intersect, change rd to the intersection and return TRUE.
 * Otherwise, leave rd alone and return FALSE.
 */

VOID	RectOffset __PROTO(( WORD xoffset, WORD yoffset, GRECT *r ));
/* Offset a rectangle by xoffset, yoffset (affects g_x, g_y).
 */

#define XYinRect( x, y, rptr ) ( (x) >= (rptr)->g_x && \
				 (y) >= (rptr)->g_y && \
				 (x) < (rptr)->g_x + (rptr)->g_w && \
				 (y) < (rptr)->g_y + (rptr)->g_h )

#endif AESUTIL_H
