/*
	BEZBIND.C

	Copyright 1989 Atari Corporation
	Kenneth Soohoo

	7/31/89 File Created, w/o trapping to VDI. KS

	Bindings for the GEM 3.01 VDI calls for Bezier curves.
 */

#define void	int

/* Use these #defines if you _really_ want to stick to DRI conventions */

#define v_bez_on(x)	v_bez_con(x, 1)
#define v_bez_off(x)	v_bez_con(x, 0)


/* These arrays must exist somewhere */

extern int contrl[], intin[], intout[], ptsin[], ptsout[];


/* For local implementation of bezier calls, for testing */
/* extern int set_app_buff(), bez_on_off(), bez(), bez_qual(); */

extern vdi();

void v_set_app_buff(address, nparagraphs)
int **address,		/* Pointer to pointer to application's buffer */
    nparagraphs;	/* # ints in the buffer */
{
	contrl[0] = -1;
	contrl[3] = 3;
	contrl[5] = 6;
/*	contrl[6] = handle; */
	contrl[6] = 0;		/* Who cares what the handle is? */
	contrl[1] = contrl[2] = contrl[4] = 0;

	intin[0] = (int )(((long )address) & 0x0000FFFFL);
	intin[1] = (int )( (((long )address) & 0xFFFF0000L) >> 16);
	intin[2] = nparagraphs;

/*	set_app_buff();		/ * Do the call here */
	vdi();

	return;
}




int v_bez_con(handle, onoff)
int handle;
int onoff;
{
	contrl[0] = 11;		/* GDP */
	contrl[1] = onoff;
	contrl[2] = contrl[3] = contrl[4] = 0;
	contrl[5] = 13;
	contrl[6] = handle;

/*	bez_on_off(); */
	vdi();

	return(intout[0]);
}




void v_bez(handle, count, xyarr, bezarr,extent,totpts,totmoves)
int	handle, 		/* Device handle we're drawing to */
	count, 		/* Number of points total... */
	*xyarr; 		/* The points in x1,y1,x2,y2 format */
char	*bezarr;		/* Flag array, so that we can set start, jump pts */
int	*extent;
int	*totpts;
int	*totmoves;
{
	int i;
	char *ch_intin;

	contrl[0] = 6;
	contrl[1] = count;
	contrl[2] = 2;
	contrl[3] = (count + 1) / 2;
	contrl[4] = 6;
	contrl[5] = 13;
	contrl[6] = handle;	

	for (i = 0; i < (count * 2); ++i) {	/* Copy vertices */
		ptsin[i] = xyarr[i];
		}

	/* If the user don't supply their own vertex-type flags,
	   then do it for them, so they don't crash us...
	*/

	for (i = 0; i < contrl[3]; i++) {/* Copy control values */
		ch_intin=intin;
		ch_intin[i*2+1] = bezarr[i*2];
		}

	for (i = 0; i < contrl[3]; i++) {/* Copy control values */
		ch_intin=intin;
		ch_intin[i*2] = bezarr[i*2+1];
		}

/*	bez();*/
	vdi();
	extent[0] = ptsout[0];
	extent[1] = ptsout[1];
	extent[2] = ptsout[2];
	extent[3] = ptsout[3];
	*totpts = intout[0];
	*totmoves = intout[1];
	return;
}




void v_bez_fill(handle, count, xyarr, bezarr,extent,totpts,totmoves)
int	handle, 		/* Device handle we're drawing to */
	count, 		/* Number of points total... */
	*xyarr; 		/* The points in x1,y1,x2,y2 format */
char	*bezarr;		/* Flag array, so that we can set start, jump pts */
int	*extent;
int	*totpts;
int	*totmoves;
{
	int i;
	char *ch_intin;

	contrl[0] = 9;
	contrl[1] = count;
	contrl[2] = 2;
	contrl[3] = (count + 1) / 2;
	contrl[4] = 6;
	contrl[5] = 13;
	contrl[6] = handle;	

	for (i = 0; i < (count * 2); ++i) {	/* Copy control vertices */
		ptsin[i] = xyarr[i];
		}

	for (i = 0; i < contrl[3]; i++) {/* Copy control values */
		ch_intin=intin;
		ch_intin[i*2+1] = bezarr[i*2];
		}

	for (i = 0; i < contrl[3]; i++) {/* Copy control values */
		ch_intin=intin;
		ch_intin[i*2] = bezarr[i*2+1];
		}

/*	bez(); */
	vdi();
	extent[0] = ptsout[0];
	extent[1] = ptsout[1];
	extent[2] = ptsout[2];
	extent[3] = ptsout[3];
	*totpts = intout[0];
	*totmoves = intout[1];
	return;
}




int v_bez_qual(handle, prcnt, actual)
int handle,
    prcnt,
    *actual;
{
	contrl[0] = 5;		/* Escape */
	contrl[1] = contrl[2] = 0;
	contrl[3] = 3;
	contrl[4] = 1;
	contrl[5] = 99;
	contrl[6] = handle;

	intin[0] = 32;
	intin[1] = 1;
	intin[2] = prcnt;

/*	bez_qual();*/
	vdi();
	if (actual != (int *)0l) *actual = intout[0];

	return (intout[0]);
}
