/* bsearch.c - Binary search (ANSI support function).
 * FontForm, Copyright (c) 1990, Atari Corporation.
 * ======================================================================
 * 901202 kbad	Cleanup
 *
 * NOTE: this function is included in MWSUPP.S, but is duplicated here
 *	 in C if you need it for your compiler.
 */

#include "portab.h"
typedef long size_t;
#if MWC
typedef int sizeof_t;
#else
typedef long sizeof_t;
#endif

/* ----------------------------------------------------------------------
 * Search array `base' of `hi' items of size `size'.
 * Look for item `key' using compare function `cmp'.
 */
VOIDP bsearch( key, base, hi, size, cmp)
REG const VOIDP key;
REG const VOIDP base;
REG size_t	hi;
sizeof_t	size;
REG CMPFUNC	cmp;
{
REG size_t	lo, mid;
REG int		dir;

    /*
     * Validate input.
     */
    if( !key || !base || size <= 0 || hi <= 0 || !cmp )
	return NULL;

    lo = 0;
    --hi;
    while( lo <= hi )
    {
	/*
	 * Test against middle of current span.
	 */
	mid = (lo + hi) >> 1;
	if( dir = (*cmp)( ((char *)base) + mid * size, key) )
	{
	    if( dir > 0 )   /* mid > key, so move down high bound */
		hi = mid - 1;
	    else	    /* mid < key, so move up low bound */
		lo = mid + 1;
	}
	else /* mid == key, so return a pointer to this item */
	    return (VOIDP)( ((char *)base) + mid * size );
    }

    return NULL; /* Key not found. */
}
