/* faces.h - FACES.INF reader
 * FontForm, Copyright (c) 1990, Atari Corporation
 * ======================================================================
 * 901217 kbad	Addded FIDO field, final sweep.
 * 901202 kbad	Cleanup
 * 901127 kbad	From PageOMat
 */

#ifndef FACES_H
#define FACES_H

#define SAMPLE_POINTSIZE 19

/* Data structures
 * ----------------------------------------------------------------------
 */

/*
 * Font struct, filled in by vqt_name cycle
 */
typedef struct sFont
{
	WORD	id;
	WORD	nolower;
	char	name[40];   /* Longer than needed, but good for padding
			     * and for DB dumps.
			     */
} Font;


/*
 * Bit masks for Face.fido
 */
#define	FONTF	1U   /* base font */
#define FONTI	2U   /* italic font */
#define FONTD	4U   /* demi font */
#define FONTO	8U   /* demi oblique font */

/*
 * Face struct, filled in from faces.inf after vqt_name cycle
 */
typedef struct sFace
{
	char	name[34];
	UWORD	fido;
	Font	*font;
	Font	*ital;
	Font	*bold;
	Font	*boldital;
} Face;


/* Global variables
 * ----------------------------------------------------------------------
 */

EXTERN Face	*faces;	    /* array of available faces */
EXTERN WORD	nfaces;	    /* number of available faces */
EXTERN WORD	maxpts;	    /* largest point size returned by vst_point */


/* Functions
 * ----------------------------------------------------------------------
 */
long	GetFaces ( VOID );

#endif FACES_H
