/* fontform.c - font selector demo program
 * FontForm, Copyright (c) 1990, Atari Corporation
 * ======================================================================
 * 901228 kbad	Last minute fix for rotated & skewed printed output
 * 901227 kbad	Last minute cleanup in style dial
 * 901220 kbad	Clean build.
 * 901219 kbad	Menu and window stuff added.  Final sweep.
 * 901202 kbad	Cleanup
 * 901126 kbad	Started
 */

#include <stdio.h>

#if LATTICE
#include <stdlib.h>
#include <string.h>
#include <osbind.h>
#include <aes.h>
#include <vdi.h>
#endif

#if __TURBOC__
#include <stdlib.h>
#include <string.h>
#include <tos.h>
#include <aes.h>
#include <vdi.h>
#endif

#if MWC
#include <osbind.h>
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
#define vqt_fontinfo vqt_font_info
#endif

#if __GNUC__
#include <stdlib.h>
#include <osbind.h>
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
#define strupr(s) { short i; for(i=0;s[i];i++) s[i] = toupper(s[i]); }
#endif

#include "portab.h"
#include "aesutil.h"
#include "fsmbind.h"
#include "fontform.h"
#include "faces.h"
#include "styles.h"
#include "menukeys.h"
#include "printout.h"

/* VDI globals
 * ----------------------------------------------------------------------
 */
WORD	wsin[11] = { 0, 1, 1,  1, 1, 1,  1, 1, 1,  1, 2 };
WORD	ws[57], wsid, physid;
WORD	nfonts;

/* AES globals
 *-----------------------------------------------------------------------
 */
WORD	apid;
WORD	hchar, wchar, hbox, wbox;
GRECT	desk, rwind, rwork;
char	*alertp, alert[256];
long	dcrates[5] = {450L, 330L, 275L, 220L, 165L}; /* Double-click rates */
WORD	wind = -1, wkind = NAME|INFO|CLOSER;
char	winfo[128];
OBJECT	*menu;


/* FontForm stuff
 * ----------------------------------------------------------------------
 */
char	*version = "FontForm v901228";


/* Local functions
 * ----------------------------------------------------------------------
 */
GLOBAL VOID	GemExit __PROTO(( short code ));
GLOBAL VOID	Redraw __PROTO(( GRECT *clip ));
MLOCAL VOID	EventLoop( VOID );



/* FONTFORM functions
 * ======================================================================
 */

/* ----------------------------------------------------------------------
 * Exit cleanly, with a return code.
 */
GLOBAL VOID	GemExit( code )
short		code;
{
    if( wind > 0 )
    {
	wind_close( wind );
	wind_delete( wind );
    }

    if( menu )
	menu_bar( menu, 0 );

    if( prwsid > 0 )
    {
	vst_unload_fonts( prwsid, 0 );
	v_clswk( prwsid );
    }

    if( nfonts )
	vst_unload_fonts( wsid, 0 );

    v_clsvwk( wsid );
    appl_exit();
    exit( code );
}


/* ----------------------------------------------------------------------
 * Redraw the font sample window.
 */
GLOBAL VOID	Redraw( clip )
GRECT		*clip;
{
    WORD	i, pts, set, wcell, hcell, pxy[4];
    WORD	x, y, shad;
    UWORD	fx;
    WORD	dist[5], effects[3];
    char	fontname[80], *text;
    Font	*pfont;

    /*
     * Set clipping, and erase clip area.
     */
    v_hide_c( wsid );
    Rect2xy( clip, pxy );
    vs_clip( wsid, 1, pxy );
    vswr_mode( wsid, MD_REPLACE );
    vsf_perimeter( wsid, NO );
    vsf_interior( wsid, 0 ); /* hollow fill */
    v_bar( wsid, pxy );

    if( !curstyle.pts 
    ||	(pfont = FsmFont(curstyle.face, curstyle.fx, &fx)) == NULL )
    {
	/*
	 * No font selected, use system font.
	 */
	vst_font( wsid, 1 );
	pts = 10;
	vst_point( wsid, pts, &i, &i, &wcell, &hcell );
	if( hcell > hchar )
	{
	    pts = 9;
	    vst_point( wsid, pts, &i, &i, &wcell, &hcell );
	}
	set = pts;
	fx = curstyle.fx;
	GetString( SYSFONT, &text );
    }
    else
    {
	/*
	 * FSM font selected.
	 */
	pts = curstyle.pts;
	set = curstyle.set;
	vst_font( wsid, pfont->id );
	vst_arbpt( wsid, pts, &i, &i, &i, &i );
	vst_setsize( wsid, set, &i, &i, &wcell, &hcell );
	vst_skew( wsid, curstyle.skew * 10 );
	text = pfont->name;
    }
    vswr_mode( wsid, MD_TRANS );
    vst_color( wsid, 1 );
    vst_effects( wsid, fx );
    vst_alignment( wsid, VstLEFT, VstBASE, &i, &i );

    vqt_fontinfo( wsid, &i, &i, dist, &i, effects );
    x = rwork.g_x;
    y = rwork.g_y;

    if( set >= 0 )
	x += wcell / 2;	/* en space offset	*/
    else
	x = rwork.g_w - wcell/2;

sprintf( winfo, " cell=%d X %d, bot=%d, desc=%d, half=%d, asc=%d, top=%d",
	wcell, hcell, dist[0], dist[1], dist[2], dist[3], dist[4] );
wind_set( wind, WF_INFO, winfo );

    if( pts >= 0 )
	y += dist[4];	/* offset to top line	*/
    else
	y += dist[0];	/* offset to bottom line */

    if( fx & FxSHADOW )
    {
	/*
	 * 1pt shadow per 32 pts size:
	 * pixels = points * pixelsPerPoint
	 * pixelsPerPoint = microns/pt / microns/pixel
	 * 25400 microns/inch, 72 points/inch
	 */
	shad = (WORD)((abs(pts) * 353L) / (32L * ws[4]));
	if( !shad ) shad = 1;
    }
    else
    {
	shad = 0;
    }

    sprintf( fontname, "(%d pt. %d set) %s", pts, set, text );
    if( pfont && pfont->nolower )
	strupr( fontname );
    v_shtext( wsid, x, y, fontname, 1, shad, shad );
    y += hcell;
    GetString( SAMPTEXT, &text );
    strcpy( fontname, text );
    if( pfont && pfont->nolower )
	strupr( fontname );
    v_shtext( wsid, x, y, fontname, 1, shad, shad );

    vs_clip( wsid, 0, pxy );
    v_show_c( wsid, 0 );
}

/* ----------------------------------------------------------------------
 * Main event loop
 */
MLOCAL VOID	EventLoop( VOID )
{
    UWORD	event;
    WORD	key, nclicks, msg[8];
    MoInfo	m;
    GRECT	r, *pr;

    do {
	event = evnt_multi( MU_MESAG|MU_KEYBD,
			    0, 0, 0,
			    0, 0, 0, 0, 0,
			    0, 0, 0, 0, 0,
			    msg, 0, 0,
			    &m.x, &m.y, &m.buttons, &m.keys,
			    &key, &nclicks );
	wind_update( BEG_UPDATE );

	if( event & MU_KEYBD )
	    DoKey( MapKey(key), &event );

	if( event & MU_MESAG )
	{
	    switch( MsgId(msg) )
	    {
		case MN_SELECTED:
		    DoMenu( msg, &event );
		break;

		case WM_REDRAW:
		    pr = &WinRect(msg);
		    wind_get( wind, WF_FIRSTXYWH,
			      &r.g_x, &r.g_y, &r.g_w, &r.g_h );
		    while( !RectEmpty( &r ) )
		    {
			if( RectIntersect(pr, &r) )
			    Redraw( &r );
			wind_get( wind, WF_NEXTXYWH,
				  &r.g_x, &r.g_y, &r.g_w, &r.g_h );
		    }
		break;

		case WM_CLOSED:
/*
 * This is the only place I specifically ask if the user wants to quit.  I
 * figure that selecting the menu option means you really do want to quit,
 * and that using the key equivalent means that you're an advanced user
 * who doesn't want to be bothered with an alert.  Just closing the window,
 * though, is less obvious.  This is a major pet peeve of mine... I *H*A*T*E*
 * applications that ask me if I want to quit, especially when I explicitly
 * tell them to quit with a menu selection or a key equivalent.  Grr.  Even
 * worse, I won't even USE programs that do this and then default to the
 * opposite of what I just told them to do.  Please, give your users some
 * credit.  Even if most may not deserve it, advanced users surely do.
 */
		    GetAlert( DOQUIT, &alertp );
		    if( form_alert(1, alertp) == 1 )
			event = 0;
		break;

	    }
	}
	wind_update( END_UPDATE );
    } while( event );
}




/* ----------------------------------------------------------------------
 * FontForm main().  Void, because it exits indirectly (via GemExit).
 */
VOID		main( VOID )
{
    OBJECT	*tree;

    /*
     * Do the GEM startup thang...
     */
    if( (apid = appl_init()) == -1 )
    {
	/*
	 * This can "never happen".  However, I invoke Henry Spencer's
	 * Sixth Commandment for C Programmers.
	 */
	Cconws( "\r\nError initializing GEM, hit a key..." );
	Cconin();
	exit( apid );
    }

    wsin[0] = Getrez()+2;
    wsid = physid = graf_handle( &wchar, &hchar, &wbox, &hbox );
    v_opnvwk( wsin, &wsid, ws );
    wind_get( 0, WF_WORKXYWH, &desk.g_x, &desk.g_y, &desk.g_w, &desk.g_h );

    if( !rsrc_load("fontform.rsc") )
    {
	/* Fugly, but multi-lingual */
	form_alert( 1, "[3][ FONTFORM.RSC ][ OK ]" );
	GemExit( -1 );
    }

    if( vq_vgdos() != GDOS_FSM )
    {
	GetAlert( NOGDOS, &alertp );
	form_alert( 1, alertp );
	GemExit( -1 );
    }

    /*
     * Display the "Loading Fonts" dialog, and load fonts.
     */
    graf_mouse( MoBUSYBEE, NULL );
    GetTree( LOADING, &tree );
    TedText(LOADVERS) = version;
    GetString( LOADTEXT, &alertp );
    TedText(LOADMSG) = alertp;
    FormInit( tree, NULL, YES );

    nfonts = vst_load_fonts( wsid, 0 );

    /*
     * Find out what faces correspond to the fonts we have.
     */
    if( GetFaces() )
    {
	GetAlert( NOFONTS, &alertp );
	form_alert( 1, alertp );
	GemExit( -1 );
    }
    FormExit( tree, NULL );

    /*
     * Set initial point sizes and effects bits which must be forced
     * due to font availability,
     */
    curstyle.pts = curstyle.set = 12;
    curstyle.fx = ValidFx( &curstyle );

    /*
     * Toss up a menu bar, then set up the sample window.
     */
    GetTree( MENU, &menu );
    menu_bar( menu, 1 );
    wind_update( BEG_MCTRL );
    EnableMenus();

    RectCenter( &desk, wbox/4, hbox/4, &rwind );
    wind = wind_create( wkind, rwind.g_x, rwind.g_y, rwind.g_w, rwind.g_h );
    if( wind < 0 )
    {
	form_error( 4 ); /* No room to open another document */
	GemExit( -1 );
    }
    else
    {
	GetString( WINDTITL, &alertp );
	wind_set( wind, WF_NAME, alertp );
	wind_open( wind, rwind.g_x, rwind.g_y, rwind.g_w, rwind.g_h );
	wind_get( wind, WF_WORKXYWH, &rwork.g_x, &rwork.g_y,
		  &rwork.g_w, &rwork.g_h );
    }

    wind_update( END_MCTRL );
    graf_mouse( MoARROW, NULL );
    EventLoop();

    GemExit( 0 );
}
