/* fsmbind.c - FSM GDOS function bindings
 * Copyright  1990,1991, Atari Corporation
 * ===========================================================================
 * 910729 kbad	vqt_cachesize() was missing; vqt_fextent() renamed.
 * 910611 kbad	Added new FSM bindings.  v_shtext() now uses v_ftext()
 * 901217 kbad	Added v_shtext.  Final sweep.
 * 901202 kbad	Cleanup
 * 901129 kbad	FontForm mods
 * 901120 kbad	Source code cleanup
 * 901101 kbad	started
 *
 * NOTE:
 * This module is compiler-dependent.  I wish you many happy hours of
 * enjoyment porting these bindings to your compiler (actually, all
 * you need to implement is vdicall()).
 */

#include "portab.h"
#include "fsmbind.h"

#if LATTICE
extern short *_VDIpb[5];
extern short _VDIcontrl[];		/* default 11 */
extern short _VDIintin[];		/* default 128 */
extern short _VDIintout[];		/* default 128 */
extern short _VDIptsin[];		/* default 8 */
extern short _VDIptsout[];		/* default 10 */

#define vdipb	_VDIpb
#define contrl	_VDIcontrl
#define intin	_VDIintin
#define intout	_VDIintout
#define ptsin	_VDIptsin
#define ptsout	_VDIptsout
#endif

#if __TURBOC__
EXTERN WORD 	*vdipb[]; /* in tcsupp.s */
EXTERN struct
{
	WORD	contrl[15];
	WORD	global[80];
	WORD	intin[128];
	WORD	intout[45];
	WORD	ptsout[128];
	void   *addrin[128];
	void   *addrout[6];
	WORD	ptsin[128];
} _GemParBlk;

#define contrl	_GemParBlk.contrl
#define intin	_GemParBlk.intin
#define intout	_GemParBlk.intout
#define ptsout	_GemParBlk.ptsout
#endif

#if MWC
EXTERN WORD 	*vdipb[]; /* in mwsupp.s */
GLOBAL WORD 	contrl[12], intin[256], ptsin[256], intout[256], ptsout[256];
#endif

#if __GNUC__
EXTERN WORD 	*_vdiparams[];
EXTERN WORD 	_contrl[], _intin[], _ptsin[], _intout[], _ptsout[];

#define vdipb	_vdiparams
#define contrl	_contrl
#define intin	_intin
#define intout	_intout
#define ptsin	_ptsin
#define ptsout	_ptsout

void __vdi__(unsigned long coded_contrl, int handle);
#endif

/*
 * Longword packed control array counts
 */
						/*fnpt--in			FSMGDOS func # */
#define VQT_F_EXTENT(n)	0xF0000000L|((n)&0xff)		/* 240 */
#define V_FTEXT(n)		0xF1010000L|((n)&0xff)		/* 241 */
#define V_KILLOUTLINE	0xF2000002L					/* 242 */
#define V_GETOUTLINE	0xF3000003L					/* 243 */
#define VST_SCRATCH		0xF4000001L					/* 244 */
#define VST_ERROR		0xF5000003L					/* 245 */
#define VST_ARBPT		0xF6000001L 				/* 246 */
#define VQT_ADVANCE 	0xF7000001L 				/* 247 */
#define VQT_DEVINFO 	0xF8000001L 				/* 248 */
#define V_SAVECACHE(n)	0xF9000000L|((n)&0xff)		/* 249 */
#define V_LOADCACHE(n)	0xFA000000L|(((n)+1)&0xff)	/* 250 */
#define V_FLUSHCACHE	0xFB000000L 				/* 251 */
#define VST_SETSIZE 	0xFC000001L 				/* 252 */
#define VST_SKEW		0xFD000001L 				/* 253 */
#define VQT_GET_TABLES	0xFE000000L 				/* 254 */
#define VQT_CACHESIZE	0xFF000001L 				/* 255 */


/* FSMBIND functions
 * ======================================================================
 */

/* ----------------------------------------------------------------------
 * v_gtext with shadow.
 * Text color should be set to `color' before calling.
 * This is not technically an FSM binding,
 * but this module is a convenient place for it.
 */
GLOBAL VOID v_shtext( wsid, x, y, text, color, xshadow, yshadow )
int			wsid, x, y;
char		*text;
int			color;
int			xshadow, yshadow;
{
EXTERN VOID vst_color __PROTO((int, int));

	if( xshadow || yshadow )
	{
		v_ftext( wsid, x+xshadow*2, y+yshadow*2, text );
		vst_color( wsid, 0 );
		v_ftext( wsid, x+xshadow, y+yshadow, text );
		vst_color( wsid, color );
	}
	v_ftext( wsid, x, y, text );
}


/* ---------------------------------------------------------------------------
 * Inquire text extent, accounting for FSM text placement
 */
GLOBAL VOID	vqt_f_extent( handle, text, extent )
int			handle;
char		*text;
WORD		*extent;
{
typedef struct { WORD x0,y0, x1,y1, x2,y2, x3,y3; } EXTENT;
	WORD		i = 0;

	while( *text )
		intin[i++] = *text++;
	intin[i] = 0;
	vdicall( VQT_F_EXTENT(i), handle, contrl, vdipb );
	*(EXTENT *)extent = *(EXTENT *)ptsout;
}

/* ---------------------------------------------------------------------------
 * Draw FSM text (accounts for fractional advances in rotated text)
 */
GLOBAL VOID	v_ftext( handle, x, y, text )
int			handle, x, y;
char		*text;
{
	WORD		i = 0;

	while( *text )
		intin[i++] = *text++;
	intin[i] = 0;
	ptsin[0] = x;
	ptsin[1] = y;
	vdicall( V_FTEXT(i), handle, contrl, vdipb );
}

/* ---------------------------------------------------------------------------
 * Release memory associated with outline component generated by v_getoutline()
 */
GLOBAL VOID	v_killoutline( handle, component )
int			handle;
WORD		*component;
{
	*(WORD **)&intin[0] = component;
	vdicall( V_KILLOUTLINE, handle, contrl, vdipb);
}


/* ---------------------------------------------------------------------------
 * Generate an outline for character ch, and return the address of the outline.
 */
GLOBAL VOID	v_getoutline( handle, ch, component )
int			handle, ch;
WORD		**component;
{
	intin[0] = ch;
	*(WORD ***)&intin[1] = component;
	vdicall( V_GETOUTLINE, handle, contrl, vdipb );
}

/* ---------------------------------------------------------------------------
 * Set scratch buffer allocation mode.
 * mode=0: (default) account for FSM fonts when allocating scratch buffers
 * mode=1: account only for BM fonts
 * mode=2: allocate no scratch buffer
 */
GLOBAL VOID	vst_scratch( handle, mode )
int			handle, mode;
{
	intin[0] = mode;
	vdicall( VST_SCRATCH, handle, contrl, vdipb );
}


/* ---------------------------------------------------------------------------
 * Set FSM error mode.
 * mode=1: (default) errors go to screen.
 * mode=0: errors reported in error variable `errorvar'.
 */
GLOBAL VOID	vst_error(handle, mode, errorvar)
int			handle, mode;
WORD		*errorvar;
{
	intin[0] = mode;
	*(WORD **)&intin[1] = errorvar;
	vdicall( VST_ERROR, handle, contrl, vdipb );
}


/* ---------------------------------------------------------------------------
 * Set character cell height by arbitrary points.
 */
GLOBAL int 	vst_arbpt( handle, point, wchar, hchar, wcell, hcell )
int			handle, point;
WORD		*wchar, *hchar, *wcell, *hcell;
{
	intin[0] = point;
	vdicall( VST_ARBPT, handle, contrl, vdipb );
	*wchar = ptsout[0];
	*hchar = ptsout[1];
	*wcell = ptsout[2];
	*hcell = ptsout[3];

	return (int)(intout[0]);
}

/* ----------------------------------------------------------------------
 * Inquire FSM text advance placement vector.
 */
GLOBAL VOID vqt_advance( handle, ch, xadv, yadv, xrem, yrem )
int			handle, ch;
WORD		*xadv, *yadv, *xrem, *yrem;
{
	intin[0] = ch;
	vdicall( VQT_ADVANCE, handle, contrl, vdipb );
	*xadv = ptsout[0];
	*yadv = ptsout[1];
	*xrem = ptsout[2];
	*yrem = ptsout[3];
}

/* ----------------------------------------------------------------------
 * Inquire device status information.
 */
GLOBAL VOID vqt_devinfo( handle, device, isdev, drivername )
int			handle, device;
BOOLEAN 	*isdev;
char		*drivername;
{
	short		i;

	intin[0] = device;
	vdicall( VQT_DEVINFO, handle, contrl, vdipb );
	*isdev = ptsout[0];
	for( i = 0; i <= contrl[4]; i++ )
		drivername[i] = (char)intout[i];
}

/* ----------------------------------------------------------------------
 * Save FSM cache to disk.
 */
GLOBAL int	v_savecache( handle, filename )
int			handle;
char		*filename;
{
	short		i;

	for( i = 0; filename[i]; i++ )
		intin[i] = filename[i];
	intin[i] = 0;
	vdicall( V_SAVECACHE(i), handle, contrl, vdipb );

	return (int)(intout[0]);
}

/* ----------------------------------------------------------------------
 * Load/merge FSM cache from disk.
 */
GLOBAL int	v_loadcache( handle, filename, mode )
int			handle;
char		*filename;
int			mode;
{
	WORD		i, *ii = intin;

	*ii++ = mode;
	for( i = 0; filename[i]; i++ )
		*ii++ = filename[i];
	*ii = 0;
	vdicall( V_LOADCACHE(i), handle, contrl, vdipb );

	return (int)(intout[0]);
}

/* ----------------------------------------------------------------------
 * Flush FSM cache.
 */
GLOBAL int	v_flushcache( handle )
int			handle;
{
	vdicall( V_FLUSHCACHE, handle, contrl, vdipb );

	return (int)(intout[0]);
}

/* ----------------------------------------------------------------------
 * Set character cell width by arbitrary points.
 */
GLOBAL int	vst_setsize( handle, point, wchar, hchar, wcell, hcell )
int			handle, point;
WORD		*wchar, *hchar, *wcell, *hcell;
{
	intin[0] = point;
	vdicall( VST_SETSIZE, handle, contrl, vdipb );
	*wchar = ptsout[0];
	*hchar = ptsout[1];
	*wcell = ptsout[2];
	*hcell = ptsout[3];

	return (int)(intout[0]);
}

/* ----------------------------------------------------------------------
 * Set FSM skew.
 */
GLOBAL int	vst_skew( handle, skew )
int			handle, skew;
{
	intin[0] = skew;
	vdicall( VST_SKEW, handle, contrl, vdipb );

	return (int)(intout[0]);
}

/* ----------------------------------------------------------------------
 * Get FSM GASCII tables.
 */
GLOBAL VOID vqt_get_tables( handle, gascii, style )
int			handle;
WORD		**gascii, **style;
{
	vdicall( VQT_GET_TABLES, handle, contrl, vdipb );
	*gascii = *(WORD **)&intout[0];
	*style = *(WORD **)&intout[2];
}


/* -----------------------------------------------------------------------
 * Get cache size.
 * Values for `which':
 * 0: return largest block available in character cache
 * 1: ditto for data structure cache
 */
GLOBAL VOID vqt_cachesize( handle, which, size )
int			handle, which;
long		*size;
{
	vdicall( VQT_CACHESIZE, handle, contrl, vdipb );
	*size = *(long *)intout;
}
