/* fsmbind.h - FSM GDOS function bindings
 * Copyright  1990,1991, Atari Corporation
 * ======================================================================
 * 910729 kbad  vqt_cachesize() was missing; vqt_fextent() renamed.
 * 910611 kbad	added new FSM bindings,
 *				WORD value parameters changed to int for convenience
 * 901217 kbad	Added v_shtext.  Final sweep.
 * 901120 kbad	Source code cleanup
 * 901101 kbad	started
 */

#ifndef FSMBIND_H
#define FSMBIND_H

#include "portab.h"

#if ANSI_C
#include "pragma.h"
#else
VOID	vdicall();
ULONG	vq_vgdos();
#endif

#undef GDOS_NONE
#undef GDOS_FSM
#undef GDOS_FNT

#define GDOS_NONE -2L		/* no GDOS installed */
#define GDOS_FSM  0x5F46534DL	/* '_FSM' */
#define GDOS_FNT  0x5F464E54L	/* '_FNT' */


/* Functions
 * ----------------------------------------------------------------------
 */

VOID	v_shtext __PROTO(( int wsid, int x, int y, char *text,
						   int color, int xshadow, int yshadow ));
/* v_gtext with optional shadow attribute
 */

VOID	vqt_f_extent __PROTO(( int handle, char *text, WORD *extent ));
VOID	v_ftext	__PROTO(( int handle, int x, int y, char *text ));
VOID	v_killoutline __PROTO(( int handle, WORD *component));
VOID	v_getoutline __PROTO(( int handle, int ch, WORD **component ));
VOID	vst_scratch __PROTO(( int handle, int mode ));
VOID	vst_error __PROTO(( int handle, int mode, WORD *errorvar ));

int		vst_arbpt __PROTO(( int handle, int point, WORD *wchar, WORD *hchar,
							WORD *wcell, WORD *hcell ));
/* Set character cell height by arbitrary points.
 */

VOID	vqt_advance __PROTO(( int handle, int ch, WORD *xadv, WORD *yadv,
							  WORD *xrem, WORD *yrem ));
/* Inquire FSM text advance placement vector.
 */

VOID	vqt_devinfo __PROTO(( int handle, int device, WORD *isdev,
								char *drivername ));
/* Inquire device status information.
 */

int		v_savecache __PROTO(( int handle, char *filename ));
/* Save FSM cache to disk.
 */

int		v_loadcache __PROTO(( int handle, char *filename, int mode ));
/* Load/merge FSM cache from disk.
 */

int		v_flushcache __PROTO(( int handle ));
/* Flush FSM cache.
 */

int		vst_setsize __PROTO(( int handle, int point, WORD *wchar, WORD *hchar,
							  WORD *wcell, WORD *hcell ));
/* Set character cell width by arbitrary points.
 */

int		vst_skew __PROTO(( int handle, int skew ));
/* Set FSM skew.
 */

VOID	vqt_get_tables __PROTO(( int handle, WORD **gascii, WORD **style ));
/* Get FSM GASCII tables.
 */

VOID	vqt_cachesize __PROTO(( int handle, int which, long *size ));
/* Get character or data structure cache free space.
 */

#endif FSMBIND_H
