/* GEMERROR.H - BIOS and GEMDOS error returns.
 * FontForm, Copyright (c) 1990, Atari Corporation
 * ======================================================================
 * 901202 kbad	Cleanup.
 * 900906 kbad	for LC5.  Changed back to MWC style AExxx errors,
 *		to avoid potential symbol collisions.  Also nuked
 *		all underscores.
 * 900129 kbad	reviewed
 * 890829 kbad	ERANGE changed to ESOOR to comply with ANSI spec.
 */

#ifndef GEMERROR_H
#define GEMERROR_H

/* TOS error numbers
 * ----------------------------------------------------------------------
 */

/*
 * BIOS-level errors ....................................................
 *							MS-DOS equivalents
 */
#define AEOK	  0L	/* OK, the anti-error			 0 */
#define AERROR	 -1L	/* Basic, fundamental error		na */
#define AEDRVNR	 -2L	/* Drive not ready			21 */
#define AEUNCMD	 -3L	/* Unknown command			22 */
#define AECRC	 -4L	/* CRC error				23 */
#define AEBADRQ	 -5L	/* Bad request (invalid length)		24 */
#define AESEEK	 -6L	/* Seek error				25 */
#define AEMEDIA	 -7L	/* Unknown medium			26 */
#define AESECNF	 -8L	/* Sector not found			27 */
#define AEPAPER	 -9L	/* No paper				28 */
#define AEWRITF	-10L	/* Write fault				29 */
#define AEREADF	-11L	/* Read fault				30 */
#define AEGENRL	-12L	/* General failure			31 */
			/* Sharing violation			32 */
			/* Lock violation			33 */
#define AEWRPRO	-13L	/* Write protect			19 */
#define AECHNG	-14L	/* Media change				na */
#define AEUNDEV	-15L	/* Unknown device			20 */
#define AEBADSF	-16L	/* Bad sectors on format		na */
#define AEOTHER	-17L	/* Insert other disk			34 */
			/* FCB unavailable			35 */
			/* Sharing buffer exceeded		36 */
			/* Reserved				37 */
			/* Handle EOF operation not completed	38 */
			/* Reserved			     39-49 */
			/* NetBIOS errors		     50-90 */

/*
 * GEMDOS-level errors ..................................................
 *							MS-DOS equivalents
 */
#define AEINVFN	-32L	/* Invalid function number		 1 */
#define AEFILNF	-33L	/* File not found			 2 */
#define AEPTHNF	-34L	/* Path not found			 3 */
#define AENHNDL	-35L	/* Too many open files (no handles left) 4 */
#define AEACCDN	-36L	/* Access denied			 5 */
#define AEIHNDL	-37L	/* Invalid handle			 6 */
			/* Memory control blocks destroyed	 7 */
#define AENSMEM	-39L	/* Insufficient memory			 8 */
#define AEIMBA	-40L	/* Invalid memory block address		 9 */
			/* Invalid environment			10 */
			/* Invalid format			11 */
			/* Invalid access code			12 */
			/* Invlaid data				13 */
			/* Reserved				14 */
#define AEDRIVE	-46L	/* Invalid drive			15 */
			/* Attempt to remove CWD		16 */
#define AENSAME	-48L	/* Not same drive (on rename)		17 */
#define AENMFIL	-49L	/* No more files			18 */

/*
 * Homegrown error numbers ..............................................
 *							    "TOS error #"
 */
#define AESOOR	-64L	/* Seek Out Of Range			(33) */
/* NOTE:  ESOOR (Seek Out Of Range) used to be called ERANGE, but
 *	  ERANGE is defined by ANSI for math function errors.
 */

#define AEINTRN	-65L	/* Internal error			(34) */
#define AELDFMT	-66L	/* Invalid program load format		(35) */
#define AEGSBF	-67L	/* Setblock failed: growth restrictions	(36) */

#endif GEMERROR_H
