/ MWSUPP.S - Mark Williams C assembler support routines for FontForm
/ FontForm, Copyright (c) 1990, Atari Corporation
/ =======================================================================
/ 901202 kbad	Cleanup
/ 901130 kbad	Started

/ External definitions
.globl	    contrl_, intin_, intout_, ptsin_, ptsout_
.globl	    lrmul, toupper_

/ Global variables & functions
.globl	    vdipb_
.globl	    vq_vgdos_, vdicall_, mul_div_, bsearch_, strupr_

.shrd
.even

/
/ VDI parameter block
/
vdipb_:	.long	contrl_, intin_, intout_, ptsin_, ptsout_

.shri

/ long vq_vgdos( VOID );
/ -----------------------------------------------------------------------
/ Return what version of GDOS is installed.
/ Returns -2L if GDOS is not installed,
/ '_FSM' (0x5F46534DL) if FSMGDOS is installed,
/ '_FNT' (0x5F464E54L) if FONTGDOS is installed, or
/ some other value (!= -2) if GDOS 1.1 (or G+PLUS or AMCGDOS) is installed.
/
vq_vgdos_:
	moveq	$-2,d0
	trap	$2
	rts

/ VOID vdicall( long ctlcnts, WORD handle, WORD *ctl, WORD *pb[] );
/ -----------------------------------------------------------------------
/ Make a VDI call, after filling in the intin and ptsin arrays.
/
/ 4(sp) = longword-packed control array counts (see FSMBIND.C)
/ 8(sp) = workstation handle
/ 10(sp) -> contrl array
/ 14(sp) -> VDI parameter block
/
vdicall_:
	move.l	4(sp),d0
	movea.l	10(sp),a0
	movep.l	d0,1(a0)
	move.w	8(sp),12(a0)
	move.l	14(sp),d1
	moveq	$0x73,d0
	trap	$2
	rts

/ WORD mul_div( WORD num1, WORD num2, WORD div );
/ -----------------------------------------------------------------------
/ Return (WORD)((LONG)(num1 * num2) / div)
/
/ 4(sp) = num1
/ 6(sp) = num2
/ 8(sp) = div
/
mul_div_:
	move.w	4(sp),d0
	move.w	6(sp),d1
	muls	d1,d0
	divs	8(sp),d0
	rts

/ VOIDP bsearch( VOIDP key, VOIDP base, size_t n, WORD size, CMPFUNC cmp );
/ -----------------------------------------------------------------------
/ In MWC, sizeof() returns a 16 bit value, so the `size' parameter
/ is word-sized instead of size_t as ANSI specifies.
/
/ after link:
/ $08(a6) -> key
/ $0c(a6) -> base
/ $10(a6) = n
/ $14(a6) = size
/ $16(a6) -> cmp
/
/ register usage:
/ a5 ->	key
/ a4 -> base
/ a3 -> element to compare
/ d7 = size
/ d6 = n (hi pointer)
/ d5 = lo pointer
/ d4 = mid pointer
/
bsearch_:
	link	a6,$0
	movem.l	${d4-d7,a3-a5},-(sp)

/ validate parameters
	move.l	0x08(a6),d0	/ if key == NULL punt
	beq.s	1f
	movea.l	d0,a5
	move.l	0x0C(a6),d0	/ if base == NULL punt
	beq.s	1f
	movea.l	d0,a4
	moveq	$0,d7
	move.w	0x14(a6),d7	/ if size <= 0 punt
	bls.s	1f
	move.l	0x10(a6),d6	/ if n <= 0 punt
	bls.s	1f
	tst.l	0x16(a6)	/ if cmp == NULL punt
	bls.s	1f

/ kickstart the loop
	moveq	$0,d5		/ lo = 0
	subq.l	$1,d6		/ hi = n-1
	bra.s	2f

5:	move.l	d5,d4		/ mid = (lo + hi)/2
	add.l	d6,d4
	lsr.l	$1,d4

	move.l	d7,-(sp)	/ element = base + ...
	move.l	d4,-(sp)
	jsr	lrmul		/ mid * size
	addq.w	$8,sp
	lea	0(a4,d0.l),a3

	movea.l	0x16(a6),a0	/ cmp( element, key )
	move.l	a5,-(sp)
	move.l	a3,-(sp)
	jsr	(a0)
	addq.w	$8,sp

	beq.s	3f		/ if == 0, we got it

	ble.s	4f
	move.l	d4,d6		/ if > 0
	subq.l	$1,d6		/ hi = mid - 1;
	bra.s	2f

4:	move.l	d4,d5		/ if < 0
	addq.l	$1,d5		/ lo = mid + 1
	bra.s	2f

3:	move.l	a3,d0		/ return element
	bra.s	0f

2:	cmp.l	d6,d5		/ while( lo <= hi )
	ble.s	5b

1:	moveq	$0,d0		/ return NULL

0:	movem.l	(sp)+,${d4-d7,a3-a5}
	unlk	a6
	rts

/ void strupr( char *s )
/ -----------------------------------------------------------------------
/ Upcase string s.
strupr_:
	movea.l	4(sp),a0
	moveq	$0,d0
2:	move.b	(a0),d0
	beq.s	1f
	move.w	d0,-(sp)
	jsr	toupper_
	addq.w	$2,sp
	move.b	d0,(a0)+
	bra.s	2b
1:	rts

