/* PORTAB.H - Portability definitions and declarations
 * Copyright (c) 1990, Atari Corporation
 * ================================================================
 * 901220 kbad	Clarified some definitions.
 * 901217 kbad  Final sweep.
 * 901206 kbad	Cleanup.
 * 901129 kbad	Renamed/moved some compiler-dependent definitions.
 * 900831 kbad	TOS API revision, Lattice C 5 update.
 * 900621 kbad	Changed back from typedefs to #defines to avoid
 *		endless "suspicious pointer conversion" complaints
 * 890829 kbad	Hacked up for ANSI
 *
 * NOTE: This file does not include the old DEFAULT and FOREVER
 *	 definitions.  DEFAULT clashed with too many things, and
 *       using for(;;) or while(TRUE) are clearer than using FOREVER.
 */

#ifndef PORTAB_H
#define PORTAB_H


/* Compiler-dependent configuraition options.
 * ======================================================================
 * Change these as necessary to support your compiler.
 */

/* ANSI_C - ANSI compatibility
 * ----------------------------------------------------------------------
 * The ANSI standard provides a manifest constant, __STDC__, to allow
 * code to configure itself for ANSI and non-ANSI compilers.  BUT...
 *
 * #ifdef __STDC__ is useless to determine ANSI compatibility, because
 * MWC defines it even though it is /not/ ANSI compliant, and
 * Turbo C un-defines __STDC__ if you use cdecl even though TC is
 * otherwise ANSI compliant.
 *
 * #if __STDC__ is useless, because Lattice defines it as 0,
 * even though Lattice C is otherwise ANSI compliant.
 *
 * So add your compiler to the OR list below if you know it can handle
 * fully ANSI C code (including void, void *, const, volatile, function
 * prototypes, and new preprocessor directives).
 */
#ifndef ANSI_C
#  if LATTICE || __TURBOC__ || __GNUC__
#    define ANSI_C	1
#  else
#    define ANSI_C	0
#  endif
#endif

/* UCHARA - Signed/unsigned char handling.
 * ----------------------------------------------------------------------
 * #define UCHARA 1 if type char is unsigned by default.
 * __PLAIN_CHAR_UNSIGNED is set by Lattice compiler option -cu
 */
#ifndef UCHARA
#  if __PLAIN_CHAR_UNSIGNED
#    define UCHARA	1
#  else
#    define UCHARA	0
#  endif
#endif

/* STDARGS - Standard (stack-based) argument passing.
 * ----------------------------------------------------------------------
 * This type of declaration is required when compiling with register
 * parameter passing to ensure that functions which need stack-based
 * parameters (e.g. functions which draw AES USERDEF objects) take
 * parameters off the stack.
 */
#if __TURBOC__
#define STDARGS cdecl
#endif

#if LATTICE
#define STDARGS __stdargs __saveds
#endif

#if SOME_OTHER_COMPILER
#define STDARGS KEWORDS_FOR_USERDEF_FUNCTIONS
#endif

#ifndef STDARGS
#define STDARGS /* */
#endif

/* HIBIT_1ST - bitfield ordering.
 * ----------------------------------------------------------------------
 * For this struct:
 *
 * struct bitfield {	HIBIT_1ST compilers store the fields like this:
 *	nybble0 : 4;	0000111122223333
 *	nybble1 : 4;
 *	nybble2 : 4;	!HIBIT_1ST compilers store them like this:
 *	nybble3 : 4;	3333222211110000
 * };
 *
 * If your compiler isn't listed below, you must explicitly
 * #define HIBIT_1ST.
 */
#ifndef HIBIT_1ST
#  if __TURBOC__ || LATTICE || __GNUC__
#    define HIBIT_1ST 1
#  endif
#  if MWC || LASER_C
#    define HIBIT_1ST 0
#  endif
#  ifndef HIBIT_1ST
1+; /* Deliberate syntax error if you forgot to define HIBIT_1ST */
#  endif
#endif

/* PORTAB_TYPEDEFS - Portability type typedefs vs. defines.
 * ----------------------------------------------------------------------
 * #define PORTAB_TYPEDEFS 1 if you want portability types to be typedefs,
 * or 0 if you want #defines.  Typedefs can give you better type checking.
 * Set to 0 for compilers like Turbo C which complain about type
 * mismatches between short and WORD even if WORD is typedefed to short.
 */
#ifndef PORTAB_TYPEDEFS
#define PORTAB_TYPEDEFS 1 /* or 0 if you want #defines instead */
#endif


/* Standard type definitions
 * ======================================================================
 */

#if PORTAB_TYPEDEFS

#if UCHARA
typedef char		UBYTE;		/* Alcyon doesn't do `unsigned char' */
#else
typedef unsigned char	UBYTE;		/* Unsigned 8 bit byte		*/
#endif

typedef signed char	BYTE;		/* Signed 8 bit byte 		*/
typedef unsigned short	UWORD;		/* Unsigned 16 bit word		*/
typedef short		WORD;		/* Signed 16 bit word		*/
typedef unsigned long	ULONG;		/* Unsigned 32 bit long word	*/
typedef signed long	LONG;		/* Signed 32 bit long word	*/
typedef WORD		BOOLEAN;	/* WORD-sized true/false value	*/

#else /* #define type definitions */

#if UCHARA
#define UBYTE	char			/* Alcyon doesn't do `unsigned char' */
#else
#define UBYTE	unsigned char		/* Unsigned byte		*/
#endif

#define BYTE	signed char		/* Signed byte			*/
#if __TURBOC__ || __GNUC__
#  define UWORD	unsigned int		/* Special case to support	*/
#  define WORD	signed int		/* Turbo C and GCC bindings	*/
#else
#  define UWORD	unsigned short		/* unsigned word		*/
#  define WORD	signed short		/* Signed word (16 bits)	*/
#endif
#define ULONG	unsigned long		/* Unsigned long		*/
#define LONG	signed long		/* signed long (32 bits)	*/
#define BOOLEAN	WORD			/* WORD-sized true/false value	*/

#endif PORTAB_TYPEDEFS


/* VOIDP - Pointer to anything
 * ----------------------------------------------------------------------
 * This is always a typedef, because a #define for pointer variables does
 * not work as you might expect.  With #define VOIDP void *, the following
 * declaration of 2 pointers to pointers would be WRONG:
 * VOIDP *pvoidptr1, *pvoidptr2;
 * pvoidptr2 is not a void **, but a void *. With the VOIDP typedef,
 * it works correctly.  To avoid strict warnings, use (VOIDP) type casts.
 */
#if ANSI_C
typedef void *	VOIDP;
#else
typedef char *	VOIDP;
#endif


/* Storage class specifiers
 * ======================================================================
 */

#define REG	register		/* Register variable		*/
#define LOCAL	auto			/* Local to function		*/
#define EXTERN	extern			/* Externally defined		*/
#define MLOCAL	static			/* Local to module		*/
#define GLOBAL	/* */			/* Global variable/function	*/

#if !ANSI_C
#define const	 /* */
#define volatile /* */
#endif


/* Function declarations
 * ======================================================================
 */

#if ANSI_C
#define VOID	void			/* Void function return 	*/
#else
#define VOID	/* */
#endif

#undef __PROTO				/* Function prototype exclusion */
#if ANSI_C
#  define __PROTO(a)	a
#else
#  define __PROTO(a)	()
#endif

/* Compare function for qsort/bsearch. */
typedef int (*CMPFUNC)__PROTO((const void *,const void *));

/* Void function for various AES drawers */
typedef VOID (*VOIDFUNC)(VOID);


/* Miscellaneous definitions
 * ======================================================================
 * NOTE: SUCCESS and FAILURE are returned by some AES functions.
 *	 They are OPPOSITES of ANSI EXIT_SUCCESS and EXIT_FAILURE, the
 *	 values to be passed to exit().
 */

#define FALSE	0
#define TRUE	!0
#define YES	TRUE
#define NO	FALSE
#define SUCCESS TRUE			/* Function success return val	*/
#define FAILURE FALSE			/* Function failure return val	*/

#ifndef EOF				/* This is defined by ANSI	*/
#define EOF	(-1)			/* EOF Value			*/
#endif

#ifndef NULL				/* This is defined by ANSI	*/
#define NULL	( (VOIDP)0L )
#endif

#define NULLPTR NULL
#define NULLFUNC ( (VOIDFUNC)0L )

#endif PORTAB_H
