/* pragma.h - FontForm #pragma exclusion file
 * FontForm, Copyright  1990,1991 Atari Corporation
 * ======================================================================
 * 901217 kbad	Final sweep
 * 901202 kbad	Cleanup
 * 901130 kbad	Created
 *
 * NOTE:
 * This include file is only included for ANSI_C compilers, and
 * is compiler-dependent.  #pragma definitions presented here are for
 * Lattice C.  I wish you many happy hours of enjoyment porting these
 * bindings to your compiler.
 */

#ifndef PRAGMA_H
#define PRAGMA_H

/* ----------------------------------------------------------------------
 * Determine what version of GDOS is installed.
 * Returns GDOS_NONE if GDOS is not installed,
 * GDOS_FSM if FSM GDOS is installed,
 * GDOS_FNT if FONT GDOS is installed, or
 * some other value (!= -2) if GDOS 1.1 (or G+PLUS or AMCGDOS) is installed.
 */
ULONG	vq_vgdos( void );
#if LATTICE
#pragma inline d0=vq_vgdos() {register d2,a2; "70FE"; "4E42"}
				/* moveq #-2,d0 / trap #2 */
#endif
#if __GNUC__
#define vq_vgdos()				\
({						\
	register long ret __asm__("d0");	\
	__asm__ volatile			\
	("					\
		movq	#-2,d0;			\
		trap	#2 "			\
	: "=r"(ret)				\
	:					\
	: "d0", "d1", "d2", "a0", "a1", "a2"	\
	);					\
	ret;					\
})
#endif	


/* ----------------------------------------------------------------------
 * Function for making VDI calls directly after manually filling in
 * the intin and ptsin arrays.
 */
VOID	vdicall( long ctlcnts, WORD handle, WORD *ctl, WORD *pb[] );
#if LATTICE
#pragma inline vdicall( d0, d2, a0, d1 ) \
	{register d2,a2; "01C8"; "0001"; "3142"; "000C"; "7073"; "4E42";}
	/* movep.l d0,1(a0) / move.w d2,12(a0) / moveq #73,d0 / trap #2 */
#endif

#if __GNUC__
#define vdicall(a,b,c,d) __vdi__((a),(b))
#endif

/* ----------------------------------------------------------------------
 * For portability, if you don't care to implement it in assembler,
 * #define MUL_DIV_DEFINE when compiling files which include this header.
 * Assembler versions (inline and otherwise) are provided for
 * Lattice, Turbo C, and MWC in the various support files, so you needn't
 * do that for those compilers.
 */
#if MUL_DIV_DEFINE
# define mul_div(num1, num2, div) ( (WORD)(((LONG)(num1) * (num2)) / (div)) )
#else
WORD	mul_div( WORD num1, WORD num2, WORD div );
# if LATTICE
#  pragma inline d0=mul_div(d0,d1,d2) {register d2; "C1C1"; "81C2"}
					/* muls d1,d0 / divs d2,d0 */
# endif
#endif

#endif PRAGMA_H
