/* printout.c - font selector demo program printing routine
 * FontForm, Copyright (c) 1990, Atari Corporation
 * ======================================================================
 * 901228 kbad	Last minute fix for rotated & skewed output.
 * 901219 kbad	Final sweep.
 * 901212 kbad	Started
 */

#include <stdio.h>

#if LATTICE
#include <stdlib.h> /* abs */
#include <string.h>
#include <vdi.h>
#include <aes.h>
#endif

#if __TURBOC__
#include <stdlib.h>
#include <string.h>
#include <vdi.h>
#include <aes.h>
#endif

#if MWC
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
#define vqt_fontinfo vqt_font_info
#endif

#if __GNUC__
#include <stdlib.h>
#include <string.h>
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
#define strupr(s) { short i; for(i=0;s[i];i++) s[i] = toupper(s[i]); }
#endif

#include "portab.h"
#include "aesutil.h"
#include "fsmbind.h"
#include "fontform.h"
#include "faces.h"
#include "styles.h"
#include "printout.h"

EXTERN char	*alertp, alert[];
EXTERN WORD	wind;
EXTERN VOID	Redraw __PROTO(( GRECT *clip ));

GLOBAL WORD	prwsid = -1;
MLOCAL WORD	prwsin[11] = { 21, 1, 1,  1, 1, 1,  1, 1, 1,  1, 2 };
MLOCAL WORD	prws[57];
MLOCAL WORD	pralign = 1;


/* ----------------------------------------------------------------------
 * Print out a sample of the currently selected font.
 */
GLOBAL VOID	Print( VOID )
{
    Font	*pfont;
    WORD	pts, set, wcell, hcell, x, y, xshadow, yshadow;
    UWORD	fx;
    WORD	dist[5], effects[3], clip[4];
    char	fontname[80], *text;
    OBJECT	*tree;

    GetTree( LOADING, &tree );
    TedText(LOADVERS) = "";
    if( prwsid == -1 )
    {
	GetString( LOADTEXT, &text );
	TedText(LOADMSG) = text;
	graf_mouse( MoBUSYBEE, NULL );
	FormInit( tree, NULL, YES );

	v_opnwk( prwsin, &prwsid, prws );
	if( prwsid )
	    vst_load_fonts( prwsid, 0 );
	FormExit( tree, NULL );
	graf_mouse( MoARROW, NULL );
    }

    if( prwsid == 0 )
    {
	GetAlert( NOPRINT, &alertp );
	form_alert( 1, alertp );
	return;
    }

    if( (pfont = FsmFont(curstyle.face, curstyle.fx, &fx)) == NULL )
    {
	GetAlert( INVALID, &alertp );
	GetString( FONTSTR, &text );
	sprintf( alert, alertp, text );
	form_alert( 1, alert );
	return;
    }

    GetAlert( PRALIGN, &alertp );
    switch( form_alert(pralign, alertp) )
    {
	case 1: /* Landscape */
	    pralign = 1;
	break;
	case 2: /* Portrait */
	    pralign = 2;
	break;
	case 3: /* Cancel   */
	    return;
    }

    GetString( PRINTEXT, &text );
    TedText(LOADMSG) = text;
    graf_mouse( MoBUSYBEE, NULL );
    FormInit( tree, NULL, YES );

    pts = curstyle.pts;
    set = curstyle.set;

    v_clrwk( prwsid );

    vst_font( prwsid, pfont->id );
    vst_arbpt( prwsid, pts, &x, &x, &x, &x );
    vst_setsize( prwsid, set, &x, &x, &wcell, &hcell );

    vswr_mode( prwsid, MD_TRANS );
    vst_alignment( prwsid, VstLEFT, VstBASE, &x, &x );
    vst_color( prwsid, 1 );
    vst_effects( prwsid, fx );

    if( fx & FxSHADOW )
    {
	xshadow = yshadow = (WORD)((abs(pts) * 353L) / (32L * prws[4]));
	if( !xshadow )
	    xshadow = yshadow = 1;
    }
    else
    {
	xshadow = yshadow = 0;
    }

    vqt_fontinfo( prwsid, &x, &x, dist, &x, effects );

    if( pralign == 1 )
    {
	/*
	 * Landscape
	 */
	vst_rotation( prwsid, 900 );
	if( pts > 0 )
	    x = dist[4]; /* offset to top line */
	else
	    x = dist[0]; /* offset to bottom line */

	if( set > 0 )
	    y = prws[1] - wcell/2; /* yres */
	else
	    y = wcell/2;

	yshadow = -yshadow;
    }
    else
    {
	/*
	 * Portrait
	 */
	vst_rotation( prwsid, 0 );
	if( pts > 0 )
	    y = dist[4]; /* top line */
	else
	    y = dist[0]; /* bottom line */

	if( set > 0 )
	    x = wcell / 2;
	else
	    x = prws[0] - wcell/2; /* xres */
    }

    vst_skew( prwsid, curstyle.skew * 10 );

    clip[0] = clip[1] = 0;
    clip[2] = prws[0];
    clip[3] = prws[1];
    vs_clip( prwsid, 1, clip );

    sprintf( fontname, "(%d pt. %d set) %s", pts, set, pfont->name );
    if( pfont->nolower )
	strupr( fontname );
    v_shtext( prwsid, x, y, fontname, 1, xshadow, yshadow );
    if( pralign == 1 )
	x += hcell;
    else
	y += hcell;
    GetString( SAMPTEXT, &text );
    strcpy( fontname, text );
    if( pfont->nolower )
	strupr( fontname );
    v_shtext( prwsid, x, y, fontname, 1, xshadow, yshadow );
    v_updwk( prwsid );

    FormExit( tree, NULL );
    graf_mouse( MoARROW, NULL );
}
