/* sliders.h - slider handler functions
 * ======================================================================
 * 901120 kbad	Source code cleanup
 * 901112 kbad	started
 */

#ifndef SLIDERS_H
#define SLIDERS_H

/*
 * For portability, if you don't care to implement it in assembler,
 * #define MUL_DIV_DEFINE when compiling files which include this header.
 * Assembler versions (inline and otherwise) are provided for
 * Lattice, Turbo C, and MWC in the various support files, so you needn't
 * do that for those compilers.
 */
#if ANSI_C
#include "pragma.h"
#else
# if MUL_DIV_DEFINE
#  define mul_div(num1, num2, div) ( (WORD)(((LONG)(num1) * (num2)) / (div)) )
# else
WORD	mul_div();
# endif
#endif

/* Functions
 * ----------------------------------------------------------------------
 */

VOID	SlSize __PROTO(( OBJECT *tree, WORD slid, WORD elev,
			 WORD minsize, WORD range, WORD visrange ));

VOID	SlXY __PROTO(( OBJECT *tree, WORD slid, WORD elev, VOIDFUNC draw,
			WORD minval, WORD maxval, WORD value ));

VOID	SlDraw __PROTO(( OBJECT *tree, WORD slid, WORD elev,
			 GRECT *old, GRECT *new ));

VOID	SlDrag __PROTO(( OBJECT *tree, WORD slid, WORD elev, VOIDFUNC draw,
			 WORD minval, WORD maxval, WORD *pval ));

VOID	SlArrow __PROTO(( OBJECT *tree, WORD slid, WORD elev, WORD obj,
			  VOIDFUNC draw, WORD inc, WORD minval, WORD maxval,
			  WORD *pval ));

#endif SLIDERS_H
