/* ANSI strtol() to replace Lattice lib version 5.04
 * ----------------------------------------------------------------------
 * 901219 kbad MWC update, add strtoul()
 * 901128 kbad
 */

#include <ctype.h>
#include <errno.h>

#ifdef MWC
#define LONG_MAX 2147483647L
#define LONG_MIN -2147483648L
#define ULONG_MAX 4294967295UL
#else
#include <limits.h>
#include <stdlib.h>
#endif

#include "portab.h"

/* ----------------------------------------------------------------------
 * Convert the prefix of `s' to long, ignoring leading white space.
 * Store a pointer to any unconverted suffix in `*endp',
 * unless `endp' is NULL.  If `base' is between 2 and 36, conversion
 * is done assuming input written in that base.  If `base' is 0, the
 * base becomes either 8, 10, or 16 (leading 0 implies 8, leading
 * 0x or 0X implies base 16).  If the answer would overflow, LONG_MAX
 * or LONG_MIN is returned, based on the sign of the result, and `errno'
 * is set to ERANGE.
 */
long	    strtol( s, endp, base )
const char  *s;
char	    **endp;
int	    base;
{
    int	    c, digit, isneg, overflow;
volatile long maxdecade; /* keep optimizer from putting assignment in loop */
    long    lval;
const char  *start = s;

    /*
     * Skip leading whitespace
     */
    while( (c = *s) && isspace(c) )
	++s;

    /*
     * Get sign
     */
    isneg = (c == '-');
    if( c == '+' || c == '-' )
	++s;

    /*
     * Get base.
     */
    if( base == 0 )
    {
	base = 10;
	if( *s == '0' )
	{
	    base = 8;
	    c = *(++s);
	    if( c == 'X' || c == 'x' )
	    {
		base = 16;
		++s;
	    }
	}
    }
    else if( base == 16 && *s == '0' )
    {
	c = *(++s);
	if( c == 'X' || c == 'x' )
	    ++s;
    }

    /*
     * Range-check base, then determine max value and convert digits.
     */
    if( base < 2 || base > 36 )
    {
	s = start;
	overflow = 1;
    }
    else
    {
	maxdecade = LONG_MAX / base;
	overflow = 0;
	lval = 0;
	for(;;)
	{
	    c = *s;
	    if( isdigit(c) )
		digit = c - '0';
	    else
		digit = c - (isupper(c) ? 'A' : 'a') + 10;

	    if( digit < 0 || digit >= base )
		break;

	    ++s;

	    if( lval > maxdecade )
		overflow = 1;

	    if( !overflow )
	    {
		/*
		 * Optimized to avoid long multiplies on common bases
		 */
		switch( base )
		{
		    case 8:  lval <<= 3;			break;
		    case 10: lval = ((lval<<2) + lval) << 1;	break;
		    case 16: lval <<= 4;			break;
		    default: lval *= base;			break;
		}

		if( digit > (LONG_MAX - lval) )
		    overflow = 1;
		else
		    lval += digit;
	    }
	}

	if( isneg )
	    lval = -lval;
    }

    /*
     * Return appropriate values
     */
    if( overflow )
    {
	errno = ERANGE;
	lval = (isneg) ? LONG_MIN : LONG_MAX;
    }

    if( endp )
	*(const char **)endp = s;

    return lval;
}


unsigned long strtoul( s, endp, base )
const char  *s;
char	    **endp;
int	    base;
{
    int	    c, digit, overflow;
volatile unsigned long maxdecade;
unsigned long    ulval;
const char  *start = s;

    /*
     * Skip leading whitespace
     */
    while( (c = *s) && isspace(c) )
	++s;

    /*
     * Get base.
     */
    if( base == 0 )
    {
	base = 10;
	if( *s == '0' )
	{
	    base = 8;
	    c = *(++s);
	    if( c == 'X' || c == 'x' )
	    {
		base = 16;
		++s;
	    }
	}
    }
    else if( base == 16 && *s == '0' )
    {
	c = *(++s);
	if( c == 'X' || c == 'x' )
	    ++s;
    }

    /*
     * Range-check base, then determine max value and convert digits.
     */
    if( base < 2 || base > 36 )
    {
	s = start;
	overflow = 1;
    }
    else
    {
	maxdecade = ULONG_MAX / base;
	overflow = 0;
	ulval = 0;
	for(;;)
	{
	    c = *s;
	    if( isdigit(c) )
		digit = c - '0';
	    else
		digit = c - (isupper(c) ? 'A' : 'a') + 10;

	    if( digit < 0 || digit >= base )
		break;

	    ++s;

	    if( ulval > maxdecade )
		overflow = 1;

	    if( !overflow )
	    {
		/*
		 * Optimized to avoid long multiplies on common bases
		 */
		switch( base )
		{
		    case 8:  ulval <<= 3;			break;
		    case 10: ulval = ((ulval<<2) + ulval) << 1;	break;
		    case 16: ulval <<= 4;			break;
		    default: ulval *= base;			break;
		}

		if( digit > (ULONG_MAX - ulval) )
		    overflow = 1;
		else
		    ulval += digit;
	    }
	}
    }

    /*
     * Return appropriate values
     */
    if( overflow )
    {
	errno = ERANGE;
	ulval = ULONG_MAX;
    }

    if( endp )
	*(const char **)endp = s;

    return ulval;
}

