/* styles.h - style form handler
 * FontForm, Copyright (C) 1990, Atari Corporation
 * ======================================================================
 * 901219 kbad	ValidFx() added.  Final sweep
 * 901202 kbad	Cleanup
 * 901127 kbad	From PageOMat
 *
 * This module is used to manage user selection of a given face and style.
 * It also contains a utility routine to convert a face index and effects
 * word into the actual font to use for that face, and the actual effects
 * that should be used with that font.
 */

#ifndef STYLES_H
#define STYLES_H

/* Constant definitions, from my VDIALT.H
 * ----------------------------------------------------------------------
 */

/* text effects */
#define FxBOLD		0x01
#define FxLITE		0x02
#define FxSKEW		0x04
#define FxUL		0x08
#define FxOUTLINE	0x10
#define FxSHADOW	0x20
#define FxBS		0x05

/* text alignments */
enum VstJusts
{
	VstLEFT,
	VstCENTER,
	VstRIGHT
};

enum VstAligns
{
	VstBASE,
	VstHALF,
	VstASCENT,
	VstBOTTOM,
	VstDESCENT,
	VstTOP
};


/* Data structures
 * ----------------------------------------------------------------------
 */

typedef struct sStyle
{
struct sStyle	*next;	/* not used in this application */
	char	name[22];
	WORD	face;	/* translated to/from font id at startup */
			/* for FACES.INF files with style info   */
	WORD	pts;
	WORD	set;
	WORD	skew;
	UWORD	fx;
	WORD	rot;
} Style;


/* Global variables
 * ----------------------------------------------------------------------
 */

EXTERN Style	curstyle;


/* Functions
 * ----------------------------------------------------------------------
 */

GLOBAL int cmpStyle __PROTO(( const Style *a, const Style *b ));
/* Compare 2 styles.  Return 0 only if they are identical
 * except for rotation.
 */

VOID	StyleForm ( VOID );
/* Allow the user to select a style, comprised of a face, point and set
 * sizes, skew, and special effects for text output.
 */

Font	*FsmFont __PROTO(( WORD face, UWORD fx, UWORD *fsmfx ));
/* Given a face index and effects word, return a pointer to the actual
 * FSM font to use, and adjust the effects word as necessary.
 */

UWORD	ValidFx __PROTO(( Style *ps ));
/* Return valid effects for style *ps.
 */

#endif STYLES_H
