* TCSUPP.S - Turbo C assembler support routines for FontForm
* FontForm, Copyright (c) 1990, Atari Corporation
* =======================================================================
* 901202 kbad	Cleanup
* 901130 kbad	Started

* External references
.globl	    _GemParBlk

* Global declarations
.globl	    vdipb
.globl	    vq_vgdos, vdicall, mul_div

*
* GEMPARBLK structure
*
	    .offset 0
contrl:	    .ds.w   15
global:	    .ds.w   80
intin:	    .ds.w   128
intout:	    .ds.w   45
ptsout:	    .ds.w   128
addrin:	    .ds.l   128
addrout:    .ds.l   128
ptsin:	    .ds.w   128

.data
.even
*
* VDI parameter block
*
vdipb:	.dc.l	_GemParBlk
	.dc.l	_GemParBlk+intin
	.dc.l	_GemParBlk+intout
	.dc.l	_GemParBlk+ptsin
	.dc.l	_GemParBlk+ptsout

.text

*
* long vq_vgdos( void )
* Return what version of GDOS is installed.
* Returns -2L if GDOS is not installed,
* '_FSM' (0x5F46534DL) if FSMGDOS is installed,
* '_FNT' (0x5F464E54L) if FONTGDOS is installed, or
* some other value (!= -2) if GDOS 1.1 (or G+PLUS or AMCGDOS) is installed.
*
vq_vgdos:
	moveq	#-2,d0
	trap	#2
	rts

*
* vdicall( long ctlcnts, WORD handle, WORD *ctl, WORD *pb[] )
* Make a VDI call, after filling in the intin and ptsin arrays.
*
* d0.l = longword-packed control array counts (see FSMBIND.C)
* d1.w = workstation handle
* a0.l -> contrl array
* a1.l -> VDI parameter block
*
vdicall:
	movep.l	d0,1(a0)
	move.w	d1,12(a0)
	move.l	a1,d1
	moveq	#$73,d0
	trap	#2
	rts

*
* mul_div( num1, num2, div )
* Return (WORD)((LONG)(num1 * num2) / div)
*
mul_div:
	muls	d1,d0
	divs	d2,d0
	rts

