/* userdef.c - user defined object draw functions for style form
 * FontForm, Copyright (c) 1990, Atari Corporation
 * ======================================================================
 * 901219 kbad	Final sweep.
 * 901214 kbad	split off from styles.c
 */

#if LATTICE
#include <stdlib.h>
#include <string.h>
#include <vdi.h>
#include <aes.h>
#endif

#if __TURBOC__
#include <stdlib.h>
#include <string.h>
#include <vdi.h>
#include <aes.h>
#endif

#if MWC
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
#define vqt_fontinfo vqt_font_info
#endif

#if __GNUC__
#include <stdlib.h>
#include <string.h>
#include <vdibind.h>
#include <aesbind.h>
#include <gemdefs.h>
#include <obdefs.h>
#define strupr(s) { short i; for(i=0;s[i];i++) s[i] = toupper(s[i]); }
#endif

#include "portab.h"
#include "aesutil.h"
#include "fsmbind.h"
#include "fontform.h"
#include "faces.h"
#include "styles.h"
#include "userdef.h"


EXTERN WORD	wsid;

/* ----------------------------------------------------------------------
 * User-defined object draws for special effects labels.
 */
GLOBAL int STDARGS DrawFxobj( parm )
PARMBLK	*parm;
{
    WORD    attrib[10], fx[3], junk[5], xoff, shad;

    /*
     * Set normal text style, saving what attributes we can.
     */
    vqt_attributes( wsid, attrib );
    vst_font( wsid, 1 );
    vst_point( wsid, 10, junk, &xoff, junk, junk );
    if( xoff > parm->pb_h )
	vst_point( wsid, 9, junk, junk, junk, junk );
    vswr_mode( wsid, MD_TRANS );
    vst_alignment( wsid, VstLEFT, VstTOP, junk, junk );
    xoff = 0;

    /*
     * Select effects and get offsets for string drawing.
     */
    switch( parm->pb_obj )
    {
	case STYBOLDT:
	    vst_effects( wsid, FxBOLD );
	break;
	case STYLITET:
	    vst_effects( wsid, FxLITE );
	break;
	case STYITALT:
	    vst_effects( wsid, FxSKEW );
	    vqt_fontinfo( wsid, junk, junk, junk, junk, fx );
	    xoff = (fx[1] + fx[2])/2;
	break;
	case STYOUTLT:
	    vst_effects( wsid, FxOUTLINE );
	    vqt_fontinfo( wsid, junk, junk, junk, &xoff, fx );
	    xoff /= -16;
	break;
	case STYUNDRT:
	    vst_effects( wsid, FxUL );
	break;
	case STYSHADT:
	    vst_effects( wsid, FxSHADOW );
	break;
    }

    /*
     * Draw effects object, then restore saved text attributes.
     */
    shad = (parm->pb_obj == STYSHADT);
    vst_color( wsid, 1 );
    v_shtext( wsid, parm->pb_x+xoff, parm->pb_y, (char *)parm->pb_parm,
	      1, shad, shad );

    vswr_mode( wsid, attrib[5] );
    vst_font( wsid, attrib[0] );
    vst_alignment( wsid, attrib[3], attrib[4], junk, junk );

    /*
     * For USERDEF objects, the return value is used by the AES as
     * a temporary ob_state to finish the draw.
     */
    return 0;
}


/* ----------------------------------------------------------------------
 * Print the current style name, sample-sized, in the Style form sample box.
 * Select the correct font id and fx based on what fonts are available.
 */
GLOBAL int STDARGS PrintSample( parm )
PARMBLK	*parm;
{
    OBJECT  *tree = (OBJECT *)(parm->pb_tree);
    Style   *pstyle = (Style *)(parm->pb_parm);
    Font    *pfont;
    UWORD   fx;
    WORD    pts, wcell;
    WORD    attrib[10], pxy[4], i, tx, ty, shad;
    char    *s, *endp, tname[40];
    long    l;

    /*
     * Find out what font the current style indicates.
     */
    pfont = FsmFont( pstyle->face, pstyle->fx, &fx );

    /*
     * Save as many of the current settings as we can, then
     * draw the outline box.
     */
    vqt_attributes( wsid, attrib );
    Rect2xy( (GRECT *)(&parm->pb_x), pxy );
    --pxy[0], --pxy[1], ++pxy[2], ++pxy[3];
    vs_clip( wsid, 1, pxy );
    vswr_mode( wsid, MD_REPLACE );
    vsf_color( wsid, BLACK );
    vsf_perimeter( wsid, 1 );
    vsf_interior( wsid, 0 ); /* Hollow fill */
    v_bar( wsid, pxy );

    /*
     * If the current style corresponds to no font we know of, punt.
     */
    if( !pfont ) goto punt;

    /*
     * Update the current style points and set sizes from the tedinfos,
     * in case the user has edited them since we last had a chance to
     * update the style info.
     */
    s = TedText(STYPTS);
    l = strtol( s, &endp, 10 );
    if( *endp == '\0' && l )
	pstyle->pts = (WORD)l;
    s = TedText(STYSET);
    l = strtol( s, &endp, 10 );
    if( *endp == '\0' && l )
	pstyle->set = (WORD)l;

    /*
     * Finally, set appropriate font, point, set sizes, skew & effects,
     * and print the font name in the box, offset by an en space.
     */
    vst_font( wsid, pfont->id );
    pts = (pstyle->pts > 0) ? SAMPLE_POINTSIZE : -SAMPLE_POINTSIZE;
    vst_arbpt( wsid, pts, &i, &i, &i, &i );
    vst_setsize( wsid, pts * pstyle->set / pstyle->pts, &i, &i, &wcell, &i );
    wcell /= 2; /* en space */
    vst_skew( wsid, pstyle->skew * 10 );

    vst_alignment( wsid, VstLEFT, VstBASE, &i, &i );
    vst_effects( wsid, fx );
    vswr_mode( wsid, MD_TRANS );

    s = tname;
    strcpy( s, pfont->name );
    if( pfont->nolower )
	strupr( s );

    if( pstyle->set > 0 )
	tx = parm->pb_x + wcell;
    else
	tx = parm->pb_x + parm->pb_w - wcell - 1;
    if( pts > 0 )
	ty = parm->pb_y + parm->pb_h * 3 / 4;
    else
	ty = parm->pb_y + parm->pb_h / 4;

    vst_color( wsid, 1 );
    shad = ( (fx & FxSHADOW) == FxSHADOW );
    v_shtext( wsid, tx, ty, s, 1, shad, shad );

    /*
     * Restore what settings we can.
     */
    vst_font( wsid, attrib[0] );
    vst_alignment( wsid, attrib[3], attrib[4], &i, &i );

punt:
    vswr_mode( wsid, attrib[5] );
    vs_clip( wsid, 0, pxy );

    /*
     * For USERDEF objects, the return value is used by the AES as
     * a temporary ob_state to finish the draw.
     */
    return 0;
}
