/*
 * ----------------------------------------------------------------------------------------------
 *		JAGUAR TOOLBOX APPLICATION PROGRAM INTERFACE:	INCLUDE FILE
 *		FOR ALL TOS ATARI AND COMPATIBLE
 *
 *	File:		JToolBox.h
 *	Author:		FAVARD LAURENT, FunShip(c)
 *	Date:		25 March 1998
 *	Release:	20 January 1999
 *
 *	VERSION : 1.0
 *
 * ----------------------------------------------------------------------------------------------
 */

#ifndef	__JAGUAR_TOOLBOX__
#define	__JAGUAR_TOOLBOX__

/*
 * ----------------------------------------------------------------------------------------------
 */

#define	G_JTOOLBOX_VERSION		"0.9.9"
#define	G_JTOOLBOX_DATE			"20 January 1998"

typedef	struct	{
					char	Version[6];
					char	Date[20];
				}TJTBVersion;
/*
 * ----------------------------------------------------------------------------------------------
 */

#define		TRUE				1
#define		FALSE				0

#define		QUIET				0
#define		NO_CRY_FILE			-1
#define		NO_CCI_FILE			-2
/*
 * ----------------------------------------------------------------------------------------------
 */

#define		FRAME_NACK			'N'
#define		FRAME_ACK			'A'
#define		FRAME_DATA			'D'

#define		FRAME_INQUIRE		0x0001								/*	ask the jaguar's identification */
#define		FRAME_PRGSEND		0x0002								/*	send a program to the jaguar */
#define		FRAME_MEMSEND		0x0003								/*	send a memory block to the jaguar */
#define		FRAME_MEMGET		0x0004								/*	get a memory block from the jaguar */
#define		FRAME_DBMSG			0x0005								/*	jaguar send a Ascii string to the host */
#define		FRAME_PRGRUN		0x0006								/*	ask to execute a program */
#define		FRAME_EEPROMGET		0x0007								/*	Ask to the jaguar to send its serial eeprom */
#define		FRAME_EEPROMSET		0x0008								/*	Ask to the jaguar the write its serial eeprom */
#define		FRAME_EXCEPTION		0x0009								/*	When an exception 680x0 occur */
#define		FRAME_USER1			0x000A								/*	User1 frame code */

#define		ERR_NO_FRAME		-1L
#define		ERR_CHKSUM			-2L

/*
 * ----------------------------------------------------------------------------------------------
 */

#define		KERNEL_PID			(long)0x4A4A4A4AL
#define		TOOLBOX_PID			(long)0x48484848L

#define		PROGRAM_NAME_LEN	20

#define		MAX_DATA_LEN		1024							  	/*	MAXIMAL data block received for GetFrame() */
#define		MAX_CMD_DATAFRAME	1024								/*	MAXIMAL command data block for GetFrame() */
/*
 * ----------------------------------------------------------------------------------------------
 *	
 */

#define		SIZE_SERIAL_EEPROM		128

/*	Dfinitions sur les entetes fichiers JAG */

#define		SIZE_MAX_HEADER			1024L

#define		LOAD_AND_GO				3
#define		SIZE_H_LOADGO_W			18
#define		SIZE_H_LOADGO_L			20
#define		SIZE_HEADER_XJAG		22	

#define		HEADER_JAGR				"JAGR"							/*	Roine header	*/
#define		HEADER_JAGL				"JAGL"							/*	Roine header	*/
#define		HEADER_XJAG				"XJAG"							/*	Favard header	*/

/*
 * ----------------------------------------------------------------------------------------------
 *	TYPES DEFINITIONS
 */

/*	Generic type for receive a frame */
typedef	struct	{
					char	Table[MAX_CMD_DATAFRAME];
				} TRecipient;

/*	Type for receive a jaguar identification */
typedef	struct	{
					long	Mark;
                    int     _SystemVersion;
                    int		_HardwareVersion;
                    long    _SystemDate;
                    long    _HardwareDate;
				} TJagId;

/*	Type for jaguar memory descriptor */
typedef	struct	{
					void 			*StartAddress;
                    unsigned long	Lenght;
				} TJagMemDesc;

/*	Type for jaguar program descriptor */
typedef	struct	{
					void 			*TargetAddress;
					void 			*StartAddress;
					unsigned long	Lenght;
					char			Name[PROGRAM_NAME_LEN];
				} TJagProgram;

/*	Type for jaguar file program */
typedef	struct	{
					int					CodeOp;
					long		 		Header;
					void				*StartAdr;
					long				Length;
					void				*StartCode;
					unsigned long		OffsetStart;
					char				Name[PROGRAM_NAME_LEN];
					int					Type;
				} TFileJag;

/*	Type for an exception 680x0 */
typedef	struct	{	
					unsigned long		usp;
					unsigned long		ssp;
					unsigned long		d0;
					unsigned long		d1;
					unsigned long		d2;
					unsigned long	 	d3;
					unsigned long		d4;
					unsigned long		d5;
					unsigned long		d6;
					unsigned long		d7;
					unsigned long		a0;
					unsigned long		a1;
					unsigned long		a2;
					unsigned long		a3;
					unsigned long		a4;
					unsigned long		a5;
					unsigned long		a6;
					unsigned int		ExceptionNumber;
					unsigned long		stack_pc;				/*	PC pushed into the stack */
					unsigned int		stack_sr;				/*	PC pushed into the stack */
					unsigned int		ri;						/*	Instr. Register (Bus error, address error) */
					unsigned long		fault_pc;				/*	fault address responsable */
					unsigned int		control;				/*	R/W, FC0-FC1, I/N state */
				} TException;

/*
 * ----------------------------------------------------------------------------------------------
 *	LOW LEVEL COMMUNICATIONS'S FUNCTIONS PROTOTYPES: From JProto.s
 */

extern	signed long cdecl SendBinaries(long SourcePID, long TargetPID, long Lenght, void *Buffer);
extern	signed long cdecl GetBinaries(long SourcePID, long TargetPID, long Lenght, void *Buffer);
extern	signed long cdecl SendFrame(long SourcePID, long TargetPID, int Code, unsigned int Lenght, void *Buffer);
extern	signed long cdecl GetFrame(long *SourcePID, long *TargetPID, int *Code, unsigned int *Lenght, void *Buffer);
extern	signed long cdecl SendPack(void *Buffer, unsigned int Lenght);
extern	signed long cdecl GetPack(void *Buffer, unsigned int Lenght);
extern	signed long cdecl SendByte(int character);
extern	signed long cdecl GetByte(void);

extern	int cdecl GetPort(void);
extern	void cdecl SetPort(int Port);

extern	int cdecl CheckJaguar(void);
extern	void ClearBuffer(void);

/*
 * ----------------------------------------------------------------------------------------------
 */
 
#define		PORT_CARTRIDGE		1
#define		PORT_SERIAL			2


/*
 * ----------------------------------------------------------------------------------------------
 *	HIGH LEVEL COMMUNICATIONS'S FUNCTIONS PROTOTYPES: From JToolBox.c
 */


/* ---------------------------------------------------------------------------------------------- */

extern	void JTB_Version( TJTBVersion *Version );
extern	long JTB_Open( void );
extern	long JTB_Exit( void );

/* ---------------------------------------------------------------------------------------------- */

extern	void HookJaguarMessage( void (*UserFonction)(	int FrameCode, long SourcePID,
														long TargetPID, int LenghtDatas,
                                                        TRecipient *Recipient)
								);

extern	int Inquire( TJagId *JagId );

extern	int MemoryGet(void *STAddress, TJagMemDesc *JagMemDescriptor);
extern	int MemorySend(void *STAddress, TJagMemDesc *JagMemDescriptor);

extern	int MemGet(int Accept, void *STAddress, TJagMemDesc *JagMemDescriptor);
extern	int MemSend(int Accept, void *STAddress, TJagMemDesc *JagMemDescriptor);

extern	int LoadAndGo(void *STAddress, TJagProgram *JagProgram);
extern	int RunPRG(TJagProgram *JagProgram);

extern	int JagToDisk(char *chFileName, TJagMemDesc *JagMem);
extern	int DiskToJag(	char *PathName,
						unsigned long OffsetFromStart,
						TJagMemDesc		*JagMemoire,
						void (*UserFonctionJauge)(unsigned long CountToDo, unsigned long CountPerfomed));

extern	signed int IsJAGR(char *PathName, TFileJag *FileJaguar);
extern	signed int IsJAGL(char *PathName, TFileJag *FileJaguar);

extern	int GetEEPROM( char *chEEPROM );
extern	int SetEEPROM( char *chEEPROM );

/*
 * ----------------------------------------------------------------------------------------------
 *					Misc. procedures
 */

extern	int PackCCI(char *FileName, char *Destination);

/*
 * ----------------------------------------------------------------------------------------------
 *	Error codes
 */

/*	general results	*/
#define		JTB_OK				 1
#define		JTB_ERROR			 0
#define		JTB_FRAME_MISMATCH	-1
#define		JTB_STARTADR_ERR	-2
#define		JTB_TARGETADR_ERR	-3
#define		JTB_LENGHT_ERR		-4

#define		JTB_BAD_VALUE		-1

/*	errors for exejag.c	*/
#define		NO_HEADER 				-1
#define		FILE_ERROR				-2


#endif

