/*
 * ----------------------------------------------------------------------------------------------
 *		JAGUAR TOOLBOX APPLICATION PROGRAM INTERFACE
 *		FOR ALL TOS ATARI AND COMPATIBLE
 *
 *	File:		Eeprom.c
 *	Author:		FAVARD LAURENT, FunShip(c)
 *	Date:		25 March 1998
 *	Release:	28 September 1998
 *
 *	VERSION : 1.0
 *
 * ----------------------------------------------------------------------------------------------
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tos.h>
#include <aes.h>

#include	"..\Include\JToolBox.h"
#include	"toolsdef.h"

/* ---------------------------------------------------------------------------------------------- */

extern	TRecipient		Recipient;
extern	long				IDSempahore;

/*
 * ----------------------------------------------------------------------------------------------
 */

int GetEEPROM( char *chEEPROM )
/*
*/
{
	long			L_lSPID, L_lTPID;
    int				L_inCode;
    unsigned int	L_inLenght;

	Psemaphore( SEM_LOCK, IDSempahore, -1L);

    SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_EEPROMGET,0 , NULL);
    while( GetFrame( &L_lSPID, &L_lTPID, &L_inCode,	&L_inLenght, (void *)&Recipient) == ERR_NO_FRAME )
    	;

    if( L_inCode == FRAME_EEPROMGET )
    {
		memcpy( chEEPROM, (char *)&Recipient, SIZE_SERIAL_EEPROM);		
	    L_inCode	=	JTB_OK;
    }
    else
	    L_inCode	=	JTB_FRAME_MISMATCH;
	    
	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	return	L_inCode;	   
}

int SetEEPROM( char *chEEPROM )
/*
*/
{
	long			L_lSPID, L_lTPID;
    int				L_inCode;
    unsigned int	L_inLenght;

	Psemaphore( SEM_LOCK, IDSempahore, -1L);

    SendFrame( TOOLBOX_PID, KERNEL_PID, FRAME_EEPROMSET, SIZE_SERIAL_EEPROM, chEEPROM );
    while( GetFrame( &L_lSPID, &L_lTPID, &L_inCode,	&L_inLenght, (void *)&Recipient) == ERR_NO_FRAME )
    	;

    L_inCode	=	( L_inCode == FRAME_EEPROMSET ) ? JTB_OK : JTB_FRAME_MISMATCH;

	Psemaphore( SEM_UNLOCK, IDSempahore, -1L);
	return	L_inCode;
}
